package pickewanalysis;

import javax.swing.table.AbstractTableModel;
import pickewanalysis.Configuration;
import pickewanalysis.PickEWAnalysis;

public class PreferencesTableModel extends AbstractTableModel {

    //Variables
    private String[] columnNames = new String[]{"Preference", "Value"};
    private String[] parameterNames = new String[]{
        "RestartLength", "MaxGap", "NoCoda"
    };
    PickEWAnalysis parent;
    
    Configuration config;
    
    public PreferencesTableModel(Configuration config, PickEWAnalysis parent) {
        this.config = config;
        this.parent = parent;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return parameterNames.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return parameterNames[row];
        } else {
            switch (row) {
                case 0:
                    return String.valueOf(config.RestartLength);
                case 1:
                    return String.valueOf(config.MaxGap);
                case 2:
                    return String.valueOf(config.NoCoda);
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            return true;
        }
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        try {
            switch (row) {
                case 0:
                    config.RestartLength = Integer.valueOf((String) value);
                    break;
                case 1:
                    config.MaxGap = Integer.valueOf((String) value);
                    break;
                case 2:
                    config.NoCoda = Integer.valueOf((String) value);
                    break;
            }
            //Save configuration
            config.save(config.configFile);
            //Update traces
            parent.updateTracePanel();
        } catch (Exception e) {
            //Invalid input value
            return;
        }
    }
}
