/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hypo;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.SQLHypocenterDataSource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Importer {
    protected SQLHypocenterDataSource dataSource;
    protected static Set<String> flags = new HashSet<String>();
    protected static Set<String> keys = new HashSet<String>();

    public Importer(SQLHypocenterDataSource ds) {
        this.dataSource = ds;
    }

    public static SQLHypocenterDataSource getDataSource(Arguments args) {
        String name;
        String cfn = args.get("-c");
        if (cfn == null) {
            Importer.outputInstructions();
        }
        if ((name = args.get("-n")) == null) {
            Importer.outputInstructions();
        }
        SQLHypocenterDataSource ds = new SQLHypocenterDataSource();
        ConfigFile cf = new ConfigFile(cfn);
        return ds;
    }

    public abstract List<Hypocenter> importResource(String var1);

    protected void insert(List<Hypocenter> hypos) {
        for (Hypocenter hc : hypos) {
            this.dataSource.insertHypocenter(hc);
        }
    }

    protected static void outputInstructions() {
        System.out.println("<importer> -c [vdx config] -n [database name] files...");
        System.exit(-1);
    }

    protected static void process(Arguments args, Importer impt) {
        List<String> resources;
        if (args.size() == 0) {
            Importer.outputInstructions();
        }
        if ((resources = args.unused()) == null || resources.size() == 0) {
            System.out.println("no files");
            System.exit(-1);
        }
        for (String res : resources) {
            System.out.println("Reading resource: " + res);
            impt.insert(impt.importResource(res));
        }
    }

    static {
        keys.add("-n");
        keys.add("-c");
    }
}

