/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.render.MatrixRenderer;
import gov.usgs.vdx.data.Exportable;
import java.util.Map;

public class MatrixExporter
extends MatrixRenderer
implements Exportable {
    protected int numCols;
    protected boolean[] visible;
    protected int expIndex;
    protected double timeOffset;

    public MatrixExporter(DoubleMatrix2D d, boolean ranks, Map<Integer, String> axisMap, double time_offset) {
        super(d, ranks);
        this.init_me(d, ranks, axisMap, time_offset);
    }

    public MatrixExporter(DoubleMatrix2D d, boolean ranks, Map<Integer, String> axisMap) {
        super(d, ranks);
        this.init_me(d, ranks, axisMap, 0.0);
    }

    public MatrixExporter(DoubleMatrix2D d, boolean ranks) {
        super(d, ranks);
        this.init_me(d, ranks, null, 0.0);
    }

    private void init_me(DoubleMatrix2D d, boolean ranks, Map<Integer, String> axisMap, double time_offset) {
        this.timeOffset = time_offset;
        if (axisMap == null) {
            this.visible = new boolean[1];
            this.visible[0] = true;
            this.numCols = 1;
        } else {
            this.visible = new boolean[axisMap.size()];
            this.numCols = 0;
            for (int i = 0; i < this.visible.length; ++i) {
                if (axisMap.get(i).equals("")) {
                    this.visible[i] = false;
                    continue;
                }
                this.visible[i] = true;
                ++this.numCols;
            }
        }
        this.resetExport();
    }

    @Override
    public void resetExport() {
        this.expIndex = 0;
    }

    @Override
    public Double[] getNextExportRow() {
        if (this.expIndex >= this.getData().rows()) {
            return null;
        }
        Double[] row = new Double[this.numCols + 1];
        row[0] = this.getData().getQuick(this.expIndex, 0) + this.timeOffset;
        int jr = 0;
        for (int j = 0; j < this.visible.length; ++j) {
            if (!this.visible[j]) continue;
            row[jr + 1] = this.getData().getQuick(this.expIndex, j + this.getOffset());
            ++jr;
        }
        ++this.expIndex;
        return row;
    }

    @Override
    public int length() {
        return -1;
    }
}

