/*
 * Decompiled with CFR 0.152.
 */
package com.isti.dhi;

import com.isti.dhi.ChannelInfo;
import com.isti.dhi.FissuresUtils;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import java.util.Date;

public class DhiChannel
extends ChannelInfo {
    public DhiChannel(Channel channelObj) {
        this(channelObj.get_id());
    }

    public DhiChannel(ChannelId channel_id) {
        super(DhiChannel.getStationName(channel_id), DhiChannel.getChannelName(channel_id), DhiChannel.getNetworkName(channel_id), DhiChannel.getLocationName(channel_id), DhiChannel.getChannelBeginTime(channel_id), DhiChannel.getNetworkBeginTime(channel_id));
    }

    public DhiChannel(LocalSeismogram localSeismogram) {
        this(localSeismogram.channel_id);
    }

    private static Date getChannelBeginTime(ChannelId channel_id) {
        Date channelBeginTime = FissuresUtils.getDate(channel_id.begin_time);
        return channelBeginTime;
    }

    private static String getChannelName(ChannelId channel_id) {
        return channel_id.channel_code;
    }

    private static String getLocationName(ChannelId channel_id) {
        String locationName = channel_id.site_code;
        return locationName;
    }

    private static Date getNetworkBeginTime(ChannelId channel_id) {
        Date networkBeginTime = FissuresUtils.getDate(channel_id.network_id.begin_time);
        return networkBeginTime;
    }

    private static String getNetworkName(ChannelId channel_id) {
        String networkName = channel_id.network_id.network_code;
        return networkName;
    }

    private static String getStationName(ChannelId channel_id) {
        String stationName = channel_id.station_code;
        return stationName;
    }
}

