/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;

class RrdUpdateCmd
extends RrdToolCmd {
    RrdUpdateCmd() {
    }

    String getCmdType() {
        return "update";
    }

    Object execute() throws IOException {
        String template = this.getOptionValue("t", "template");
        String[] dsNames = template != null ? new ColonSplitter(template).split() : null;
        String[] words = this.getRemainingWords();
        if (words.length < 3) {
            throw new IllegalArgumentException("Insufficent number of parameters for rrdupdate command");
        }
        String path = words[1];
        RrdDb rrdDb = RrdUpdateCmd.getRrdDbReference(path);
        try {
            if (dsNames != null) {
                String[] stringArray = dsNames;
                int n = dsNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String dsName = stringArray[n2];
                    if (!rrdDb.containsDs(dsName)) {
                        throw new IllegalArgumentException("Invalid datasource name: " + dsName);
                    }
                    ++n2;
                }
            }
            long timestamp = -1L;
            int i = 2;
            while (i < words.length) {
                String[] tokens = new ColonSplitter(words[i]).split();
                if (dsNames != null && dsNames.length + 1 != tokens.length) {
                    throw new IllegalArgumentException("Template requires " + dsNames.length + " values, " + (tokens.length - 1) + " value(s) found in: " + words[i]);
                }
                int dsCount = rrdDb.getHeader().getDsCount();
                if (dsNames == null && dsCount + 1 != tokens.length) {
                    throw new IllegalArgumentException("Expected " + dsCount + " values, " + (tokens.length - 1) + " value(s) found in: " + words[i]);
                }
                timestamp = Util.getTimestamp(tokens[0]);
                Sample sample = rrdDb.createSample(timestamp);
                int j = 1;
                while (j < tokens.length) {
                    if (dsNames == null) {
                        sample.setValue(j - 1, RrdUpdateCmd.parseDouble(tokens[j]));
                    } else {
                        sample.setValue(dsNames[j - 1], RrdUpdateCmd.parseDouble(tokens[j]));
                    }
                    ++j;
                }
                sample.update();
                ++i;
            }
            Long l = new Long(timestamp);
            return l;
        }
        finally {
            RrdUpdateCmd.releaseRrdDbReference(rrdDb);
        }
    }
}

