/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.gps;

import gov.usgs.util.Util;
import gov.usgs.vdx.data.gps.GPS;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Scanner;
import java.util.TimeZone;

public class Stacov {
    public String fileName;
    public String name;
    public String[] code;
    public int nStations;
    public double j2ksec0;
    public double j2ksec1;
    public double[][] data;
    public double[][] covariance;
    public boolean isValid = true;

    private static double parseTime(String timeStamp) throws ParseException {
        String pattern = "yyMMMdd";
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        double t = Util.dateToJ2K(format.parse(timeStamp));
        return t;
    }

    public double[] llh(int i) {
        if (i < this.nStations) {
            return GPS.xyz2LLH(this.data[0][i], this.data[1][i], this.data[2][i]);
        }
        return null;
    }

    public Stacov(String stacovFile) throws FileNotFoundException, ParseException {
        this.fileName = stacovFile;
        this.read();
    }

    private void read() throws FileNotFoundException, ParseException {
        int j;
        int i;
        Scanner s = new Scanner(new BufferedReader(new FileReader(this.fileName)));
        if (!s.hasNextInt()) {
            this.isValid = false;
            return;
        }
        this.nStations = s.nextInt() / 3;
        if (!s.next().equals("PARAMETERS")) {
            this.isValid = false;
            return;
        }
        this.name = this.fileName.split("/")[this.fileName.split("/").length - 1];
        s.next();
        this.j2ksec0 = Stacov.parseTime(s.next());
        this.j2ksec1 = this.j2ksec0 + 86400.0;
        this.data = new double[3][this.nStations];
        this.covariance = new double[6][this.nStations];
        this.code = new String[this.nStations];
        for (i = 0; i < this.nStations; ++i) {
            for (j = 0; j < 3; ++j) {
                s.next();
                this.code[i] = s.next();
                s.next();
                s.next();
                this.data[j][i] = s.nextDouble();
                s.next();
                this.covariance[j][i] = s.nextDouble();
            }
        }
        int c = 3;
        while (s.hasNextInt()) {
            i = (s.nextInt() - 1) / 3;
            if (i == (j = (s.nextInt() - 1) / 3)) {
                this.covariance[c][i] = s.nextDouble();
                if (++c != 6) continue;
                c = 3;
                continue;
            }
            s.nextDouble();
        }
        s.close();
        for (i = 0; i < this.nStations; ++i) {
            this.covariance[3][i] = this.covariance[0][i] * this.covariance[1][i] * this.covariance[3][i];
            this.covariance[4][i] = this.covariance[0][i] * this.covariance[2][i] * this.covariance[4][i];
            this.covariance[5][i] = this.covariance[1][i] * this.covariance[2][i] * this.covariance[5][i];
            this.covariance[0][i] = this.covariance[0][i] * this.covariance[0][i];
            this.covariance[1][i] = this.covariance[1][i] * this.covariance[1][i];
            this.covariance[2][i] = this.covariance[2][i] * this.covariance[2][i];
        }
    }
}

