/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.PropertyStringParser;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateStringParser
extends PropertyStringParser {
    private SimpleDateFormat format = null;

    public static DateStringParser getParser() {
        return new DateStringParser();
    }

    public void setUp() throws ParseException {
        String string = this.getProperty("format");
        if (string == null) {
            this.format = new SimpleDateFormat();
        } else {
            try {
                this.format = new SimpleDateFormat(string);
            }
            catch (RuntimeException runtimeException) {
                throw new ParseException(runtimeException);
            }
        }
    }

    public void tearDown() {
        this.format = null;
    }

    public Object parse(String string) throws ParseException {
        Date date = null;
        try {
            date = this.format.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Unable to convert '" + string + "' to a Date.", parseException);
        }
        return date;
    }
}

