/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class OriginQuality {
    public static final String ELEMENT_NAME = "quality";
    Integer associatedPhaseCount;
    Integer usedPhaseCount;
    Integer associatedStationCount;
    Integer usedStationCount;
    Integer depthPhaseCount;
    Float standardError;
    Float azimuthalGap;
    Float secondaryAzimuthalGap;
    Float maximumDistance;
    Float minimumDistance;
    Float medianDistance;
    String groundTruthLevel;

    public OriginQuality(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("associatedPhaseCount")) {
                    this.associatedPhaseCount = Integer.parseInt(StaxUtil.pullText(reader, "associatedPhaseCount"));
                    continue;
                }
                if (elName.equals("usedPhaseCount")) {
                    this.usedPhaseCount = Integer.parseInt(StaxUtil.pullText(reader, "usedPhaseCount"));
                    continue;
                }
                if (elName.equals("associatedStationCount")) {
                    this.associatedStationCount = Integer.parseInt(StaxUtil.pullText(reader, "associatedStationCount"));
                    continue;
                }
                if (elName.equals("usedStationCount")) {
                    this.usedStationCount = Integer.parseInt(StaxUtil.pullText(reader, "usedStationCount"));
                    continue;
                }
                if (elName.equals("depthPhaseCount")) {
                    this.depthPhaseCount = Integer.parseInt(StaxUtil.pullText(reader, "depthPhaseCount"));
                    continue;
                }
                if (elName.equals("standardError")) {
                    this.standardError = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "standardError")));
                    continue;
                }
                if (elName.equals("azimuthalGap")) {
                    this.azimuthalGap = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "azimuthalGap")));
                    continue;
                }
                if (elName.equals("secondaryAzimuthalGap")) {
                    this.secondaryAzimuthalGap = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "secondaryAzimuthalGap")));
                    continue;
                }
                if (elName.equals("maximumDistance")) {
                    this.maximumDistance = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "maximumDistance")));
                    continue;
                }
                if (elName.equals("minimumDistance")) {
                    this.minimumDistance = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "minimumDistance")));
                    continue;
                }
                if (elName.equals("medianDistance")) {
                    this.medianDistance = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "medianDistance")));
                    continue;
                }
                if (elName.equals("groundTruthLevel")) {
                    this.groundTruthLevel = StaxUtil.pullText(reader, "groundTruthLevel");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Integer getAssociatedPhaseCount() {
        return this.associatedPhaseCount;
    }

    public Integer getUsedPhaseCount() {
        return this.usedPhaseCount;
    }

    public Integer getAssociatedStationCount() {
        return this.associatedStationCount;
    }

    public Integer getUsedStationCount() {
        return this.usedStationCount;
    }

    public Integer getDepthPhaseCount() {
        return this.depthPhaseCount;
    }

    public Float getStandardError() {
        return this.standardError;
    }

    public Float getAzimuthalGap() {
        return this.azimuthalGap;
    }

    public Float getSecondaryAzimuthalGap() {
        return this.secondaryAzimuthalGap;
    }

    public Float getMaximumDistance() {
        return this.maximumDistance;
    }

    public Float getMinimumDistance() {
        return this.minimumDistance;
    }

    public Float getMedianDistance() {
        return this.medianDistance;
    }

    public String getGroundTruthLevel() {
        return this.groundTruthLevel;
    }
}

