/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.math.Util;
import gov.usgs.plot.Plot;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.LineRenderer;
import gov.usgs.plot.render.RectangleRenderer;
import gov.usgs.plot.render.Renderer;
import gov.usgs.plot.render.ShapeRenderer;
import gov.usgs.plot.render.TextRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class AxisRenderer
implements Renderer {
    private Color backgroundColor;
    private Color color;
    private RectangleRenderer frame;
    protected static NumberFormat numberFormat = DecimalFormat.getInstance();
    protected FrameRenderer frameRenderer;
    private Renderer leftLabel;
    private Renderer topLabel;
    private Renderer rightLabel;
    private Renderer bottomLabel;
    private Renderer bottomLeftLabel;
    private Renderer bottomRightLabel;
    protected Renderer[] bottomTicks;
    protected Renderer[] bottomLabels;
    protected Renderer[] topTicks;
    protected Renderer[] topLabels;
    public Renderer[] leftTicks;
    private Renderer[] leftLabels;
    private Renderer[] rightTicks;
    private Renderer[] rightLabels;
    private Renderer[] horizGridLines;
    private Renderer[] vertGridLines;
    private List<Renderer> renderers;
    private List<Renderer> postRenderers;

    public AxisRenderer(FrameRenderer fr) {
        this.frameRenderer = fr;
        this.color = Color.black;
        this.renderers = new ArrayList<Renderer>();
        this.postRenderers = new ArrayList<Renderer>();
    }

    public RectangleRenderer getFrame() {
        return this.frame;
    }

    public FrameRenderer getFrameRenderer() {
        return this.frameRenderer;
    }

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
    }

    public void addPostRenderer(Renderer r) {
        this.postRenderers.add(r);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void createDefault() {
        if (this.frameRenderer != null) {
            if (this.frame == null) {
                this.frame = new RectangleRenderer();
            }
            this.frame.rect.x = this.frameRenderer.getGraphX();
            this.frame.rect.y = this.frameRenderer.getGraphY();
            this.frame.rect.width = this.frameRenderer.getGraphWidth();
            this.frame.rect.height = this.frameRenderer.getGraphHeight();
        }
    }

    public void createBottomTicks(double[] ticks) {
        this.createBottomTicks(ticks, 10.0, Color.BLACK);
    }

    public void createBottomTicks(double[] ticks, double length, Color color) {
        if (this.bottomTicks == null || this.bottomTicks.length != ticks.length) {
            this.bottomTicks = new Renderer[ticks.length];
        }
        double minY = this.frameRenderer.getMinY();
        for (int i = 0; i < ticks.length; ++i) {
            LineRenderer lr = new LineRenderer();
            lr.line = new Line2D.Double(this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(minY) - length);
            lr.color = color;
            lr.stroke = LineRenderer.TICK_STROKE;
            this.bottomTicks[i] = lr;
        }
    }

    public void createBottomTicks(double[] majorTicks, double[] minorTicks) {
        this.createBottomTicks(majorTicks, minorTicks, null);
    }

    public void createBottomTicks(double[] majorTicks, double[] minorTicks, Color color) {
        ShapeRenderer sr;
        int j;
        int numTicks = 0;
        if (majorTicks != null) {
            numTicks += majorTicks.length;
        }
        if (minorTicks != null) {
            numTicks += minorTicks.length;
        }
        double majorLength = 10.0;
        double minorLength = 5.0;
        this.bottomTicks = new Renderer[numTicks];
        double minY = this.frameRenderer.getMinY();
        int i = 0;
        if (majorTicks != null) {
            for (j = 0; j < majorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(minY) - majorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.bottomTicks[i++] = sr;
            }
        }
        if (minorTicks != null) {
            for (j = 0; j < minorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(minY) - minorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.bottomTicks[i++] = sr;
            }
        }
    }

    public void createBottomTickLabels(double[] ticks, String[] labels) {
        this.createBottomTickLabels(ticks, labels, null);
    }

    public void createBottomTickLabels(double[] ticks, String[] labels, Color color) {
        this.bottomLabels = new Renderer[ticks.length];
        double minY = this.frameRenderer.getMinY();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            tr.text = labels != null ? labels[i] : numberFormat.format(ticks[i]);
            tr.x = (float)this.frameRenderer.getXPixel(ticks[i]);
            tr.y = (float)this.frameRenderer.getYPixel(minY);
            tr.horizJustification = 1;
            tr.vertJustification = 4;
            if (color != null) {
                tr.color = color;
            }
            this.bottomLabels[i] = tr;
        }
    }

    public void createBottomLongitudeTickLabels(double[] ticks, String[] labels) {
        this.bottomLabels = new Renderer[ticks.length];
        double minY = this.frameRenderer.getMinY();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            if (labels != null) {
                tr.text = labels[i];
            } else {
                double t = ticks[i];
                if (t < -180.0) {
                    t = 180.0 + (t + 180.0);
                }
                tr.text = numberFormat.format(t);
            }
            tr.x = (float)this.frameRenderer.getXPixel(ticks[i]);
            tr.y = (float)this.frameRenderer.getYPixel(minY);
            tr.horizJustification = 1;
            tr.vertJustification = 4;
            this.bottomLabels[i] = tr;
        }
    }

    public void createTopTicks(double[] ticks) {
        this.createTopTicks(ticks, 10.0, Color.BLACK);
    }

    public void createTopTicks(double[] ticks, double length, Color color) {
        if (this.topTicks == null || this.topTicks.length != ticks.length) {
            this.topTicks = new Renderer[ticks.length];
        }
        double maxY = this.frameRenderer.getMaxY();
        for (int i = 0; i < ticks.length; ++i) {
            LineRenderer lr = new LineRenderer();
            lr.line = new Line2D.Double(this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(maxY), this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(maxY) + length);
            lr.color = color;
            lr.stroke = LineRenderer.TICK_STROKE;
            this.topTicks[i] = lr;
        }
    }

    public void createTopTicks(double[] majorTicks, double[] minorTicks) {
        this.createTopTicks(majorTicks, minorTicks, null);
    }

    public void createTopTicks(double[] majorTicks, double[] minorTicks, Color color) {
        ShapeRenderer sr;
        int j;
        int numTicks = 0;
        if (majorTicks != null) {
            numTicks += majorTicks.length;
        }
        if (minorTicks != null) {
            numTicks += minorTicks.length;
        }
        double majorLength = 10.0;
        double minorLength = 5.0;
        this.topTicks = new Renderer[numTicks];
        double maxY = this.frameRenderer.getMaxY();
        int i = 0;
        if (majorTicks != null) {
            for (j = 0; j < majorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(maxY), this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(maxY) + majorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.topTicks[i++] = sr;
            }
        }
        if (minorTicks != null) {
            for (j = 0; j < minorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(maxY), this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(maxY) + minorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.topTicks[i++] = sr;
            }
        }
    }

    public void createTopTickLabels(double[] ticks, String[] labels) {
        this.topLabels = new Renderer[ticks.length];
        double maxY = this.frameRenderer.getMaxY();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            tr.text = labels != null ? labels[i] : numberFormat.format(ticks[i]);
            tr.x = (float)this.frameRenderer.getXPixel(ticks[i]);
            tr.y = (float)this.frameRenderer.getYPixel(maxY);
            tr.horizJustification = 1;
            tr.vertJustification = 5;
            this.topLabels[i] = tr;
        }
    }

    public void createLeftTicks(double[] ticks) {
        this.createLeftTicks(ticks, 10.0, Color.BLACK);
    }

    public void createLeftTicks(double[] ticks, double width, Color color) {
        if (this.leftTicks == null || this.leftTicks.length != ticks.length) {
            this.leftTicks = new Renderer[ticks.length];
        }
        double minX = this.frameRenderer.getMinX();
        for (int i = 0; i < ticks.length; ++i) {
            double value = ticks[i];
            ShapeRenderer sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(minX), this.frameRenderer.getYPixel(value), this.frameRenderer.getXPixel(minX) + width, this.frameRenderer.getYPixel(value)));
            sr.color = color;
            sr.stroke = LineRenderer.TICK_STROKE;
            this.leftTicks[i] = sr;
        }
    }

    public void createFormattedLeftTickLabels(double[] ticks, String format) {
        this.leftLabels = new Renderer[ticks.length];
        double minX = this.frameRenderer.getMinX();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            tr.text = String.format(format, ticks[i]);
            tr.x = (float)this.frameRenderer.getXPixel(minX) - 2.0f;
            tr.y = (float)this.frameRenderer.getYPixel(ticks[i]);
            tr.horizJustification = 3;
            tr.vertJustification = 1;
            this.leftLabels[i] = tr;
        }
    }

    public void createLeftTickLabels(double[] ticks, String[] labels) {
        this.createLeftTickLabels(ticks, labels, null);
    }

    public void createLeftTickLabels(double[] ticks, String[] labels, Color color) {
        if (labels == null) {
            labels = new String[ticks.length];
            double min = 1.0E300;
            double max = -1.0E300;
            for (int i = 0; i < ticks.length; ++i) {
                if (ticks[i] > max) {
                    max = ticks[i];
                }
                if (!(ticks[i] < min)) continue;
                min = ticks[i];
            }
            double exp = Util.getExp(max = Math.max(Math.abs(max), Math.abs(min)));
            boolean reformat = exp >= 5.0 || exp <= -4.0;
            for (int i = 0; i < ticks.length; ++i) {
                labels[i] = reformat ? numberFormat.format(ticks[i] / Math.pow(10.0, exp)) : numberFormat.format(ticks[i]);
            }
            if (reformat) {
                TextRenderer tr = new TextRenderer();
                tr.text = "x 10^" + numberFormat.format(exp);
                tr.x = (float)this.frameRenderer.getXPixel(this.frameRenderer.getMinX()) - 55.0f;
                tr.y = (float)this.frameRenderer.getYPixel(this.frameRenderer.getMinY()) - 10.0f;
                tr.horizJustification = 2;
                tr.vertJustification = 1;
                if (color != null) {
                    tr.color = color;
                }
                this.addRenderer(tr);
            }
        }
        this.leftLabels = new Renderer[ticks.length];
        double minX = this.frameRenderer.getMinX();
        for (int i = 0; i < ticks.length; ++i) {
            if (labels[i] == null) continue;
            TextRenderer tr = new TextRenderer();
            tr.text = labels[i];
            tr.x = (float)this.frameRenderer.getXPixel(minX) - 2.0f;
            tr.y = (float)this.frameRenderer.getYPixel(ticks[i]);
            tr.horizJustification = 3;
            tr.vertJustification = 1;
            if (color != null) {
                tr.color = color;
            }
            this.leftLabels[i] = tr;
        }
    }

    public void createRightTicks(double[] ticks) {
        this.createRightTicks(ticks, true, 10.0, Color.BLACK);
    }

    public void createRightTicks(double[] ticks, boolean isYTicks, double width, Color color) {
        if (this.rightTicks == null || this.rightTicks.length != ticks.length) {
            this.rightTicks = new Renderer[ticks.length];
        }
        double maxX = this.frameRenderer.getMaxX();
        if (isYTicks) {
            for (int i = 0; i < ticks.length; ++i) {
                double value = ticks[i];
                ShapeRenderer sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(maxX) - width, this.frameRenderer.getYPixel(value), this.frameRenderer.getXPixel(maxX), this.frameRenderer.getYPixel(value)));
                sr.color = color;
                sr.stroke = LineRenderer.TICK_STROKE;
                this.rightTicks[i] = sr;
            }
        }
    }

    public void createRightTickLabels(double[] ticks, String[] labels) {
        if (labels == null) {
            labels = new String[ticks.length];
            double min = 1.0E300;
            double max = -1.0E300;
            for (int i = 0; i < ticks.length; ++i) {
                if (ticks[i] > max) {
                    max = ticks[i];
                }
                if (!(ticks[i] < min)) continue;
                min = ticks[i];
            }
            double exp = Util.getExp(max = Math.max(Math.abs(max), Math.abs(min)));
            boolean reformat = exp >= 5.0 || exp <= -4.0;
            for (int i = 0; i < ticks.length; ++i) {
                labels[i] = reformat ? numberFormat.format(ticks[i] / Math.pow(10.0, exp)) : numberFormat.format(ticks[i]);
            }
            if (reformat) {
                TextRenderer tr = new TextRenderer();
                tr.text = "x 10^" + numberFormat.format(exp);
                tr.x = (float)this.frameRenderer.getXPixel(this.frameRenderer.getMaxX()) + 15.0f;
                tr.y = (float)this.frameRenderer.getYPixel(this.frameRenderer.getMinY()) - 4.0f;
                tr.horizJustification = 2;
                tr.vertJustification = 1;
                this.addRenderer(tr);
            }
        }
        this.rightLabels = new Renderer[ticks.length];
        double maxX = this.frameRenderer.getMaxX();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            tr.text = labels[i];
            tr.x = (float)this.frameRenderer.getXPixel(maxX) + 2.0f;
            tr.y = (float)this.frameRenderer.getYPixel(ticks[i]);
            tr.horizJustification = 2;
            tr.vertJustification = 1;
            this.rightLabels[i] = tr;
        }
    }

    public void createHorizontalGridLines(double[] lines) {
        this.createHorizontalGridLines(lines, Color.GRAY, LineRenderer.DASHED_STROKE);
    }

    public void createHorizontalGridLines(double[] lines, Color color, Stroke stroke) {
        this.horizGridLines = new Renderer[lines.length];
        double minX = this.frameRenderer.getMinX();
        double maxX = this.frameRenderer.getMaxX();
        for (int i = 0; i < lines.length; ++i) {
            double value = lines[i];
            LineRenderer lr = new LineRenderer();
            lr.line = new Line2D.Double(this.frameRenderer.getXPixel(minX), this.frameRenderer.getYPixel(value), this.frameRenderer.getXPixel(maxX), this.frameRenderer.getYPixel(value));
            lr.stroke = stroke;
            lr.color = color;
            this.horizGridLines[i] = lr;
        }
    }

    public void createVerticalGridLines(double[] lines) {
        this.createVerticalGridLines(lines, Color.GRAY, LineRenderer.DASHED_STROKE);
    }

    public void createVerticalGridLines(double[] lines, Color color, Stroke stroke) {
        this.vertGridLines = new Renderer[lines.length];
        double minY = this.frameRenderer.getMinY();
        double maxY = this.frameRenderer.getMaxY();
        for (int i = 0; i < lines.length; ++i) {
            double value = lines[i];
            LineRenderer lr = new LineRenderer();
            lr.line = new Line2D.Double(this.frameRenderer.getXPixel(value), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(value), this.frameRenderer.getYPixel(maxY));
            lr.stroke = stroke;
            lr.color = color;
            this.vertGridLines[i] = lr;
        }
    }

    public void setTopLabel(Renderer r) {
        this.topLabel = r;
    }

    public void setTopLabelAsText(String s) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.x = (float)this.frameRenderer.getGraphWidth() / 2.0f + (float)this.frameRenderer.getGraphX();
        tr.y = -4.0f + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 1;
        tr.vertJustification = 5;
        this.topLabel = tr;
    }

    public void setBottomLabel(Renderer r) {
        this.bottomLabel = r;
    }

    public TextRenderer setBottomLabelAsText(String s) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.x = (float)this.frameRenderer.getGraphWidth() / 2.0f + (float)this.frameRenderer.getGraphX();
        tr.y = (float)this.frameRenderer.getGraphHeight() + 24.0f + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 1;
        tr.vertJustification = 1;
        this.bottomLabel = tr;
        return tr;
    }

    public void setInnerLeftLabelAsText(String s, float x) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.orientation = 270.0f;
        tr.x = x + (float)this.frameRenderer.getGraphX();
        tr.y = (float)this.frameRenderer.getGraphHeight() / 2.0f + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 1;
        tr.vertJustification = 1;
        this.bottomLeftLabel = tr;
    }

    public void setBottomLeftLabelAsText(String s) {
        this.setBottomLeftLabelAsText(s, 0.0f, 24.0f);
    }

    public void setBottomLeftLabelAsText(String s, float x, float y) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.x = (float)this.frameRenderer.getGraphX() + x;
        tr.y = (float)this.frameRenderer.getGraphHeight() + y + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 3;
        tr.vertJustification = 1;
        this.bottomLeftLabel = tr;
    }

    public void setBottomRightLabelAsText(String s) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.x = (float)this.frameRenderer.getGraphX() + (float)this.frameRenderer.getGraphWidth();
        tr.y = (float)this.frameRenderer.getGraphHeight() + 24.0f + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 2;
        tr.vertJustification = 1;
        this.bottomRightLabel = tr;
    }

    public Renderer getBottomLabel() {
        return this.bottomLabel;
    }

    public Renderer getBottomLeftRenderer() {
        return this.bottomLeftLabel;
    }

    public Renderer getLeftLabel() {
        return this.leftLabel;
    }

    public void setLeftLabel(Renderer r) {
        this.leftLabel = r;
    }

    public void setLeftLabelAsText(String s) {
        this.setLeftLabelAsText(s, Color.black);
    }

    public void setLeftLabelAsText(String s, float x) {
        this.setLeftLabelAsText(s, x, Color.black);
    }

    public void setLeftLabelAsText(String s, Color c) {
        this.setLeftLabelAsText(s, -45.0f, c);
    }

    public void setLeftLabelAsText(String s, float x, Color c) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.orientation = 270.0f;
        tr.color = c;
        tr.x = x + (float)this.frameRenderer.getGraphX();
        tr.y = (float)this.frameRenderer.getGraphHeight() / 2.0f + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 1;
        tr.vertJustification = 1;
        this.leftLabel = tr;
    }

    public Renderer getRightLabel() {
        return this.rightLabel;
    }

    public void setRightLabel(Renderer r) {
        this.rightLabel = r;
    }

    public void setRightLabelAsText(String s) {
        this.setRightLabelAsText(s, Color.black);
    }

    public void setRightLabelAsText(String s, Color c) {
        TextRenderer tr = new TextRenderer();
        tr.text = s;
        tr.orientation = 270.0f;
        tr.x = (float)this.frameRenderer.getGraphWidth() + 45.0f + (float)this.frameRenderer.getGraphX();
        tr.y = (float)this.frameRenderer.getGraphHeight() / 2.0f + (float)this.frameRenderer.getGraphY();
        tr.horizJustification = 1;
        tr.vertJustification = 1;
        tr.color = c;
        this.rightLabel = tr;
    }

    public void setFrame(RectangleRenderer r) {
        this.frame = r;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setLeftLabels(Renderer[] r) {
        this.leftLabels = r;
    }

    public Renderer[] getLeftLabels() {
        return this.leftLabels;
    }

    public void setBottomLabels(Renderer[] r) {
        this.bottomLabels = r;
    }

    @Override
    public void render(Graphics2D g) {
        Color origColor = g.getColor();
        if (this.backgroundColor != null) {
            Paint origPaint = g.getPaint();
            g.setPaint(this.backgroundColor);
            g.fill(new Rectangle(this.frameRenderer.getGraphX(), this.frameRenderer.getGraphY(), this.frameRenderer.getGraphWidth(), this.frameRenderer.getGraphHeight()));
            g.setPaint(origPaint);
        }
        if (this.color != null) {
            g.setColor(Color.black);
        }
        Plot.renderArray(g, this.horizGridLines);
        Plot.renderArray(g, this.vertGridLines);
        Plot.renderArray(g, this.bottomTicks);
        Plot.renderArray(g, this.topTicks);
        Plot.renderArray(g, this.leftTicks);
        Plot.renderArray(g, this.rightTicks);
        if (this.frame != null) {
            this.frame.render(g);
        }
        Plot.renderArray(g, this.bottomLabels);
        Plot.renderArray(g, this.leftLabels);
        Plot.renderArray(g, this.topLabels);
        Plot.renderArray(g, this.rightLabels);
        if (this.topLabel != null) {
            this.topLabel.render(g);
        }
        if (this.leftLabel != null) {
            this.leftLabel.render(g);
        }
        if (this.bottomLabel != null) {
            this.bottomLabel.render(g);
        }
        if (this.rightLabel != null) {
            this.rightLabel.render(g);
        }
        if (this.bottomLeftLabel != null) {
            this.bottomLeftLabel.render(g);
        }
        if (this.bottomRightLabel != null) {
            this.bottomRightLabel.render(g);
        }
        for (Renderer renderer : this.renderers) {
            renderer.render(g);
        }
        g.setColor(origColor);
    }

    public void postRender(Graphics2D g) {
        for (Renderer renderer : this.postRenderers) {
            renderer.render(g);
        }
    }

    static {
        numberFormat.setMaximumFractionDigits(3);
    }
}

