/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StringHolder;
import org.omg.GIOP.IORAddressingInfoHelper;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.LocateStatusType_1_2Holder;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.TargetAddressHolder;
import org.omg.GIOP.Version;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHolder;
import org.omg.IOP.TaggedProfileHelper;

public final class GIOPIncomingMessage {
    private ORBInstance orbInstance_;
    private InputStream in_;
    private static int maxMessageSize_;
    private Version version_ = new Version();
    private boolean byteOrder_;
    private boolean fragment_;
    private MsgType_1_1 type_;
    private int size_;
    private Fragment fragmentHead_;
    private Fragment lastFragment_;

    private int readFragmentHeader(InputStream inputStream) {
        int n = 0;
        switch (this.version_.minor) {
            case 0: {
                Assert.assert(false);
            }
            case 1: {
                Assert.assert(false);
            }
            case 2: {
                n = inputStream.read_ulong();
                break;
            }
            default: {
                Assert.assert(false);
            }
        }
        return n;
    }

    private void skipServiceContextList(InputStream inputStream) {
        int n = inputStream.read_ulong();
        int n2 = 0;
        while (n2 < n) {
            inputStream._OB_skipAlign(4);
            inputStream._OB_skip(4);
            int n3 = inputStream.read_ulong();
            inputStream._OB_skip(n3);
            ++n2;
        }
    }

    private void readServiceContextList(ServiceContextListHolder serviceContextListHolder) {
        int n = this.in_.read_ulong();
        serviceContextListHolder.value = new ServiceContext[n];
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                serviceContextListHolder.value[n2] = new ServiceContext();
                ServiceContext serviceContext = serviceContextListHolder.value[n2];
                serviceContext.context_id = this.in_.read_ulong();
                int n3 = this.in_.read_ulong();
                serviceContext.context_data = new byte[n3];
                this.in_.read_octet_array(serviceContext.context_data, 0, n3);
                ++n2;
            }
        }
    }

    private void readTargetAddress(TargetAddressHolder targetAddressHolder) {
        targetAddressHolder.value = new TargetAddress();
        short s = this.in_.read_short();
        switch (s) {
            case 0: {
                int n = this.in_.read_ulong();
                byte[] byArray = new byte[n];
                this.in_.read_octet_array(byArray, 0, n);
                targetAddressHolder.value.object_key(byArray);
                return;
            }
            case 1: {
                targetAddressHolder.value.profile(TaggedProfileHelper.read(this.in_));
                return;
            }
            case 2: {
                targetAddressHolder.value.ior(IORAddressingInfoHelper.read(this.in_));
                return;
            }
        }
        throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577425)) + ": invalid target address", 1330577425, CompletionStatus.COMPLETED_MAYBE);
    }

    GIOPIncomingMessage(ORBInstance oRBInstance) {
        this.orbInstance_ = oRBInstance;
        this.fragmentHead_ = null;
        this.lastFragment_ = null;
    }

    Version version() {
        return this.version_;
    }

    boolean swap() {
        return this.byteOrder_;
    }

    MsgType_1_1 type() {
        return this.type_;
    }

    int size() {
        return this.size_;
    }

    InputStream input() {
        InputStream inputStream = this.in_;
        this.in_ = null;
        return inputStream;
    }

    void extractHeader(Buffer buffer) {
        this.in_ = null;
        byte[] byArray = buffer.data();
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 79 || byArray[3] != 80) {
            throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577425)) + ": missing GIOP magic key", 1330577425, CompletionStatus.COMPLETED_MAYBE);
        }
        this.version_.major = byArray[4];
        this.version_.minor = byArray[5];
        if (this.version_.major != 1 || this.version_.minor > 2) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577433), 1330577433, CompletionStatus.COMPLETED_MAYBE);
        }
        InputStream inputStream = new InputStream(buffer, 0, false);
        switch (this.version_.minor) {
            case 0: {
                inputStream._OB_skip(6);
                this.byteOrder_ = inputStream.read_boolean();
                inputStream._OB_swap(this.byteOrder_);
                this.fragment_ = false;
                this.type_ = MsgType_1_1.from_int(inputStream.read_octet());
                this.size_ = inputStream.read_ulong();
                if (this.type_.value() <= 6) break;
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577426)) + ": invalid message type for GIOP 1.0", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: 
            case 2: {
                inputStream._OB_skip(6);
                byte by = inputStream.read_octet();
                this.byteOrder_ = (by & 1) == 1;
                this.fragment_ = (by & 2) == 2;
                inputStream._OB_swap(this.byteOrder_);
                this.type_ = MsgType_1_1.from_int(inputStream.read_octet());
                this.size_ = inputStream.read_ulong();
                if (this.type_.value() <= 7) break;
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577426)) + ": invalid message type for GIOP 1.1/1.2", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                Assert.assert(false);
            }
        }
        if (maxMessageSize_ > 0 && this.size_ > maxMessageSize_) {
            String string = "incoming message size (" + this.size_ + ") exceeds maximum (" + maxMessageSize_ + ")";
            this.orbInstance_.getLogger().warning(string);
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577409), 1330577409, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.version_.minor == 2 && this.fragment_ && (this.size_ + 12) % 8 != 0) {
            throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577430)) + ": invalid GIOP 1.2 fragment size", 1330577430, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    boolean consumeBuffer(Buffer buffer) {
        boolean bl = false;
        if (this.fragment_ && this.type_ != MsgType_1_1.Fragment) {
            if (this.version_.minor < 1) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.version_.minor == 1) {
                if (this.type_ != MsgType_1_1.Request && this.type_ != MsgType_1_1.Reply) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
                }
                if (this.lastFragment_ != null) {
                    this.lastFragment_ = null;
                }
                int n = 0;
                boolean bl2 = false;
                try {
                    InputStream inputStream = new InputStream(buffer, 12, this.swap());
                    this.skipServiceContextList(inputStream);
                    n = inputStream.read_ulong();
                    bl2 = true;
                }
                catch (MARSHAL mARSHAL) {}
                this.lastFragment_ = new Fragment();
                this.lastFragment_.version = new Version(this.version_.major, this.version_.minor);
                this.lastFragment_.byteOrder = this.byteOrder_;
                this.lastFragment_.reqId = n;
                this.lastFragment_.haveReqId = bl2;
                this.lastFragment_.type = this.type_;
                this.lastFragment_.buf = buffer;
                this.lastFragment_.next = null;
            } else {
                Object object;
                if (this.type_ != MsgType_1_1.Request && this.type_ != MsgType_1_1.Reply && this.type_ != MsgType_1_1.LocateRequest && this.type_ != MsgType_1_1.LocateReply) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
                }
                int n = 0;
                boolean bl3 = false;
                try {
                    object = new InputStream(buffer, 12, this.swap());
                    n = ((InputStream)object).read_ulong();
                    bl3 = true;
                }
                catch (MARSHAL mARSHAL) {}
                Assert.assert(bl3);
                object = new Fragment();
                ((Fragment)object).version = new Version(this.version_.major, this.version_.minor);
                ((Fragment)object).byteOrder = this.byteOrder_;
                ((Fragment)object).reqId = n;
                ((Fragment)object).haveReqId = bl3;
                ((Fragment)object).type = this.type_;
                ((Fragment)object).buf = buffer;
                ((Fragment)object).next = this.fragmentHead_;
                this.fragmentHead_ = object;
            }
        } else if (this.type_ == MsgType_1_1.Fragment) {
            Fragment fragment = null;
            if (this.version_.minor < 1) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.version_.minor == 1) {
                if (this.lastFragment_ == null) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
                }
                this.lastFragment_.add(this.orbInstance_, buffer);
                if (!this.lastFragment_.haveReqId) {
                    InputStream inputStream = new InputStream(this.lastFragment_.buf, 12, this.swap());
                    try {
                        this.skipServiceContextList(inputStream);
                        this.lastFragment_.reqId = inputStream.read_ulong();
                        this.lastFragment_.haveReqId = true;
                    }
                    catch (MARSHAL mARSHAL) {}
                }
                if (!this.fragment_) {
                    fragment = this.lastFragment_;
                    this.lastFragment_ = null;
                }
            } else {
                InputStream inputStream = new InputStream(buffer, 12, this.swap());
                int n = this.readFragmentHeader(inputStream);
                Fragment fragment2 = null;
                Fragment fragment3 = this.fragmentHead_;
                Fragment fragment4 = null;
                while (fragment3 != null) {
                    Fragment fragment5 = fragment3;
                    if (fragment5.haveReqId && fragment5.reqId == n) {
                        fragment2 = fragment5;
                        break;
                    }
                    fragment4 = fragment3;
                    fragment3 = fragment5.next;
                }
                if (fragment2 != null) {
                    fragment2.add(this.orbInstance_, inputStream._OB_buffer());
                    if (!this.fragment_) {
                        if (fragment4 == null) {
                            this.fragmentHead_ = fragment2.next;
                        } else {
                            fragment4.next = fragment2.next;
                        }
                        fragment = fragment2;
                    }
                }
            }
            if (fragment != null) {
                this.version_ = fragment.version;
                this.byteOrder_ = fragment.byteOrder;
                this.type_ = fragment.type;
                this.fragment_ = false;
                this.size_ = fragment.buf.length();
                this.in_ = new InputStream(fragment.buf, 12, this.swap());
                fragment = null;
                bl = true;
            }
        } else if (this.type_ == MsgType_1_1.CancelRequest) {
            this.in_ = new InputStream(buffer, 12, this.swap());
            int n = this.readCancelRequestHeader();
            if (this.version_.minor == 1) {
                if (this.lastFragment_ != null && this.lastFragment_.haveReqId && this.lastFragment_.reqId == n) {
                    this.lastFragment_ = null;
                }
            } else {
                Fragment fragment = this.fragmentHead_;
                while (fragment != null) {
                    Fragment fragment6 = fragment;
                    if (fragment6.haveReqId && fragment6.reqId == n) {
                        fragment = fragment6.next;
                        fragment6 = null;
                        break;
                    }
                    fragment = fragment6.next;
                }
            }
            this.in_._OB_reset();
            bl = true;
        } else {
            this.in_ = new InputStream(buffer, 12, this.swap());
            bl = true;
        }
        return bl;
    }

    int readRequestHeader(BooleanHolder booleanHolder, TargetAddressHolder targetAddressHolder, StringHolder stringHolder, ServiceContextListHolder serviceContextListHolder) {
        Assert.assert(this.type_ == MsgType_1_1.Request);
        int n = 0;
        switch (this.version_.minor) {
            case 0: {
                this.readServiceContextList(serviceContextListHolder);
                n = this.in_.read_ulong();
                booleanHolder.value = this.in_.read_boolean();
                int n2 = this.in_.read_ulong();
                byte[] byArray = new byte[n2];
                this.in_.read_octet_array(byArray, 0, n2);
                targetAddressHolder.value = new TargetAddress();
                targetAddressHolder.value.object_key(byArray);
                n2 = this.in_.read_ulong();
                byte[] byArray2 = new byte[n2];
                this.in_.read_octet_array(byArray2, 0, n2);
                stringHolder.value = new String(byArray2, 0, n2 - 1);
                n2 = this.in_.read_ulong();
                if (n2 <= 0) break;
                this.in_._OB_skip(n2);
                break;
            }
            case 1: {
                this.readServiceContextList(serviceContextListHolder);
                n = this.in_.read_ulong();
                booleanHolder.value = this.in_.read_boolean();
                this.in_._OB_skip(3);
                int n3 = this.in_.read_ulong();
                byte[] byArray = new byte[n3];
                this.in_.read_octet_array(byArray, 0, n3);
                targetAddressHolder.value = new TargetAddress();
                targetAddressHolder.value.object_key(byArray);
                n3 = this.in_.read_ulong();
                byte[] byArray3 = new byte[n3];
                this.in_.read_octet_array(byArray3, 0, n3);
                stringHolder.value = new String(byArray3, 0, n3 - 1);
                n3 = this.in_.read_ulong();
                if (n3 <= 0) break;
                this.in_._OB_skip(n3);
                break;
            }
            case 2: {
                n = this.in_.read_ulong();
                byte by = this.in_.read_octet();
                booleanHolder.value = (by & 1) == 1;
                this.in_._OB_skip(3);
                this.readTargetAddress(targetAddressHolder);
                int n4 = this.in_.read_ulong();
                byte[] byArray = new byte[n4];
                this.in_.read_octet_array(byArray, 0, n4);
                stringHolder.value = new String(byArray, 0, n4 - 1);
                this.readServiceContextList(serviceContextListHolder);
                if (this.in_._OB_pos() >= this.size_ + 12) break;
                this.in_._OB_skipAlign(8);
                break;
            }
            default: {
                Assert.assert(false);
            }
        }
        return n;
    }

    int readReplyHeader(ReplyStatusType_1_2Holder replyStatusType_1_2Holder, ServiceContextListHolder serviceContextListHolder) {
        Assert.assert(this.type_ == MsgType_1_1.Reply);
        int n = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                this.readServiceContextList(serviceContextListHolder);
                n = this.in_.read_ulong();
                replyStatusType_1_2Holder.value = ReplyStatusType_1_2.from_int(this.in_.read_ulong());
                if (replyStatusType_1_2Holder.value.value() <= 3) break;
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577426)) + ": invalid reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                n = this.in_.read_ulong();
                replyStatusType_1_2Holder.value = ReplyStatusType_1_2.from_int(this.in_.read_ulong());
                if (replyStatusType_1_2Holder.value.value() > 5) {
                    throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577426)) + ": invalid reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
                }
                this.readServiceContextList(serviceContextListHolder);
                if (this.in_._OB_pos() >= this.size_ + 12) break;
                this.in_._OB_skipAlign(8);
                break;
            }
            default: {
                Assert.assert(false);
            }
        }
        return n;
    }

    int readCancelRequestHeader() {
        Assert.assert(this.type_ == MsgType_1_1.CancelRequest);
        int n = this.in_.read_ulong();
        return n;
    }

    int readLocateRequestHeader(TargetAddressHolder targetAddressHolder) {
        Assert.assert(this.type_ == MsgType_1_1.LocateRequest);
        int n = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                n = this.in_.read_ulong();
                int n2 = this.in_.read_ulong();
                byte[] byArray = new byte[n2];
                this.in_.read_octet_array(byArray, 0, n2);
                targetAddressHolder.value = new TargetAddress();
                targetAddressHolder.value.object_key(byArray);
                break;
            }
            case 2: {
                n = this.in_.read_ulong();
                this.readTargetAddress(targetAddressHolder);
                break;
            }
            default: {
                Assert.assert(false);
            }
        }
        return n;
    }

    int readLocateReplyHeader(LocateStatusType_1_2Holder locateStatusType_1_2Holder) {
        Assert.assert(this.type_ == MsgType_1_1.LocateReply);
        int n = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                n = this.in_.read_ulong();
                locateStatusType_1_2Holder.value = LocateStatusType_1_2.from_int(this.in_.read_ulong());
                if (locateStatusType_1_2Holder.value.value() <= 2) break;
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577426)) + ": invalid locate reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                n = this.in_.read_ulong();
                locateStatusType_1_2Holder.value = LocateStatusType_1_2.from_int(this.in_.read_ulong());
                if (locateStatusType_1_2Holder.value.value() > 5) {
                    throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577426)) + ": invalid locate reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
                }
                if (this.in_._OB_pos() >= this.size_ + 12) break;
                this.in_._OB_skipAlign(8);
                break;
            }
            default: {
                Assert.assert(false);
            }
        }
        return n;
    }

    public static void setMaxMessageSize(int n) {
        maxMessageSize_ = n;
    }

    private class Fragment {
        private Version version;
        private boolean byteOrder;
        private int reqId;
        private boolean haveReqId;
        private MsgType_1_1 type;
        private Buffer buf;
        Fragment next;

        void add(ORBInstance oRBInstance, Buffer buffer) {
            int n = this.buf.length();
            if (maxMessageSize_ > 0 && n + buffer.rest_length() > maxMessageSize_) {
                String string = "incoming fragment exceeds maximum message size (" + maxMessageSize_ + ")";
                GIOPIncomingMessage.this.orbInstance_.getLogger().warning(string);
                throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            this.buf.realloc(n + buffer.rest_length());
            System.arraycopy(buffer.data(), buffer.pos(), this.buf.data(), n, buffer.rest_length());
        }

        Fragment() {
            GIOPIncomingMessage.this = GIOPIncomingMessage.this;
        }
    }
}

