/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.station;

import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.fdsn.FdsnException;
import gov.usgs.winston.server.cmd.http.fdsn.command.FdsnQueryCommand;
import gov.usgs.winston.server.cmd.http.fdsn.station.FdsnStationService;
import java.io.StringWriter;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class FdsnStationQuery
extends FdsnQueryCommand
implements FdsnStationService {
    private static final String DEFAULT_LEVEL = "station";

    public FdsnStationQuery(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
        this.version = "1.1.0";
        this.channels = new Channels(this.winston);
    }

    @Override
    protected void sendResponse() {
        if (!this.arguments.containsKey("level")) {
            this.arguments.put("level", DEFAULT_LEVEL);
        }
        try {
            if ("text".equals(this.arguments.get("format"))) {
                this.sendText();
            } else {
                this.sendXml();
            }
        }
        catch (FdsnException e) {
            this.sendError(e.code, e.message);
        }
    }

    private void sendText() throws FdsnException {
        if (this.prunedChanList.length == 0) {
            throw new FdsnException(404, "no data");
        }
        String responseText = null;
        String level = (String)this.arguments.get("level");
        if ("network".equals(level)) {
            responseText = this.generateNetworkText();
        } else if ("channel".equals(level)) {
            responseText = this.generateChannelText();
        } else if (DEFAULT_LEVEL.equals(level)) {
            responseText = this.generateStationText();
        } else {
            throw new FdsnException(404, "no data");
        }
        HttpResponse response = new HttpResponse("text/plain");
        response.setLength(responseText.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(responseText, this.socketChannel);
    }

    private String generateNetworkText() {
        StringBuilder out = new StringBuilder();
        out.append("#Network | Description | StartTime | EndTime | TotalStations \n");
        double stationStart = Double.MAX_VALUE;
        double stationEnd = -1.7976931348623157E308;
        Channel previousChannel = null;
        int stationCount = 0;
        for (Channel c : this.prunedChanList) {
            if (previousChannel == null) {
                previousChannel = c;
            }
            if (!c.network.equals(previousChannel.network)) {
                out.append(previousChannel.network + " |  | " + dateFormat.format(Util.j2KToDate(stationStart)) + " | " + dateFormat.format(Util.j2KToDate(stationEnd)) + " | " + stationCount + "\n");
                stationStart = c.getMinTime();
                stationEnd = c.getMaxTime();
                stationCount = 0;
            } else {
                ++stationCount;
                stationStart = Math.min(stationStart, c.getMinTime());
                stationEnd = Math.max(stationEnd, c.getMaxTime());
            }
            previousChannel = c;
        }
        out.append(previousChannel.network + " |  | " + dateFormat.format(Util.j2KToDate(stationStart)) + " | " + dateFormat.format(Util.j2KToDate(stationEnd)) + " | " + stationCount + "\n");
        return out.toString();
    }

    private String generateStationText() {
        StringBuilder out = new StringBuilder();
        out.append("#Network | Station | Latitude | Longitude | Elevation | SiteName | StartTime | EndTime\n");
        double stationStart = Double.MAX_VALUE;
        double stationEnd = -1.7976931348623157E308;
        Channel previousChannel = null;
        for (Channel c : this.prunedChanList) {
            if (previousChannel == null) {
                previousChannel = c;
            }
            if (!c.station.equals(previousChannel.station)) {
                out.append(c.network + "|" + c.station + "|" + c.getInstrument().getLatitude() + "|" + c.getInstrument().getLongitude() + "|" + c.getInstrument().getHeight() + "|" + c.getInstrument().getDescription() + "|" + dateFormat.format(Util.j2KToDate(stationStart)) + "|" + dateFormat.format(Util.j2KToDate(stationEnd)) + "\n");
                stationStart = c.getMinTime();
                stationEnd = c.getMaxTime();
            } else {
                stationStart = Math.min(stationStart, c.getMinTime());
                stationEnd = Math.max(stationEnd, c.getMaxTime());
            }
            previousChannel = c;
        }
        out.append(previousChannel.network + "|" + previousChannel.station + "|" + previousChannel.getInstrument().getLatitude() + "|" + previousChannel.getInstrument().getLongitude() + "|" + previousChannel.getInstrument().getHeight() + "|" + previousChannel.getInstrument().getName() + "|" + dateFormat.format(Util.j2KToDate(stationStart)) + "|" + dateFormat.format(Util.j2KToDate(stationEnd)) + "\n");
        stationStart = Double.MAX_VALUE;
        stationEnd = -1.7976931348623157E308;
        return out.toString();
    }

    private String generateChannelText() {
        StringBuilder out = new StringBuilder();
        out.append("#Network | Station | Location | Channel | Latitude | Longitude | Elevation | Depth | Azimuth | Dip | Instrument | Scale | ScaleFreq | ScaleUnits | SampleRate | StartTime | EndTime\n");
        for (Channel c : this.prunedChanList) {
            String loc = c.location.equals("--") ? "  " : c.location;
            out.append(c.network + "|" + c.station + "|" + loc + "|" + c.channel + "|" + c.getInstrument().getLatitude() + "|" + c.getInstrument().getLongitude() + "|" + c.getInstrument().getHeight() + "||||||||||" + dateFormat.format(Util.j2KToDate(c.getMinTime())) + "|" + dateFormat.format(Util.j2KToDate(c.getMaxTime())) + "\n");
        }
        return out.toString();
    }

    private void sendXml() throws FdsnException {
        if (this.prunedChanList.length == 0) {
            throw new FdsnException(404, "no data");
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new FdsnException(404, "no data");
        }
        Document doc = dBuilder.newDocument();
        Element rootElement = this.createRootElement(doc);
        Element networkElement = null;
        Element stationElement = null;
        double stationStart = Double.MAX_VALUE;
        double stationEnd = -1.7976931348623157E308;
        String net = null;
        String sta = null;
        String level = (String)this.arguments.get("level");
        for (Channel c : this.prunedChanList) {
            if (!c.network.equals(net)) {
                net = c.network;
                networkElement = doc.createElement("Network");
                networkElement.setAttribute("code", net);
                rootElement.appendChild(networkElement);
            }
            if ("network".equals(level)) continue;
            if (!c.station.equals(sta)) {
                if (stationElement != null) {
                    String s = dateFormat.format(Util.j2KToDate(stationStart));
                    stationElement.setAttribute("startDate", s);
                    stationStart = Double.MAX_VALUE;
                    String e = dateFormat.format(Util.j2KToDate(stationEnd));
                    stationElement.setAttribute("endDate", e);
                    stationEnd = -1.7976931348623157E308;
                    Element creationElement = doc.createElement("CreationDate");
                    creationElement.appendChild(doc.createTextNode(dateFormat.format(Util.j2KToDate(stationStart))));
                }
                sta = c.station;
                stationElement = this.createStationElement(c, doc);
                networkElement.appendChild(stationElement);
            }
            stationStart = Math.min(stationStart, c.getMinTime());
            stationEnd = Math.max(stationEnd, c.getMaxTime());
            if (DEFAULT_LEVEL.equals(level)) continue;
            stationElement.appendChild(this.createChannelElement(c, doc));
        }
        DOMImplementation impl = doc.getImplementation();
        DOMImplementationLS implLS = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSSerializer lsSerializer = implLS.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("format-pretty-print", true);
        LSOutput lsOutput = implLS.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        lsSerializer.write(doc, lsOutput);
        String responseXml = ((Object)stringWriter).toString();
        if (responseXml == null || responseXml.length() == 0) {
            throw new FdsnException(404, "no data");
        }
        HttpResponse response = new HttpResponse("application/xml");
        response.setLength(responseXml.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(responseXml, this.socketChannel);
    }

    private Element createRootElement(Document doc) {
        Element rootElement = doc.createElement("FDSNStationXML");
        rootElement.setAttribute("schemaVersion", "1.0");
        rootElement.setAttribute("xsi:schemaLocation", "http://www.fdsn.org/xml/station/fdsn-station-1.0.xsd");
        rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttribute("xmlns", "http://www.fdsn.org/xml/station/1");
        doc.appendChild(rootElement);
        Element source = doc.createElement("source");
        source.appendChild(doc.createTextNode("Winston"));
        rootElement.appendChild(source);
        Element module = doc.createElement("module");
        module.appendChild(doc.createTextNode("Winston " + WWS.getVersion()));
        rootElement.appendChild(module);
        Element created = doc.createElement("Created");
        created.appendChild(doc.createTextNode(dateFormat.format(new Date(System.currentTimeMillis()))));
        rootElement.appendChild(created);
        return rootElement;
    }

    private Element createStationElement(Channel c, Document doc) {
        Element station = doc.createElement("Station");
        station.setAttribute("code", c.station);
        Element e = doc.createElement("Latitude");
        e.appendChild(doc.createTextNode("" + c.getInstrument().getLatitude()));
        station.appendChild(e);
        e = doc.createElement("Longitude");
        e.appendChild(doc.createTextNode("" + c.getInstrument().getLongitude()));
        station.appendChild(e);
        e = doc.createElement("Elevation");
        e.appendChild(doc.createTextNode("" + c.getInstrument().getHeight()));
        station.appendChild(e);
        e = doc.createElement("Site");
        Element n = doc.createElement("Name");
        n.appendChild(doc.createTextNode(c.getInstrument().getDescription()));
        e.appendChild(n);
        station.appendChild(e);
        return station;
    }

    private Element createChannelElement(Channel c, Document doc) {
        Element channelElement = doc.createElement("Channel");
        String loc = c.location.equals("--") ? "  " : c.location;
        channelElement.setAttribute("locationCode", loc);
        channelElement.setAttribute("code", c.channel);
        Element e = doc.createElement("Latitude");
        e.appendChild(doc.createTextNode("" + c.getInstrument().getLatitude()));
        channelElement.appendChild(e);
        e = doc.createElement("Longitude");
        e.appendChild(doc.createTextNode("" + c.getInstrument().getLongitude()));
        channelElement.appendChild(e);
        e = doc.createElement("Elevation");
        e.appendChild(doc.createTextNode("" + c.getInstrument().getHeight()));
        channelElement.appendChild(e);
        e = doc.createElement("Depth");
        e.setAttribute("Supported", "no");
        e.appendChild(doc.createTextNode("0"));
        channelElement.appendChild(e);
        return channelElement;
    }

    @Override
    public String getCommand() {
        return "/fdsnws/station/1/query";
    }
}

