

/* Times to traverse all of J-B crust radialy. */
#define P_JB_CRUST_TIME CONRAD*PGSLOW/KM_PER_DEG+(MOHO-CONRAD)*PBSLOW/KM_PER_DEG
#define S_JB_CRUST_TIME CONRAD*SGSLOW/KM_PER_DEG+(MOHO-CONRAD)*SBSLOW/KM_PER_DEG

/* Height*density of JB crust for isostatic corrections. */
#define JB_ISO_HEIGHT CONRAD*UPPER_RHO + (MOHO-CONRAD)*LOWER_RHO

struct crust_rec {
	char descrip[80];
	double p_vel[8];
	double s_vel[8];
	double density[8];
	double thick[9];
};

struct crust_rec c_type[360] = {
{
	" D0	Platform 2.0 km seds. 0",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 12 , 13 , 9.0 , 9999 , 36 },
},
{
	" D1	Platform 11.5 km seds. 1",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 10.	, 10.5 , 11 , 8.0 , 9999 , 41 },
},
{
	" D2	Platform 10 km seds. 2",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 8.5 , 10 , 13 , 8.0 , 9999 , 41 },
},
{
	" D3	Platform 38 km, 5.0 km seds. 3",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 12 , 13 , 8.0 , 9999 , 38 },
},
{
	" D4	Platform 46 km, 5.0 km seds. 4",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 15.0 , 16.0 , 10.0 , 9999 , 46 },
},
{
	" D5	thick Platform 2.0 km seds. 5",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 16 , 17 , 11 , 9999 , 46 },
},
{
	" D6	Platform 2.0 km seds. 6",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 15 , 15 , 9.0 , 9999 , 41 },
},
{
	" D7	Platform 4.0 km seds. 7",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 14 , 14 , 9.0 , 9999 , 41 },
},
{
	" D8     thick Platform 3.0 km seds. 8",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 16 , 16 , 11 , 9999 , 46 },
},
{
	" D9	Platform 1.0 km seds. 9",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 16 , 15 , 9.0 , 9999 , 41 },
},
{
	" DA     Platform 6.0 km seds. 10",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 13 , 13 , 9.0 , 9999 , 41 },
},
{
	" DB     Platform 3.0 km seds. 11",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 15 , 14 , 9.0 , 9999 , 41 },
},
{
	" DC	Platform 0.5 km seds. 12",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 15.5 , 16 , 9.0 , 9999 , 41 },
},
{
	" DD     Platform 5.0 km seds. 13",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 14 , 13 , 9.0 , 9999 , 41 },
},
{
	" DE	thick Platform 1.0 km seds. 14",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 17 , 17 , 11 , 9999 , 46 },
},
{
	" DF	thick Platform 0.0 km seds. 15",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 17 , 17 , 16 , 9999 , 50 },
},
{
	" DG	thin Platform 1.0 km seds. 16",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 10 , 10 , 10 , 9999 , 31 },
},
{
	" DH	thin Platform 4.0 km seds. 17",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 10 , 10 , 10 , 9999 , 34 },
},
{
	" DJ	thin Platform 8.0 km seds. 18",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 8.0 , 9.0 , 9.0 , 9999 , 34 },
},
{
	" DK	Platform 46 km, 7.0 km seds. 19",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 5.5 , 14.0 , 15.0 , 10.0 , 9999 , 46 },
},
{
	" DL     Platform 8.0 km seds. 20",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 11 , 11 , 11 , 9999 , 41 },
},
{
	" DM	thin Platform 10 km seds. 21",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 8.5 , 8.0 , 8.0 , 8.0 , 9999 , 34 },
},
{
	" DN	thin Platform 6.0 km seds. 22",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 9.0 , 9.0 , 10 , 9999 , 34 },
},
{
	" DP	thin Platform 7.5 km seds. 23",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 6.5 , 10.0 , 10.0 , 10.5 , 9999 , 38 },
},
{
	" DQ	thin Platform 3.5 km seds. 24",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 11 , 11 , 10.5 , 9999 , 36 },
},
{
	" DR	thin Platform 1.0 km seds. 25",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 12 , 12 , 11 , 9999 , 36 },
},
{
	" DS	thick Platform 3.0 km seds. 26",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 16 , 16 , 15 , 9999 , 50 },
},
{
	" DT	thin Platform 0.5 km seds. 27",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 12 , 13.5 , 12 , 9999 , 38 },
},
{
	" DU	thick Platform 0.5 km seds. 28",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 17.5 , 17 , 11 , 9999 , 46 },
},
{
	" DV	thin Platform 6.5 km seds. 29",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 5.5 , 10.0 , 10.5 , 11 , 9999 , 38 },
},
{
	" DW	thin Platform 6.5 km seds. 30",
	{ 3.81 , 1.5 , 2.5 , 4.3 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 5.5 , 9.0 , 9.5 , 9.0 , 9999 , 34 },
},
{
	" DX	Platform 9.0 km seds. 31",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 7.5 , 11 , 13 , 8.0 , 9999 , 41 },
},
{
	" DY	thin Platform 5.0 km seds. 32",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 8.0 , 9.0 , 9.0 , 9999 , 31 },
},
{
	" DZ	Platform 46 km, 8.0 km seds. 33",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 14.0 , 14.0 , 10.0 , 9999 , 46 },
},
{
	" E1	thin Platform 2.5 km seds. 34",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 10 , 10.5 , 11 , 9999 , 34 },
},
{
	" E2	thin Platform 0.0 km seds. 35",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 10 , 10 , 11 , 9999 , 31 },
},
{
	" F2	 Archean 0.5 km ice, no seds. 36",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.5 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 37.5 },
},
{
	" F3	 Archean 1.0 km ice, no seds. 37",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 1.0 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 38 },
},
{
	" F4	Archean 1.5 km ice, no seds. 38",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 1.5 , 0.0 , 0.0 , 0.0 , 13.0 , 12.0 , 12.0 , 9999 , 38.5 },
},
{
	" F5	Archean 2.0 km ice, no seds. 39",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 2.0 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 39 },
},
{
	" F6	Archean 2.5 km ice, no seds. 40",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 2.5 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 39.5 },
},
{
	" F7	Archean 3.0 km ice, no seds. 41",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.0 , 0.0 , 0.0 , 0.0 , 13.0 , 12.0 , 12.0 , 9999 , 40 },
},
{
	" F8	Archean 3.5 km ice, no seds. 42",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.5 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 40.5 },
},
{
	" F9	Archean 4.0 km ice, no seds. 43",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 4.0 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 41 },
},
{
	" FA	Archean 3.0 km ice, 2.5km seds. 44",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.0 , 0.0 , 1.5 , 1.0 , 11.0 , 11.5 , 12.0 , 9999 , 40 },
},
{
	" FB	 Archean 0.5 km ice, 1.5 seds. 45",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.5 , 0.0 , 0.5 , 1.0 , 12 , 12 , 12 , 9999 , 38 },
},
{
	" FC	 Archean 3.0 km ice, 1.5 seds. 46",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.0 , 0.0 , 0.25 , 1.25 , 11.5 , 12 , 12 , 9999 , 40 },
},
{
	" FD	Archean 1.5 km ice, 1.5km seds. 47",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 1.5 , 0.0 , 0.5 , 1.0 , 11.0 , 12 , 12.0 , 9999 , 38 },
},
{
	" FF	Archean 2.5 km ice, 1.5km seds. 48",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 2.5 , 0.0 , 0.5 , 1.0 , 12.0 , 12 , 12.0 , 9999 , 40 },
},
{
	" FG	Archean 3.5 km ice, 2.5km seds. 49",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.5 , 0.0 , 1.5 , 1.0 , 11.0 , 11.0 , 12.0 , 9999 , 40 },
},
{
	" FH	Archean 2.5 km ice, 2.5km seds. 50",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 2.5 , 0.0 , 1.5 , 1.0 , 12.0 , 11.0 , 12.0 , 9999 , 40 },
},
{
	" FJ	Archean 1.5 km ice, 0.5km seds. 51",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 1.5 , 0.0 , 0.5 , 0.0 , 13.0 , 12 , 13.0 , 9999 , 40 },
},
{
	" FK	 Archean 3.5 km ice, 1.5 seds. 52",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.5 , 0.0 , 0.25 , 1.25 , 11 , 11 , 11 , 9999 , 38 },
},
{
	" FL	 Archean 1.0 km ice, 1.5 seds. 53",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 1.0 , 0.0 , 0.5 , 1.0 , 11.5 , 12 , 12 , 9999 , 38 },
},
{
	" FM	Archean 2.5 km ice, 1.0km seds. 54",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 2.5 , 0.0 , 0.5 , 0.5 , 12.0 , 12 , 12.0 , 9999 , 39.5 },
},
{
	" FN	Archean 3.0 km ice, 1.0km seds. 55",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 3.0 , 0.0 , 0.5 , 0.5 , 12.0 , 12.0 , 12.0 , 9999 , 40 },
},
{
	" FP	Archean 2.0 km ice, 1.0km seds. 56",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 2.0 , 0.0 , 0.5 , 0.5 , 12.0 , 12.0 , 12.0 , 9999 , 39 },
},
{
	" FQ	Archean 1.5 km ice, 1.0km seds. 57",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 1.5 , 0.0 , 0.5 , 0.5 , 12.0 , 12.0 , 12.0 , 9999 , 38.5 },
},
{
	" G0	Archean 1.0 km seds., Hudson Platform 58",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 13 , 12 , 13 , 9999 , 39 },
},
{
	" G1	Archean, no seds. 59",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 13 , 12 , 12 , 9999 , 37 },
},
{
	" G2     Archean 0.5 km seds. 60",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 12.5 , 13.0 , 13.0 , 9999 , 39 },
},
{
	" G3     Archean 2.0 km seds. 61",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 13 , 13 , 13 , 9999 , 41 },
},
{
	" G4     Archean 3.5 km seds. 62",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 12.0 , 12.5 , 13.0 , 9999 , 41 },
},
{
	" G5     Archean 6.5 km seds. 63",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 5.0 , 9.5 , 12.0 , 13.0 , 9999 , 41 },
},
{
	" G6     Archean, no seds. 64",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 15.0 , 15.0 , 15.0 , 9999 , 45 },
},
{
	" G7     Archean, no seds. 65",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 16.0 , 17.0 , 17.0 , 9999 , 50 },
},
{
	" G8     Archean, 1km seds. 66",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 14.0 , 15.0 , 15.0 , 9999 , 45 },
},
{
	" G9	thin custal Archean 0.1 km seds., South American  67",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.1 , 0.0 , 10 , 10 , 10.9 , 9999 , 31 },
},
{
	" GA     thin costal Archean 3.5 km seds., South America 68",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 8.5 , 9.0 , 9.0 , 9999 , 30 },
},
{
	" GB     thin Archean 2.0 km seds. 69",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 10 , 11 , 11 , 9999 , 34 },
},
{
	" GC	thin custal Archean 0.0 km seds., Australia       70",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 11 , 11 , 11.0 , 9999 , 33 },
},
{
	" GD     thick Archean 3.5 km seds. 71",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 14.0 , 14.5 , 15.0 , 9999 , 47 },
},
{
	" GE      Archean, no seds. 72",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 14.5 , 14 , 13 , 9999 , 41.5 },
},
{
	" GF      Archean, 0.5km seds. 73",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 15 , 14.5 , 13.5 , 9999 , 43.5 },
},
{
	" GG     thin Archean 3.5 km seds. 74",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 10.5 , 11 , 10 , 9999 , 35 },
},
{
	" GH     thin Archean 0.5 km seds. 75",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 11.5 , 12 , 11 , 9999 , 35 },
},
{
	" GJ     Archean, 8km seds. 76",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 9.0 , 12.0 , 12.0 , 9999 , 41 },
},
{
	" GK     Archean, 4.5km seds. 77",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 3.5 , 10.5 , 13.0 , 13.0 , 9999 , 41 },
},
{
	" GL     Archean, 5.5km seds. 78",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.3 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 4.0 , 10.5 , 12.0 , 13.0 , 9999 , 41 },
},
{
	" GM     thin Archean 5. km seds. 79",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 10.0 , 10.0 , 10.0 , 9999 , 35 },
},
{
	" GN     thin Archean 4.5. km seds. 80",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 3.5 , 10.5 , 10 , 10.0 , 9999 , 35 },
},
{
	" GP     thick Archean 5.0 km seds. 81",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 13.5 , 14.0 , 14.5 , 9999 , 47 },
},
{
	" GQ	thin custal Archean 1.0 km seds., South American  82",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.4 , 6.8 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.6 , 3.8 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.85 , 2.95 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.5 , 10 , 10 , 10.0 , 9999 , 31 },
},
{
	" H0      early/mid  Proter., Finland thick, no seds. 83",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 16 , 17 , 17 , 9999 , 50 },
},
{
	" H1      early/mid  Proter., no seds. 84",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 14 , 14 , 12 , 9999 , 40 },
},
{
	" H2      early/mid  Proter. shield, Finland, no seds. 85",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 15 , 16 , 14 , 9999 , 45 },
},
{
	" H3      early/mid  Proter. shield, Finland, 0.5 km seds. 86",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 15 , 16 , 14 , 9999 , 45.5 },
},
{
	" H4      early/mid  Proter. shield, Africa, 1.5 km seds. 87",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 15 , 15 , 15 , 9999 , 46.5 },
},
{
	" H5      early/mid  Proter. shield, Africa, 3.0 km seds. 88",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 15 , 15 , 15 , 9999 , 48 },
},
{
	" H6      early/mid  Proter., U.S., 1.5 km seds. 89",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 17 , 17 , 16 , 9999 , 51.5 },
},
{
	" H7      early/mid  Proter. shield, Austr., 1.5 km seds. 90",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 12 , 12 , 12.5 , 9999 , 38 },
},
{
	" H8      early/mid  Proter. shield, Austr., 3.0 km seds. 91",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 11 , 12 , 12 , 9999 , 38 },
},
{
	" H9      thin early/mid  Proter., no seds. 92",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 12 , 12 , 11 , 9999 , 35 },
},
{
	" HA      early/mid  Proter. shield, Austr., 0.5 km seds. 93",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 12 , 12.5 , 13 , 9999 , 38 },
},
{
	" HB	early/mid  Proter. shield, Austr., 4.0 km seds. 94",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 11 , 11 , 12 , 9999 , 38 },
},
{
	" HC	early/mid  Proter. shield, Austr., 3.0 km seds. 95",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 13 , 13 , 14 , 9999 , 43 },
},
{
	" HD      early/mid  Proter., U.S., 4.0 km seds. 96",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.1 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 3.9 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 15 , 15 , 16 , 9999 , 50 },
},
{
	" I1	late Proter., no seds. 97",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 15 , 15 , 13 , 9999 , 43 },
},
{
	" I2	late Proter., 1.0 km seds. 98",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 13 , 12 , 12 , 9999 , 38 },
},
{
	" I3	late Proter., 3.5 km seds. 99",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 13 , 12 , 12.5 , 9999 , 41 },
},
{
	" I4	late Proter., 2.0 km seds. 100",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 13 , 12 , 12 , 9999 , 39 },
},
{
	" I5	late Proter., 5.0 km seds. 101",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 13 , 12 , 12 , 9999 , 42 },
},
{
	" I6	late Proter., 6.0 km seds. 102",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 12 , 12 , 12 , 9999 , 42 },
},
{
	" I7	late Proter., 1.0 km seds. 103",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 13 , 14 , 14 , 9999 , 42 },
},
{
	" I8	late Proter., 7.0 km seds. 104",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 5.5 , 13 , 12 , 11 , 9999 , 43 },
},
{
	" I9	late Proter.., 9.0 km seds. 105",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 7.5 , 11 , 12 , 12 , 9999 , 44 },
},
{
	" IA	thin late Proter., 3.5 km seds. 106",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 11 , 10 , 11.5 , 9999 , 36 },
},
{
	" IB	thin late Proter., 2.0 km seds. 107",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 11 , 11 , 10 , 9999 , 34 },
},
{
	" IC	thin late Proter., 7.0 km seds. 108",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 5.5 , 10 , 10 , 9.0 , 9999 , 36 },
},
{
	" ID	late Proter., 5.0 km seds. 109",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 11 , 10 , 10 , 9999 , 36 },
},
{
	" IE	late Proter., no seds. 110",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 12 , 13 , 11 , 9999 , 36 },
},
{
	" IF	thin late Proter., 1.0 km seds. 111",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 11 , 10 , 10 , 9999 , 32 },
},
{
	" IG	very thin late Proter., no seds. 112",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 8.0 , 8.0 , 7.0 , 9999 , 23 },
},
{
	" IH	thin late Proter., 3.5 km seds. 113",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 10 , 9.5 , 9.0 , 9999 , 32 },
},
{
	" IJ	very thin late Proter., 2.0 km seds. 114",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 8.0 , 8.0 , 9.0 , 9999 , 27 },
},
{
	" IK	thin late Proter., 1.0 km seds. 115",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 12 , 11 , 11 , 9999 , 35 },
},
{
	" IL	thin late Proter., 3.5 km seds. 116",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 10 , 10.5 , 10 , 9999 , 34 },
},
{
	" IM	late Proter., 8.0 km seds. 117",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 12 , 10 , 10 , 9999 , 40 },
},
{
	" IN	very thin late Proter., 3.5 km seds. 118",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 7.0 , 7.5 , 9.0 , 9999 , 27 },
},
{
	" IO	late Proter., 0.0 km seds. 119",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 14 , 13 , 13 , 9999 , 40 },
},
{
	" IP	late Proter., 2.5 km seds. 120",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.2 , 6.6 , 7.3 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.6 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.8 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 13 , 13 , 12.5 , 9999 , 41 },
},
{
	" K1	forearc, New Zealand, 2.0 km seds. 121",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.90 , 3.05 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 16 , 8.0 , 9.0 , 9999 , 35 },
},
{
	" K2	forearc, New Zealand, 0.7 km seds. 122",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.3 },
	{ 0.0 , 0.0 , 0.7 , 0.0	, 14.3 , 9.0 , 11 , 9999 , 35 },
},
{
	" K3	forearc, New Zealand, 3.0 km seds. 123",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 13 , 11 , 10 , 9999 , 37 },
},
{
	" K4	forearc, New Zealand, 5.0 km seds. 124",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 11 , 7.0 , 9.0 , 9999 , 32 },
},
{
	" L1	continental arc, Kamchatka, Cascades, 2.0 km seds. 125",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 10.0 , 17.0 , 12.0 , 9999 , 41 },
},
{
	" L2	thin continental arc, Mexico, 2.0 km seds. 126",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 9.0 , 12.0 , 11.0 , 9999 , 34 },
},
{
	" L3	continental arc, Southern Andes, 0.2 km seds. 127",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 0.2 , 0.0 , 10.8 , 17.0 , 12.0 , 9999 , 40 },
},
{
	" L4	thin continental arc, Central America, 3.5 km seds. 128",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 8.0 , 10.0 , 10.0 , 9999 , 31.5 },
},
{
	" L5	thick continental arc, Southern Andes, 2.0 km seds. 129",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 14.5 , 16.0 , 17.0 , 9999 , 49.5 },
},
{
	" L6	continental arc, Cordilleras, 7.0 km seds. 130",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 5.5 , 9.0 , 9.0 , 10.0 , 9999 , 35 },
},
{
	" L7	continental arc, Cordilleras, 5.0 km seds. 131",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 7.0 , 7.0 , 7.5 , 9999 , 26.5 },
},
{
	" L8	thin continental arc, Cordilleras, 0.5 km seds. 132",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 10.5 , 11.0 , 12.0 , 9999 , 34 },
},
{
	" L9	continental arc, Cordilleras, 5.0 km seds. 133",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 11.0 , 10.0 , 10.0 , 9999 , 36 },
},
{
	" LA	very thin continental arc, Cordilleras, 1.0 km seds. 134",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 8.0 , 8.0 , 8.0 , 9999 , 25.0 },
},
{
	" LB	thin continental arc, Central America, 3.5 km seds. 135",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 7.0 , 8.0 , 8.0 , 9999 , 26.5 },
},
{
	" LC	continental arc, Cordilleras, 1.0 km seds. 136",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 10.0 , 14.0 , 12.0 , 9999 , 37 },
},
{
	" LD	very thin continental arc, Cordilleras, 2.0 km seds. 137",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 2.0 , 0.0 , 8.0 , 9.0 , 9.0 , 9999 , 28.0 },
},
{
	" LE	continental arc, Cordilleras, 6.0 km seds. 138",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 6.5 , 7.0 , 7.0 , 9999 , 26.5 },
},
{
	" LF	continental arc, South America, 3.0 km seds. 139",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 9.0 , 11.0 , 11.0 , 9999 , 34 },
},
{
	" M1	extended crust, 3.0 km seds. 140",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 8.0 , 10 , 10 , 9999 , 31 },
},
{
	" M2	extended crust, 2.0 km seds. 141",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 9.0 , 10 , 10 , 9999 , 31 },
},
{
	" M3	extended crust, 1.5 km seds. 142",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 9.5 , 10 , 10 , 9999 , 31 },
},
{
	" M4	medium thick extended crust, 3.0 km seds. 143",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 10 , 11 , 11 , 9999 , 35 },
},
{
	" M5	extended crust, 0.5 km seds. 144",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 10 , 10 , 10.5 , 9999 , 31 },
},
{
	" M6	extended crust, 6.0 km seds. 145",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 5.0 , 8.0 , 8.0 , 9.0 , 9999 , 31 },
},
{
	" M7	medium thick extended crust, 0.5 km seds. 146",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 11.5 , 11.5 , 11.5 , 9999 , 35 },
},
{
	" M8	thick extended crust, 1.5 km seds. 147",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 11.5 , 12 , 12 , 9999 , 37 },
},
{
	" M9	thick extended crust, 0.5 km seds. 148",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 12.5 , 13.5 , 13.5 , 9999 , 40 },
},
{
	" MB	thick extended crust, 7.0 km seds. 149",
	{ 3.81 , 1.5 , 2.5 , 4.6 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.5 , 5.5 , 11 , 11 , 12 , 9999 , 41 },
},
{
	" MC	thick extended crust, 5.5 km seds. 150",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 4.5 , 11.5 , 11 , 12 , 9999 , 40 },
},
{
	" MD	thin extended crust, 1.5 km seds. 151",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 11 , 11 , 11 , 9999 , 34.5 },
},
{
	" ME	very thin extended crust, 1.5 km seds. 152",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 9.0 , 8.5 , 8.5 , 9999 , 27.5 },
},
{
	" MF	thick extended crust, 1.5 km seds. 153",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 12.5 , 13 , 13 , 9999 , 40 },
},
{
	" MG	very thin extended crust, 0.5 km seds. 154",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 9.0 , 9.0 , 9.0 , 9999 , 27.5 },
},
{
	" MH	extended crust, 4.0 km seds. 155",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 6.6 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 3.6 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 2.9 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 8.0 , 9.0 , 10 , 9999 , 31 },
},
{
	" N1	highly extended crust, 1.0 km ice, 0.5 km seds 156",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 1.0 , 0.0 , 0.5 , 0.0 , 9.0 , 8.0 , 8.0 , 9999 , 26.5 },
},
{
	" N2	highly extended crust, 0.5 km ice 157",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 0.5 , 0.0 , 1.0 , 1.5 , 9.0 , 7.0 , 7.0 , 9999 , 26 },
},
{
	" N3	highly extended crust, 1.0 km ice 158",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 1.0 , 0.0 , 1.0 , 1.5 , 9.0 , 7.0 , 7.0 , 9999 , 26.5 },
},
{
	" N4	highly extended crust, 1.5 km ice 159",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 1.5 , 0.0 , 1.0 , 1.5 , 9.0 , 7.0 , 6.0 , 9999 , 26 },
},
{
	" N5	highly extended crust, 2.0 km ice	 160",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.0 , 0.0 , 1.0 , 1.5 , 9.0 , 7.0 , 6.0 , 9999 , 26.5 },
},
{
	" N6	highly extended crust, 2.5 km ice 161",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.5 , 0.0 , 1.0 , 1.5 , 9.0 , 6.0 , 6.0 , 9999 , 26 },
},
{
	" N7	highly extended crust, 3.0 km ice 162",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 3.0 , 0.0 , 1.0 , 1.5 , 9.0 , 6.0 , 6.0 , 9999 , 26.5 },
},
{
	" N8	highly extended crust, 1.5 km ice 163",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 1.5 , 0.0 , 0.5 , 0.0 , 9.0 , 8.0 , 8.0 , 9999 , 27 },
},
{
	" NA	highly extended crust, 0.25 km ice, 0.5km sediments 164",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 0.25 , 0.0 , 0.5 , 0.0 , 8.5 , 8.5 , 8.75 , 9999 , 26.5 },
},
{
	" NB	highly extended crust, 0.5 km ice, 0.5km sediments 165",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 0.5 , 0.0 , 0.5 , 0.0 , 8.5 , 8.5 , 9.0 , 9999 , 27 },
},
{
	" NC	highly extended crust, 2.0 km ice, 0.5km sediments 166",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.0 , 0.0 , 0.5 , 0.0 , 8.0 , 8.0 , 8.0 , 9999 , 26.5 },
},
{
	" ND	highly extended crust, 2.5 km ice, 0.5km sediments 167",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.5 , 0.0 , 0.5 , 0.0 , 8.0 , 8.0 , 8.0 , 9999 , 27 },
},
{
	" NE	highly extended crust, 2.5 km ice, 5.0km sediments 168",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.5 , 0.0 , 1.0 , 4.0 , 7.0 , 6.5 , 6.5 , 9999 , 27.5 },
},
{
	" NF	highly extended crust, 3.5 km ice 169",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 3.5 , 0.0 , 1.0 , 1.5 , 9.0 , 6.0 , 6.0 , 9999 , 27. },
},
{
	" NG	highly extended crust, 2.5 km ice 170",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.5 , 0.0 , 0.5 , 1.0 , 9.0 , 7.0 , 6.0 , 9999 , 26 },
},
{
	" NH	highly extended crust, 1.5 km ice 171",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 1.5 , 0.0 , 0.5 , 1.0 , 9.0 , 8.0 , 6.0 , 9999 , 26 },
},
{
	" NJ	highly extended crust, 2.0 km ice 172",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.0 , 0.0 , 0.5 , 1.0 , 9.0 , 8.0 , 6.0 , 9999 , 26.5 },
},
{
	" NK	highly extended crust, 2.5 km ice 173",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 2.5 , 0.0 , 0.5 , 3.0 , 8.0 , 6.0 , 6.0 , 9999 , 26 },
},
{
	" NL	highly extended crust, 3.0 km ice 174",
	{ 3.81 , 1.5 , 3.8 , 4.7 , 6.1 , 6.3 , 6.6 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.7 , 3.5 , 3.6 , 3.6 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.8 , 2.9 , 3.25 },
	{ 3.0 , 0.0 , 1.0 , 2.5 , 8.0 , 6.0 , 6.0 , 9999 , 26.5 },
},
{
	" P1	orogen/46km, Urals, Tethian Orogen, 2.0 km seds. 175",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 20 , 20 , 4.0 , 9999 , 46 },
},
{
	" P2	orogen/38km, Alps and Foreland, 2.0 km seds. 176",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 14 , 15 , 7.0 , 9999 , 38 },
},
{
	" P3	orogen/50km, Urals, Tethian Orogen, 6.0 km seds. 177",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 20 , 20 , 4.0 , 9999 , 50 },
},
{
	" P4	orogen/50km, Urals, Tethian Orogen, Rockies 1.0 km seds. 178",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 20 , 20 , 9.0 , 9999 , 50 },
},
{
	" P5	orogen/45km, Orogen, 4.0 km seds. 179",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 18 , 16 , 7.0 , 9999 , 45 },
},
{
	" P6	orogen/43km, Orogen, 0.5 km seds. 180",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 18 , 16 , 8.5 , 9999 , 43 },
},
{
	" P7	orogen/50km, Urals, Tethian Orogen, 3.0 km seds. 181",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 20 , 20 , 10 , 9999 , 53 },
},
{
	" P8	orogen/46km, Orogen, 7.0 km seds. 182",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 5.5 , 15 , 15 , 7.0 , 9999 , 44 },
},
{
	" P9	orogen/50km, Rockies, 4.0 km seds. 183",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 19 , 20 , 7.0 , 9999 , 50 },
},
{
	" PA	thin orogen/38km, Urals, Tethian Orogen, 0.5 km seds. 184",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 13.5 , 14 , 10 , 9999 , 38 },
},
{
	" PB	orogen/43km, Orogen, 2.0 km seds. 185",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 17 , 16 , 8.0 , 9999 , 43 },
},
{
	" PC	orogen/45km, Orogen, 1.0 km seds. 186",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 18 , 17 , 9.0 , 9999 , 45 },
},
{
	" PD	orogen/50km, Tibet, 2.0 km seds. 187",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 20 , 20 , 8.0 , 9999 , 50 },
},
{
	" PE	orogen/50km, Tibet, 0.5 km seds. 188",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 20 , 20 , 9.5 , 9999 , 50 },
},
{
	" PG	orogen/55km, Tibet, 2.5 km seds. 189",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 20.5 , 21 , 11 , 9999 , 55 },
},
{
	" PH	orogen/46km, Orogen, 3.5 km seds. 190",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 2.0 , 17 , 16.5 , 9.0 , 9999 , 46 },
},
{
	" PJ	orogen/55km, Tibet, 4.5 km seds. 191",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 3.5 , 20.5 , 20 , 10 , 9999 , 55 },
},
{
	" PK	orogen/44km, Orogen, 6.0 km seds. 192",
	{ 3.81 , 1.5 , 2.5 , 4.3 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 16 , 15 , 7.0 , 9999 , 44 },
},
{
	" PL	orogen/48km, Orogen, 5.0 km seds. 193",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.3 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.6 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.8 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 3.5 , 17 , 17.0 , 9.0 , 9999 , 48 },
},
{
	" O1	Orogen/40 km 0.25 km ice 194",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.25 , 0.0 , 0.5 , 0.0 , 19 , 12 , 6.25 , 9999 , 38 },
},
{
	" O2	Orogen/40 km 0.5 km ice 195",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.5 , 0.0 , 0.5 , 0.0 , 19 , 12 , 6.0 , 9999 , 38 },
},
{
	" O3	Orogen/40 km 1.0 km ice 196",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 1.0 , 0.0 , 0.5 , 0.0 , 19 , 12 , 6.0 , 9999 , 38.5 },
},
{
	" O4	Orogen/40 km 1.5 ice 197",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 1.5 , 0.0 , 0.5 , 0.0 , 19 , 12 , 6.0 , 9999 , 39 },
},
{
	" O5	Orogen/40 km 2.0 km ice 198",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 2.0 , 0.0 , 0.5 , 0.0 , 19 , 12 , 5.5 , 9999 , 39 },
},
{
	" O6	Orogen/40 km 2.5 ice 199",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 2.5 , 0.0 , 0.5 , 0.0 , 19 , 12 , 5.5 , 9999 , 39.5 },
},
{
	" O7	Orogen/40 km 3.0 km ice 200",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 3.0 , 0.0 , 1.0 , 0.0 , 19 , 12 , 5.0 , 9999 , 40 },
},
{
	" O9	Orogen/40 km 2.0 km ice, 2.5 km seds 201",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 2.0 , 0.0 , 0.5 , 2.0 , 18 , 12 , 5.5 , 9999 , 40 },
},
{
	" OA	Orogen, km 0.5 km ice, 1.0 km seds 202",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.5 , 0.0 , 0.5 , 0.5 , 18.5 , 12 , 6.0 , 9999 , 38 },
},
{
	" OB	Orogen, km 1.0 km ice, 1.0 km seds 203",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 1.0 , 0.0 , 0.5 , 0.5 , 18 , 12 , 6.0 , 9999 , 38 },
},
{
	" OC	Orogen/40 km 3.0 km ice, 2.5 km seds 204",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 3.0 , 0.0 , 0.5 , 2.0 , 17.5 , 12 , 5.0 , 9999 , 40 },
},
{
	" OF	Orogen/40 km 2.5 km ice, 1.0 km seds 205",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 2.5 , 0.0 , 1.0 , 0.0 , 19 , 12.5 , 5.0 , 9999 , 40 },
},
{
	" OG	Orogen/40 km 3.0 ice, 0.5 km seds 206",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 3.0 , 0.0 , 0.5 , 0.0 , 19 , 12 , 5.5 , 9999 , 40 },
},
{
	" OH	Orogen/40 km 2.5 km ice, 2.5 km seds 207",
	{ 3.81 , 1.5 , 3.8 , 4.3 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 2.1 , 2.5 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 2.2 , 0.0 , 0.5 , 2.0 , 17.8 , 12 , 5.5 , 9999 , 40 },
},
{
	" Q0	orogen/46km no ice, Rockies, Tarim Basin, 4.0 km seds. 208",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.1 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 22 , 16 , 4.0 , 9999 , 46 },
},
{
	" Q1	orogen/39km no ice, Appalachians, North Andes 209",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 19 , 12 , 4.0 , 9999 , 39 },
},
{
	" Q2	orogen/39km no ice, Appalachians, North Andes, 0.5 km seds. 210",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 19 , 12 , 7.5 , 9999 , 39 },
},
{
	" Q3	orogen/43km no ice, Appalachians, 3.0 km seds. 211",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 18 , 14 , 8.0 , 9999 , 43 },
},
{
	" Q4	orogen/43km no ice, Tethian Belt, 5.0 km seds. 212",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 16 , 14 , 8.0 , 9999 , 43 },
},
{
	" Q5	orogen/36km no ice, Andes, 3.0 km seds. 213",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 13 , 13 , 7.0 , 9999 , 36 },
},
{
	" Q6	orogen/41.5km no ice, cordilleras, 1.5 km seds. 214",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.5 , 14 , 14 , 12 , 9999 , 41.5 },
},
{
	" Q7	orogen/32km no ice, Tethian Belt, 3.0 km seds. 215",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 12 , 11 , 6.0 , 9999 , 32 },
},
{
	" Q8	orogen/36km no ice, Tethian Belt, 5.0 km seds. 216",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 13 , 11 , 7.0 , 9999 , 36 },
},
{
	" Q9	orogen/41km no ice, cordilleras, 0.25 km seds. 217",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.25 , 0.0 , 14.75 , 14 , 12 , 9999 , 41 },
},
{
	" QA	orogen/39km no ice, Cordilleras, 2.5 km seds. 218",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 7.9 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.8 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 2.0 , 17.5 , 12 , 7.0 , 9999 , 39 },
},
{
	" R0	orogen/60km Tibet Transition, 1.0 km seds. 219",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 0.5 , 0.5 , 18 , 20 , 21 , 9999 , 60 },
},
{
	" R1	orogen/70km Tibet, 1.0 km seds. 220",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.5 , 0.5 , 21 , 24 , 24 , 9999 , 70 },
},
{
	" R2	orogen/65km Bolivia, 0.5 km seds. 221",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 20.5 , 22 , 22 , 9999 , 65 },
},
{
	" R3	orogen/70km Chile, 1.0 km seds. 222",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.5 , 0.5 , 21 , 24 , 24 , 9999 , 70 },
},
{
	" R4	orogen/55km Tibet Transition, 0.0 km seds. 223",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 19 , 18 , 18 , 9999 , 55 },
},
{
	" R5	orogen/75km Tibet, 0.0 km seds. 224",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 25 , 25 , 25 , 9999 , 75 },
},
{
	" R6	orogen/60km Tibet Transition, 3.0 km seds. 225",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 18 , 19 , 20 , 9999 , 60 },
},
{
	" R7	orogen/70km Chile, 3.0 km seds. 226",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 21 , 23 , 23 , 9999 , 70 },
},
{
	" R8	orogen/55km Andean Transition, 5.0 km seds. 227",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 16 , 17 , 17 , 9999 , 55 },
},
{
	" R9	orogen/55km Tibet Transition, 1.0 km seds. 228",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.5 , 0.5 , 18 , 18 , 18 , 9999 , 55 },
},
{
	" RA	orogen/65km Tibet, 1.0 km seds. 229",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 20.0 , 22 , 22 , 9999 , 65 },
},
{
	" RB	orogen/60km Tibet Transition, 0.0 km seds. 230",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 20 , 20 , 20 , 9999 , 60 },
},
{
	" RC	orogen/65km Tibet, 4.5 km seds. 231",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 1.0 , 3.5 , 20.0 , 20 , 20.5 , 9999 , 65 },
},
{
	" RD	orogen/70km Tibet, no seds. 232",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 22 , 24 , 24 , 9999 , 70 },
},
{
	" RE	orogen/60km Tibet, 2.5 km seds. 233",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.4 , 7.1 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.85 , 3.1 , 3.45 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 18.5 , 19 , 20 , 9999 , 60 },
},
{
	" T4	Margin /shield  transition, East Siberia, 2.0 km seds. 234",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 10 , 10 , 10 , 9999 , 32 },
},
{
	" T5	Margin /shield  transition, 5.0 km seds.   235",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 9.0 , 9.0 , 9.0 , 9999 , 32 },
},
{
	" T6	Margin /shield  transition, 1.0 km seds.   236",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 10 , 11 , 10 , 9999 , 32 },
},
{
	" T7	Margin /shield  transition, 3.5 km seds.   237",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 9.0 , 9.5 , 10 , 9999 , 32 },
},
{
	" T8	Margin /shield  transition, 8.0 km seds.   238",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.7 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 8.0 , 8.0 , 8.0 , 9999 , 32 },
},
{
	" T9	thin Margin /shield  transition, 1.0 km seds.   239",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 8.0 , 9.0 , 9.0 , 9999 , 27 },
},
{
	" TA	thin Margin /shield  transition, 2.0 km seds.   240",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 8.0 , 8.0 , 9.0 , 9999 , 27 },
},
{
	" TB	Margin /shield  transition, 6.0 km seds.   241",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 8.0 , 8.0 , 8.0 , 9999 , 30 },
},
{
	" TC	thick Margin /shield  transition, East Siberia, 2.0 km seds. 242",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 11 , 11 , 11 , 9999 , 35 },
},
{
	" TD	thick Margin /shield  transition, East Siberia, 3.5 km seds. 243",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 10 , 10.5 , 11 , 9999 , 35 },
},
{
	" TE	thick Margin /shield  transition, East Siberia, 5.5 km seds. 244",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.0 , 4.5 , 9.0 , 10 , 10.5 , 9999 , 35 },
},
{
	" TF	thick Margin /shield  transition, East Siberia, 7.5 km seds. 245",
	{ 3.81 , 1.5 , 2.5 , 4.4 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 6.0 , 9.0 , 9.0 , 9.5 , 9999 , 35 },
},
{
	" TG	thick Margin /shield  transition, East Siberia, 10 km seds. 246",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 1.5 , 8.5 , 8.0 , 8.0 , 9.0 , 9999 , 35 },
},
{
	" TH	Margin /shield  transition, 0.5 km seds.   247",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 10 , 11 , 10.5 , 9999 , 32 },
},
{
	" TJ	thin Margin /shield  transition, 0.0 km seds.   248",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 8.0 , 8.0 , 8.0 , 9999 , 24 },
},
{
	" U2	Margin/Shield 0.5 km ice, 2.0 km seds. 249",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.5 , 0.0 , 1.0 , 1.0 , 9.0 , 8.0 , 8.0 , 9999 , 27.5 },
},
{
	" U3	Margin/Shield 1.5 km ice, 1.0 km seds. 250",
	{ 3.81 , 1.5 , 3.8 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 1.5 , 0.0 , 0.5 , 0.5 , 10 , 10 , 10.5 , 9999 , 33 },
},
{
	" U5	Margin/Shield 0.5 km ice, 1.0 km seds. 251",
	{ 3.81 , 1.5 , 3.8 , 4.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.4 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.5 , 0.0 , 0.5 , 0.5 , 9.0 , 8.5 , 8.0 , 9999 , 27. },
},
{
	" U6	Margin/Shield 0.5 km ice, 3.5 km seds. 252",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.5 , 0.0 , 0.5 , 3.0 , 7.5 , 7.5 , 8.0 , 9999 , 27. },
},
{
	" U7	Margin/Shield 1.0 km ice, 1.0 km seds. 253",
	{ 3.81 , 1.5 , 3.8 , 4.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.4 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 1.0 , 0.0 , 0.5 , 0.5 , 8.5 , 8.5 , 8.0 , 9999 , 27. },
},
{
	" U8	Margin/Shield 0.5 km ice, 2.5 km seds. 254",
	{ 3.81 , 1.5 , 3.8 , 4.0 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.5 , 0.0 , 0.5 , 2.0 , 8.0 , 8.0 , 8.0 , 9999 , 27. },
},
{
	" U9	Margin/Shield 0.5 km ice, 0.5 km seds. 255",
	{ 3.81 , 1.5 , 3.8 , 4.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.4 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.5 , 0.0 , 0.5 , 0.0	, 8.5 , 8.5 , 9.0 , 9999 , 27. },
},
{
	" UA	Margin/Shield 1. km ice, 0.5 km seds. 256",
	{ 3.81 , 1.5 , 3.8 , 4.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.4 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 1.0 , 0.0 , 0.5 , 0.0	, 8.5 , 8.0 , 9.0 , 9999 , 27. },
},
{
	" UB	Margin/Shield 0.5 km ice, 1.0 km seds. 257",
	{ 3.81 , 1.5 , 3.8 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.5 , 0.0 , 0.5 , 0.5 , 10 , 10 , 10.5 , 9999 , 32 },
},
{
	" UC	Margin/Shield 1.0 km ice, 1.0 km seds. 258",
	{ 3.81 , 1.5 , 3.8 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 2.1 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.3 , 2.5 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 1.0 , 0.0 , 0.5 , 0.5 , 10 , 10 , 10.0 , 9999 , 32 },
},
{
	" X1	Rift, Rio Grande, Baikal, 2km sediments 259",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 12 , 9.0 , 10 , 9999 , 33 },
},
{
	" X2	Rift, Rio Grande, Baikal, 0.5km sediments 260",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 12 , 10.5 , 10 , 9999 , 33 },
},
{
	" X3	thin Rift, Rio Grande, Baikal, 0.25km sediments 261",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.25 , 0.0 , 9.0 , 8.75 , 9.0 , 9999 , 27 },
},
{
	" X4	very thin Afar Rift 0.75 km sediments 262",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.75 , 0.0 , 6.25 , 5.0 , 5.0 , 9999 , 17 },
},
{
	" X5	thick Rift 0.25 km sediments 263",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.25 , 0.0 , 12 , 12 , 13.75 , 9999 , 38 },
},
{
	" X6	thick Rift 2.0 km sediments 264",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 12 , 12 , 12 , 9999 , 38 },
},
{
	" X7	Rift, Rio Grande, Baikal, 3km sediments 265",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.5 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 11 , 9.0 , 10 , 9999 , 33 },
},
{
	" Z1	Phanerozoic, 1.0 km seds. 266",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 12 , 12 , 12 , 9999 , 37 },
},
{
	" Z2	Phanerozoic, 0.5 km seds. 267",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0	, 12 , 12 , 12 , 9999 , 36.5 },
},
{
	" Z3	Phanerozoic, 2.0 km seds. 268",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 12 , 12 , 12 , 9999 , 38 },
},
{
	" Z4	Phanerozoic, 4.0 km seds. 269",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 3.0 , 11 , 11 , 11 , 9999 , 37 },
},
{
	" Z5	Phanerozoic, 5.5 km seds. 270",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.3 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.5 , 4.0 , 10.5 , 11 , 11 , 9999 , 38 },
},
{
	" Z6	thick Phanerozoic, 1.0 km seds. 271",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 13 , 14 , 14 , 9999 , 42 },
},
{
	" Z7	thin Phanerozoic, 1.0 km seds. 272",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 0.0 ,10 , 10 , 9.0 , 9999 , 30 },
},
{
	" Z8	thick Phanerozoic, 0.0 km seds. 273",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.0 , 0.0 , 15 , 15 , 15 , 9999 , 45 },
},
{
	" Z9	thin Phanerozoic, 2.0 km seds. 274",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 10 , 9.0 , 9.0 , 9999 , 30 },
},
{
	" ZA	thick Phanerozoic, 0.5 km seds. 275",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.3 },
	{ 0.0 , 0.0 , 0.5 , 0.0 , 13.5 , 14 , 14 , 9999 , 42 },
},
{
	" ZB	Phanerozoic, 2.0 km seds. 276",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.0 , 11 , 11 , 10 , 9999 , 34 },
},
{
	" ZC	Phanerozoic, 3.0 km seds. 277",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.1 , 6.6 , 7.2 , 8.0 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.5 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.75 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.0 , 11 , 12 , 11 , 9999 , 37 },
},
{
	" A0	normal oceanic, 0.07 km seds. 278",
	{ 3.81 , 1.5 , 1.8 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 0.8 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 1.7 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 0.07 , 0.0 , 1.7 , 2.3 , 2.5 , 9999 , 11.57 },
},
{
	" A1	normal oceanic 0.5 km seds. 279",
	{ 3.81 , 1.5 , 1.9 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 0.9 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 1.9 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 0.5 , 0.0 , 1.7 , 2.3 , 2.5 , 9999 , 12 },
},
{
	" A2	normal oceanic 1.0 km seds. 280",
	{ 3.81 , 1.5 , 2.1 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.0 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.1 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.0 , 0.0 , 1.7 , 2.3 , 2.5 , 9999 , 12.5 },
},
{
	" A3	normal oceanic 2.0 km seds.  					 281",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 0.5 , 1.7 , 2.3 , 2.5 , 9999 , 13.5 },
},
{
	" A4	normal oceanic 3.0 km seds.  					 282",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 1.5 , 1.7 , 2.3 , 2.5 , 9999 , 14.5 },
},
{
	" A5	normal oceanic 4.0 km seds.  					 283",
	{ 3.81 , 1.5 , 2.3 , 3.3 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.7 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 2.5 , 1.7 , 2.3 , 2.5 , 9999 , 15.5 },
},
{
	" A6	normal oceanic 5.0 km seds.  					 284",
	{ 3.81 , 1.5 , 2.3 , 3.5 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.8 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 3.5 , 1.7 , 2.3 , 2.5 , 9999 , 16.5 },
},
{
	" A7	normal oceanic 6.0 km seds.  					 285",
	{ 3.81 , 1.5 , 2.3 , 3.8 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.0 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.4 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 4.5 , 1.7 , 2.3 , 2.5 , 9999 , 17.5 },
},
{
	" A8	normal oceanic 7.0 km seds.  					 286",
	{ 3.81 , 1.5 , 2.3 , 4.1 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 5.5 , 1.7 , 2.3 , 2.5 , 9999 , 18.5 },
},
{
	" A9	normal oceanic 9.0 km seds.  					 287",
	{ 3.81 , 1.5 , 2.3 , 4.5 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 7.5 , 1.7 , 2.3 , 2.5 , 9999 , 20.5 },
},
{
	" AA	normal oceanic 10 km seds.  					 288",
	{ 3.81 , 1.5 , 2.3 , 4.7 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 8.5 , 1.7 , 2.3 , 2.5 , 9999 , 21.5 },
},
{
	" AB	normal oceanic 13 km seds.  					 289",
	{ 3.81 , 1.5 , 2.3 , 4.9 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.7 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 11.5 , 1.7 , 2.3 , 2.5 , 9999 , 24.5 },
},
{
	" AC	normal oceanic 8.0 km seds.  					 290",
	{ 3.81 , 1.5 , 2.3 , 4.3 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.3 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 6.5 , 1.7 , 2.3 , 2.5 , 9999 , 19.5 },
},
{
	" B0	melt affected o.c. and oceanic plateaus, 0.10 km seds. 291",
	{ 3.81 , 1.5 , 1.8 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 0.8 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 1.7 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 0.10 , 0.0 , 2.7 , 3.3 , 4.5 , 9999 , 15.60 },
},
{
	" B1	melt affected o.c. and oceanic plateaus, 0.5 km seds. 292",
	{ 3.81 , 1.5 , 1.9 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 0.9 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 1.9 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 0.5 , 0.0 , 2.7 , 3.3 , 4.5 , 9999 , 16 },
},
{
	" B2	melt affected o.c. and oceanic plateaus, 1.0 km seds. 293",
	{ 3.81 , 1.5 , 2.2 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.0 , 0.0 , 2.7 , 3.3 , 4.5 , 9999 , 16.5 },
},
{
	" B3	melt affected o.c. and oceanic plateaus, 2.0 km seds. 294",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 0.5 , 2.7 , 3.3 , 4.5 , 9999 , 17.5 },
},
{
	" B4	melt affected o.c. and oceanic plateaus, 3.5 km seds. 295",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 2.0 , 2.7 , 3.3 , 4.5 , 9999 , 19 },
},
{
	" B5	thick melt affected o.c., no seds. 296",
	{ 3.81 , 1.5 , 1.8 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 0.8 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 1.7 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 0.0 , 0.0 , 5.7 , 6.3 , 6.5 , 9999 , 23.5 },
},
{
	" B6	thick melt affected o.c., 0.5 km seds. 297",
	{ 3.81 , 1.5 , 1.9 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 0.9 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 1.9 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 0.5 , 0.0 , 5.7 , 6.3 , 6.5 , 9999 , 24 },
},
{
	" B7	thick melt affected o.c., 1.0 km seds. 298",
	{ 3.81 , 1.5 , 2.2 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.0 , 0.0 , 5.7 , 6.3 , 6.5 , 9999 , 24.5 },
},
{
	" B8	melt affected o.c. and oceanic plateaus, 4.5 km seds. 299",
	{ 3.81 , 1.5 , 2.3 , 3.4 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.8 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 2.0 , 1.5 , 3.0 , 3.7 , 4.3 , 5.5 , 9999 , 20 },
},
{
	" B9	melt affected o.c. and oceanic plateaus, 7.0 km seds. 300",
	{ 3.81 , 1.5 , 2.3 , 4.1 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 2.0 , 1.5 , 5.5 , 3.0 , 4.0 , 5.0 , 9999 , 21 },
},
{
	" BA	melt affected o.c. and oceanic plateaus, 9.0 km seds. 301",
	{ 3.81 , 1.5 , 2.3 , 4.3 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 2.0 , 1.5 , 7.5 , 3.0 , 4.0 , 5.0 , 9999 , 23 },
},
{
	" BB	melt affected o.c. and oceanic plateaus, 3.0 km seds. 302",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 2.0 , 1.0 , 2.0 , 5.0 , 6.0 , 6.0 , 9999 , 22. },
},
{
	" BC	melt affected o.c. and oceanic plateaus, 5.5 km seds. 303",
	{ 3.81 , 1.5 , 2.3 , 3.5 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.8 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 2.0 , 1.5 , 4.0 , 3.7 , 4.3 , 5.5 , 9999 , 21 },
},
{
	" BD	thick melt affected o.c. and oceanic plateaus, 2.0 km seds. 304",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 1.6 , 2.5 , 3.65 , 3.9 , 4.65 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.5 , 0.5 , 4.5 , 5.0 , 5.0 , 9999 , 21.5 },
},
{
	" C0	continental shelf, 0.25 km seds. 305",
	{ 3.81 , 1.5 , 1.8 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 0.8 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 1.7 , 2.3 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 0.25 , 0.0 , 10 , 10 , 8.0 , 9999 , 29.25 },
},
{
	" C1	continental shelf, 0.5 km seds. 306",
	{ 3.81 , 1.5 , 1.9 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 0.9 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 1.9 , 2.3 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 0.5 , 0.0 , 10 , 10 , 8.0 , 9999 , 29.5 },
},
{
	" C2	continental shelf, 1.0 km seds. 307",
	{ 3.81 , 1.5 , 2.1 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.0 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.3 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.0 , 0.0 , 10 , 10 , 8.0 , 9999 , 30 },
},
{
	" C3	continental shelf, 2.0 km seds. 308",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 0.5 , 10 , 10 , 8.0 , 9999 , 31 },
},
{
	" C4	continental shelf, 3.5 km seds. 309",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 2.0 , 10 , 9.5 , 8.0 , 9999 , 32 },
},
{
	" C5	continental shelf, 5.5 km seds. 310",
	{ 3.81 , 1.5 , 2.3 , 3.6 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 1.9 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 4.0 , 9.0 , 8.5 , 8.0 , 9999 , 32 },
},
{
	" C6	continental shelf, 7.5 km seds. 311",
	{ 3.81 , 1.5 , 2.3 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 6.0 , 7.5 , 8.0 , 8.0 , 9999 , 32 },
},
{
	" C7	continental shelf, 6.5 km seds. 312",
	{ 3.81 , 1.5 , 2.3 , 3.9 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.4 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 5.0 , 8.0 , 8.5 , 8.0 , 9999 , 32 },
},
{
	" C8	continental shelf, 10 km seds. 313",
	{ 3.81 , 1.5 , 2.3 , 4.7 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 8.5 , 7.0 , 8.0 , 6.5 , 9999 , 32.5 },
},
{
	" C9	continental shelf, 12 km seds. 314",
	{ 3.81 , 1.5 , 2.3 , 4.8 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 10.5 , 6.0 , 7.0 , 7.0 , 9999 , 33 },
},
{
	" CA	continental shelf, 9.0 km seds. 315",
	{ 3.81 , 1.5 , 2.3 , 4.5 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 7.5 , 7.5 , 8.0 , 7.0 , 9999 , 32.5 },
},
{
	" CB	continental shelf, 4.5 km seds. 316",
	{ 3.81 , 1.5 , 2.3 , 3.3 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 1.7 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 3.0 , 9.5 , 9.0 , 8.0 , 9999 , 32 },
},
{
	" CC	continental shelf, 11 km seds. 317",
	{ 3.81 , 1.5 , 2.3 , 4.4 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.2 , 2.5 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.7 , 2.9 , 3.1 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 9.5 , 5.0 , 5.5 , 5.5 , 9999 , 28 },
},
{
	" S0	continental slope, margin, transition 0.25 km seds. 318",
	{ 3.81 , 1.5 , 2.1 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.0 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.3 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 0.25 , 0.0 , 7.0 , 7.0 , 7.0 , 9999 , 22.25 },
},
{
	" S1	continental slope, margin, transition 1.0 km seds. 319",
	{ 3.81 , 1.5 , 2.1 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.0 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.1 , 2.3 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.0 , 0.0 , 7.0 , 7.0 , 7.0 , 9999 , 23 },
},
{
	" S2	continental slope, margin, transition 2.0 km seds. 320",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 0.5 , 7.0 , 7.0 , 7.0 , 9999 , 24 },
},
{
	" S3	continental slope, margin, transition 3.5 km seds. 321",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 2.0 , 7.0 , 7.0 , 7.0 , 9999 , 25.5 },
},
{
	" S4	continental slope, margin, transition 5.5 km seds. 322",
	{ 3.81 , 1.5 , 2.2 , 3.6 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.0 , 1.9 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.4 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 4.0 , 7.0 , 7.0 , 7.0 , 9999 , 27.5 },
},
{
	" S5	continental slope, margin, transition 8.0 km seds. 323",
	{ 3.81 , 1.5 , 2.2 , 4.3 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.0 , 2.3 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 6.5 , 7.0 , 6.0 , 6.0 , 9999 , 28 },
},
{
	" S6	continental slope, margin, transition 4.5 km seds. 324",
	{ 3.81 , 1.5 , 2.3 , 3.3 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 1.7 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 3.0 , 6.0 , 7.0 , 7.0 , 9999 , 25.5 },
},
{
	" S7	continental slope, margin, transition 7.0 km seds. 325",
	{ 3.81 , 1.5 , 2.2 , 4.1 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 2.2 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 5.5 , 6.0 , 7.0 , 6.0 , 9999 , 27 },
},
{
	" S8      continental slope, margin, transition 9.0 km seds. 326",
	{ 3.81 , 1.5 , 2.2 , 4.3 , 6.0 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 2.3 , 3.4 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 7.5 , 5.0 , 6.0 , 6.0 , 9999 , 27 },
},
{
	" S9      continental slope, margin, transition 10.5 km seds. 327",
	{ 3.81 , 1.5 , 2.2 , 4.5 , 6.1 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 2.6 , 3.5 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.7 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 9.0 , 4.5 , 5.0 , 6.0 , 9999 , 27 },
},
{
	" SA      continental slope, margin, transition 12.5 km seds. 328",
	{ 3.81 , 1.5 , 2.2 , 4.8 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 2.7 , 3.5 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 11.0 , 4.0 , 4.5 , 5.0 , 9999 , 27 },
},
{
	" SB      continental slope, margin, transition 15 km seds. 329",
	{ 3.81 , 1.5 , 2.2 , 5.0 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 2.9 , 3.5 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.6 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 13.5 , 3.5 , 3.5 , 4.0 , 9999 , 27 },
},
{
	" SC      continental slope, margin, transition 11.5 km seds. 330",
	{ 3.81 , 1.5 , 2.2 , 4.9 , 6.2 , 6.6 , 7.2 , 8.2 },
	{ 1.94 , 0.0 , 1.1 , 2.7 , 3.5 , 3.7 , 4.0 , 4.7 },
	{ 0.92 , 1.02 , 2.2 , 2.5 , 2.8 , 2.9 , 3.05 , 3.4 },
	{ 0.0 , 1.0 , 1.5 , 10.0 , 4.5 , 5.0 , 5.0 , 9999 , 27 },
},
{
	" J1	island arc, Japan, Antarctic, 1.0 km seds. 331",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.1 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 10 , 10 , 10 , 9999 , 31 },
},
{
	" J2	island arc, 3.5 km seds. 332",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.1 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 10 , 10 , 10 , 9999 , 33.5 },
},
{
	" J3	island arc, 2.5 km seds. 333",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.1 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 11 , 10 , 10 , 9999 , 33.5 },
},
{
	" J4	island arc, 5.0 km seds. 334",
	{ 3.81 , 1.5 , 2.5 , 4.1 , 6.0 , 6.6 , 7.2 , 8.1 },
	{ 1.94 , 0.0 , 1.2 , 2.2 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 4.0 , 9.5 , 9.5 , 9.5 , 9999 , 33.5 },
},
{
	" J5	island arc, Caribbean, 1.0 km seds. 335",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.1 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 7.0 , 7.0 , 8.0 , 9999 , 23 },
},
{
	" J7	island arc, Caribbean, 3.5 km seds. 336",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.1 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.1 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 7.0 , 7.0 , 7.0 , 9999 , 24.5 },
},
{
	" W1	oceanic plateau with cont. crust, 0.25 km seds. 337",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 1.0 , 0.25 , 0.0 , 6.0 , 6.0 , 6.5 , 9999 , 19.75 },
},
{
	" W2	oceanic plateau with cont. crust, 1.0 km seds. 338",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 1.0 , 1.0 , 0.0 , 6.0 , 6.0 , 6.5 , 9999 , 20.5 },
},
{
	" W3	oceanic plateau with cont. crust, 2.0 km seds. 339",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 1.0 , 1.5 , 0.5 , 6.0 , 6.0 , 6.5 , 9999 , 21.5 },
},
{
	" W4	oceanic plateau with cont. crust, 4.0 km seds. 340",
	{ 3.81 , 1.5 , 2.3 , 3.3 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.7 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 1.0 , 1.5 , 2.5 , 6.0 , 6.0 , 6.5 , 9999 , 23.5 },
},
{
	" W5	oceanic plateau with cont. crust, 5.0 km seds. 341",
	{ 3.81 , 1.5 , 2.3 , 3.5 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.8 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 1.0 , 1.5 , 3.5 , 5.0 , 6.0 , 6.5 , 9999 , 23.5 },
},
{
	" W6	oceanic plateau with cont. crust, 3.0 km seds. 342",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 1.0 , 1.5 , 1.5 , 6.0 , 6.0 , 6.5 , 9999 , 22.5 },
},
{
	" WY	inactive ridge 1.0 km seds., Alpha Ridge 343",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 2.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.0 , 0.0 , 5.0 , 9.0 , 10 , 9999 , 30 },
},
{
	" WZ	inactive ridge 2.5 km seds., Alpha Ridge 344",
	{ 3.81 , 1.5 , 2.3 , 3.2 , 5.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.1 , 1.6 , 2.5 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.2 , 2.3 , 2.6 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 5.0 , 1.0 , 1.5 , 5.5 , 8.0 , 9.0 , 9999 , 30 },
},
{
	" Y0	thinned cont. crust, Red Sea, 1.0 km seds 345",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 0.0 , 5.0 , 5.0 , 5.0 , 9999 , 16 },
},
{
	" Y1	extremely thinned cont. crust, Red Sea, 2.5 km seds 346",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 4.0 , 4.0 , 4.0 , 9999 , 14.5 },
},
{
	" Y2	thinned cont. crust, Red Sea 347",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 1.5 , 5.0 , 6.0 , 6.0 , 9999 , 19.5 },
},
{
	" Y3	thinned cont. crust, Red Sea 348",
	{ 3.81 , 1.5 , 2.5 , 4.0 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.1 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.0 , 2.5 , 5.0 , 5.0 , 6.0 , 9999 , 19.5 },
},
{
	" YA	intermed. cont./oc. crust, Black Sea, 6km sediments 349",
	{ 3.81 , 1.5 , 2.5 , 4.2 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.4 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.4 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 4.5 , 9.0 , 10 , 10 , 9999 , 35 },
},
{
	" YB	intermed. cont./oc. crust, Black Sea, 10.5km sediments 350",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.9 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 9.0 , 5.5 , 5.5 , 5.5 , 9999 , 27 },
},
{
	" YC	intermed. cont./oc. crust, Black Sea, 13km sediments 351",
	{ 3.81 , 1.5 , 2.5 , 5.1 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.9 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 11.5 , 5.0 , 5.0 , 5.0 , 9999 , 28 },
},
{
	" YE	intermed. cont./oc. crust, Black Sea, 8km sediments 352",
	{ 3.81 , 1.5 , 2.5 , 4.5 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.6 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 6.5 , 6.0 , 6.0 , 7.0 , 9999 , 27 },
},
{
	" YF	intermed. cont./oc. crust, Black Sea, 11.5km sediments 353",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 6.0 , 6.6 , 7.2 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.9 , 3.4 , 3.7 , 4.0 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 10 , 5.0 , 5.0 , 5.5 , 9999 , 27 },
},
{
	" YK      Caspian depression, 9.5 km seds. 354",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 5.9 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.3 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 8.0 , 4.0 , 13 , 13.5 , 9999 , 40 },
},
{
	" YL      Caspian depression, 13 km seds. 355",
	{ 3.81 , 1.5 , 2.5 , 5.0 , 5.9 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.9 , 3.3 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 11.5 , 3.0 , 10 , 10 , 9999 , 36 },
},
{
	" YM      Caspian depression, 10.5 km seds. 356",
	{ 3.81 , 1.5 , 2.5 , 4.9 , 5.9 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 2.8 , 3.3 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.5 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 9.0 , 4.0 , 11 , 11.5 , 9999 , 37 },
},
{
	" YN      Caspian depression, 15.5 km seds. 357",
	{ 3.81 , 1.5 , 2.5 , 5.3 , 5.9 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 3.0 , 3.3 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 14.0 , 3.0 , 8.0 , 8.5 , 9999 , 35 },
},
{
	" YP      Caspian depression, 17.5 km seds. 358",
	{ 3.81 , 1.5 , 2.5 , 5.5 , 5.9 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 3.1 , 3.3 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 16.0 , 3.0 , 7.5 , 7.0 , 9999 , 35 },
},
{
	" YQ      Caspian depression, 19.5 km seds. 359",
	{ 3.81 , 1.5 , 2.5 , 5.3 , 6.0 , 6.6 , 7.1 , 8.15 },
	{ 1.94 , 0.0 , 1.2 , 3.0 , 3.4 , 3.7 , 3.9 , 4.6 },
	{ 0.92 , 1.02 , 2.1 , 2.6 , 2.7 , 2.9 , 3.05 , 3.35 },
	{ 0.0 , 0.0 , 1.5 , 18.0 , 3.0 , 6.5 , 6.0 , 9999 , 35 },
}
};
