/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlTemplate;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdGraphDefTemplate
extends XmlTemplate
implements RrdGraphConstants {
    static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    private RrdGraphDef rrdGraphDef;

    public RrdGraphDefTemplate(InputSource inputSource) throws IOException {
        super(inputSource);
    }

    public RrdGraphDefTemplate(File xmlFile) throws IOException {
        super(xmlFile);
    }

    public RrdGraphDefTemplate(String xmlString) throws IOException {
        super(xmlString);
    }

    public RrdGraphDef getRrdGraphDef() {
        Node[] childNodes;
        if (!this.root.getTagName().equals("rrd_graph_def")) {
            throw new IllegalArgumentException("XML definition must start with <rrd_graph_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"filename", "span", "options", "datasources", "graph"});
        this.rrdGraphDef = new RrdGraphDef();
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(this.root);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("filename")) {
                this.resolveFilename(childNode);
            } else if (nodeName.equals("span")) {
                this.resolveSpan(childNode);
            } else if (nodeName.equals("options")) {
                this.resolveOptions(childNode);
            } else if (nodeName.equals("datasources")) {
                this.resolveDatasources(childNode);
            } else if (nodeName.equals("graph")) {
                this.resolveGraphElements(childNode);
            }
            ++n2;
        }
        return this.rrdGraphDef;
    }

    private void resolveGraphElements(Node graphNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(graphNode, new String[]{"area*", "line*", "stack*", "print*", "gprint*", "hrule*", "vrule*", "comment*"});
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(graphNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("area")) {
                this.resolveArea(childNode);
            } else if (nodeName.equals("line")) {
                this.resolveLine(childNode);
            } else if (nodeName.equals("stack")) {
                this.resolveStack(childNode);
            } else if (nodeName.equals("print")) {
                this.resolvePrint(childNode, false);
            } else if (nodeName.equals("gprint")) {
                this.resolvePrint(childNode, true);
            } else if (nodeName.equals("hrule")) {
                this.resolveHRule(childNode);
            } else if (nodeName.equals("vrule")) {
                this.resolveVRule(childNode);
            } else if (nodeName.equals("comment")) {
                this.rrdGraphDef.comment(this.getValue(childNode));
            }
            ++n2;
        }
    }

    private void resolveVRule(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"time", "color", "legend"});
        long timestamp = Long.MIN_VALUE;
        Paint color = null;
        String legend = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("time")) {
                timestamp = Util.getTimestamp(this.getValue(childNode));
            } else if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
            } else if (nodeName.equals("legend")) {
                legend = this.getValue(childNode);
            }
            ++n2;
        }
        if (timestamp == Long.MIN_VALUE || color == null) {
            throw new IllegalArgumentException("Incomplete VRULE settings");
        }
        this.rrdGraphDef.vrule(timestamp, color, legend);
    }

    private void resolveHRule(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"value", "color", "legend"});
        double value = Double.NaN;
        Paint color = null;
        String legend = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("value")) {
                value = this.getValueAsDouble(childNode);
            } else if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
            } else if (nodeName.equals("legend")) {
                legend = this.getValue(childNode);
            }
            ++n2;
        }
        if (Double.isNaN(value) || color == null) {
            throw new IllegalArgumentException("Incomplete HRULE settings");
        }
        this.rrdGraphDef.hrule(value, color, legend);
    }

    private void resolvePrint(Node parentNode, boolean isInGraph) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "cf", "format"});
        String datasource = null;
        String format = null;
        ConsolFun consolFun = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
            } else if (nodeName.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(childNode));
            } else if (nodeName.equals("format")) {
                format = this.getValue(childNode);
            }
            ++n2;
        }
        if (datasource != null && consolFun != null && format != null) {
            if (isInGraph) {
                this.rrdGraphDef.gprint(datasource, consolFun, format);
            } else {
                this.rrdGraphDef.print(datasource, consolFun, format);
            }
        } else {
            throw new IllegalArgumentException("Incomplete " + (isInGraph ? "GRPINT" : "PRINT") + " settings");
        }
    }

    private void resolveStack(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "color", "legend"});
        String datasource = null;
        String legend = null;
        Paint color = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
            } else if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
            } else if (nodeName.equals("legend")) {
                legend = this.getValue(childNode);
            }
            ++n2;
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.stack(datasource, color, legend);
            } else {
                this.rrdGraphDef.stack(datasource, BLIND_COLOR, legend);
            }
        } else {
            throw new IllegalArgumentException("Incomplete STACK settings");
        }
    }

    private void resolveLine(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "color", "legend", "width"});
        String datasource = null;
        String legend = null;
        Paint color = null;
        float width = 1.0f;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
            } else if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
            } else if (nodeName.equals("legend")) {
                legend = this.getValue(childNode);
            } else if (nodeName.equals("width")) {
                width = (float)this.getValueAsDouble(childNode);
            }
            ++n2;
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.line(datasource, color, legend, width);
            } else {
                this.rrdGraphDef.line(datasource, BLIND_COLOR, legend, width);
            }
        } else {
            throw new IllegalArgumentException("Incomplete LINE settings");
        }
    }

    private void resolveArea(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"datasource", "color", "legend"});
        String datasource = null;
        String legend = null;
        Paint color = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("datasource")) {
                datasource = this.getValue(childNode);
            } else if (nodeName.equals("color")) {
                color = this.getValueAsColor(childNode);
            } else if (nodeName.equals("legend")) {
                legend = this.getValue(childNode);
            }
            ++n2;
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.area(datasource, color, legend);
            } else {
                this.rrdGraphDef.area(datasource, BLIND_COLOR, legend);
            }
        } else {
            throw new IllegalArgumentException("Incomplete AREA settings");
        }
    }

    private void resolveDatasources(Node datasourcesNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(datasourcesNode, new String[]{"def*", "cdef*", "sdef*"});
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(datasourcesNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("def")) {
                this.resolveDef(childNode);
            } else if (nodeName.equals("cdef")) {
                this.resolveCDef(childNode);
            } else if (nodeName.equals("sdef")) {
                this.resolveSDef(childNode);
            }
            ++n2;
        }
    }

    private void resolveSDef(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "source", "cf"});
        String name = null;
        String source = null;
        ConsolFun consolFun = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
            } else if (nodeName.equals("source")) {
                source = this.getValue(childNode);
            } else if (nodeName.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(childNode));
            }
            ++n2;
        }
        if (name == null || source == null || consolFun == null) {
            throw new IllegalArgumentException("Incomplete SDEF settings");
        }
        this.rrdGraphDef.datasource(name, source, consolFun);
    }

    private void resolveCDef(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "rpn"});
        String name = null;
        String rpn = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
            } else if (nodeName.equals("rpn")) {
                rpn = this.getValue(childNode);
            }
            ++n2;
        }
        if (name == null || rpn == null) {
            throw new IllegalArgumentException("Incomplete CDEF settings");
        }
        this.rrdGraphDef.datasource(name, rpn);
    }

    private void resolveDef(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "rrd", "source", "cf", "backend"});
        String name = null;
        String rrd = null;
        String source = null;
        String backend = null;
        ConsolFun consolFun = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
            } else if (nodeName.equals("rrd")) {
                rrd = this.getValue(childNode);
            } else if (nodeName.equals("source")) {
                source = this.getValue(childNode);
            } else if (nodeName.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(childNode));
            } else if (nodeName.equals("backend")) {
                backend = this.getValue(childNode);
            }
            ++n2;
        }
        if (name == null || rrd == null || source == null || consolFun == null) {
            throw new IllegalArgumentException("Incomplete DEF settings");
        }
        this.rrdGraphDef.datasource(name, rrd, source, consolFun, backend);
    }

    private void resolveFilename(Node filenameNode) {
        String filename = this.getValue(filenameNode);
        this.rrdGraphDef.setFilename(filename);
    }

    private void resolveSpan(Node spanNode) {
        this.validateTagsOnlyOnce(spanNode, new String[]{"start", "end"});
        String startStr = this.getChildValue(spanNode, "start");
        String endStr = this.getChildValue(spanNode, "end");
        long[] span = Util.getTimestamps(startStr, endStr);
        this.rrdGraphDef.setStartTime(span[0]);
        this.rrdGraphDef.setEndTime(span[1]);
    }

    private void resolveOptions(Node rootOptionNode) {
        Node[] optionNodes;
        this.validateTagsOnlyOnce(rootOptionNode, new String[]{"anti_aliasing", "use_pool", "time_grid", "value_grid", "alt_y_grid", "alt_y_mrtg", "no_minor_grid", "alt_autoscale", "alt_autoscale_max", "units_exponent", "units_length", "vertical_label", "width", "height", "interlaced", "image_info", "image_format", "image_quality", "background_image", "overlay_image", "unit", "lazy", "min_value", "max_value", "rigid", "base", "logarithmic", "colors", "no_legend", "only_graph", "force_rules_legend", "title", "step", "fonts", "first_day_of_week", "signature"});
        Node[] nodeArray = optionNodes = RrdGraphDefTemplate.getChildNodes(rootOptionNode);
        int n = optionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node optionNode = nodeArray[n2];
            String option = optionNode.getNodeName();
            if (option.equals("use_pool")) {
                this.rrdGraphDef.setPoolUsed(this.getValueAsBoolean(optionNode));
            } else if (option.equals("anti_aliasing")) {
                this.rrdGraphDef.setAntiAliasing(this.getValueAsBoolean(optionNode));
            } else if (option.equals("time_grid")) {
                this.resolveTimeGrid(optionNode);
            } else if (option.equals("value_grid")) {
                this.resolveValueGrid(optionNode);
            } else if (option.equals("no_minor_grid")) {
                this.rrdGraphDef.setNoMinorGrid(this.getValueAsBoolean(optionNode));
            } else if (option.equals("alt_y_grid")) {
                this.rrdGraphDef.setAltYGrid(this.getValueAsBoolean(optionNode));
            } else if (option.equals("alt_y_mrtg")) {
                this.rrdGraphDef.setAltYMrtg(this.getValueAsBoolean(optionNode));
            } else if (option.equals("alt_autoscale")) {
                this.rrdGraphDef.setAltAutoscale(this.getValueAsBoolean(optionNode));
            } else if (option.equals("alt_autoscale_max")) {
                this.rrdGraphDef.setAltAutoscaleMax(this.getValueAsBoolean(optionNode));
            } else if (option.equals("units_exponent")) {
                this.rrdGraphDef.setUnitsExponent(this.getValueAsInt(optionNode));
            } else if (option.equals("units_length")) {
                this.rrdGraphDef.setUnitsLength(this.getValueAsInt(optionNode));
            } else if (option.equals("vertical_label")) {
                this.rrdGraphDef.setVerticalLabel(this.getValue(optionNode));
            } else if (option.equals("width")) {
                this.rrdGraphDef.setWidth(this.getValueAsInt(optionNode));
            } else if (option.equals("height")) {
                this.rrdGraphDef.setHeight(this.getValueAsInt(optionNode));
            } else if (option.equals("interlaced")) {
                this.rrdGraphDef.setInterlaced(this.getValueAsBoolean(optionNode));
            } else if (option.equals("image_info")) {
                this.rrdGraphDef.setImageInfo(this.getValue(optionNode));
            } else if (option.equals("image_format")) {
                this.rrdGraphDef.setImageFormat(this.getValue(optionNode));
            } else if (option.equals("image_quality")) {
                this.rrdGraphDef.setImageQuality((float)this.getValueAsDouble(optionNode));
            } else if (option.equals("background_image")) {
                this.rrdGraphDef.setBackgroundImage(this.getValue(optionNode));
            } else if (option.equals("overlay_image")) {
                this.rrdGraphDef.setOverlayImage(this.getValue(optionNode));
            } else if (option.equals("unit")) {
                this.rrdGraphDef.setUnit(this.getValue(optionNode));
            } else if (option.equals("lazy")) {
                this.rrdGraphDef.setLazy(this.getValueAsBoolean(optionNode));
            } else if (option.equals("min_value")) {
                this.rrdGraphDef.setMinValue(this.getValueAsDouble(optionNode));
            } else if (option.equals("max_value")) {
                this.rrdGraphDef.setMaxValue(this.getValueAsDouble(optionNode));
            } else if (option.equals("rigid")) {
                this.rrdGraphDef.setRigid(this.getValueAsBoolean(optionNode));
            } else if (option.equals("base")) {
                this.rrdGraphDef.setBase(this.getValueAsDouble(optionNode));
            } else if (option.equals("logarithmic")) {
                this.rrdGraphDef.setLogarithmic(this.getValueAsBoolean(optionNode));
            } else if (option.equals("colors")) {
                this.resolveColors(optionNode);
            } else if (option.equals("no_legend")) {
                this.rrdGraphDef.setNoLegend(this.getValueAsBoolean(optionNode));
            } else if (option.equals("only_graph")) {
                this.rrdGraphDef.setOnlyGraph(this.getValueAsBoolean(optionNode));
            } else if (option.equals("force_rules_legend")) {
                this.rrdGraphDef.setForceRulesLegend(this.getValueAsBoolean(optionNode));
            } else if (option.equals("title")) {
                this.rrdGraphDef.setTitle(this.getValue(optionNode));
            } else if (option.equals("step")) {
                this.rrdGraphDef.setStep(this.getValueAsLong(optionNode));
            } else if (option.equals("fonts")) {
                this.resolveFonts(optionNode);
            } else if (option.equals("first_day_of_week")) {
                int dayIndex = RrdGraphDefTemplate.resolveFirstDayOfWeek(this.getValue(optionNode));
                this.rrdGraphDef.setFirstDayOfWeek(dayIndex);
            } else if (option.equals("signature")) {
                this.rrdGraphDef.setShowSignature(this.getValueAsBoolean(optionNode));
            }
            ++n2;
        }
    }

    private static int resolveFirstDayOfWeek(String firstDayOfWeek) {
        if (firstDayOfWeek.equalsIgnoreCase("sunday")) {
            return 1;
        }
        if (firstDayOfWeek.equalsIgnoreCase("monday")) {
            return 2;
        }
        if (firstDayOfWeek.equalsIgnoreCase("tuesday")) {
            return 3;
        }
        if (firstDayOfWeek.equalsIgnoreCase("wednesday")) {
            return 4;
        }
        if (firstDayOfWeek.equalsIgnoreCase("thursday")) {
            return 5;
        }
        if (firstDayOfWeek.equalsIgnoreCase("friday")) {
            return 6;
        }
        if (firstDayOfWeek.equalsIgnoreCase("saturday")) {
            return 7;
        }
        throw new IllegalArgumentException("Never heard for this day of week: " + firstDayOfWeek);
    }

    private void resolveFonts(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"small_font", "large_font"});
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("small_font")) {
                this.rrdGraphDef.setSmallFont(this.resolveFont(childNode));
            } else if (nodeName.equals("large_font")) {
                this.rrdGraphDef.setLargeFont(this.resolveFont(childNode));
            }
            ++n2;
        }
    }

    private Font resolveFont(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "style", "size"});
        String name = null;
        String style = null;
        int size = 0;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
            } else if (nodeName.equals("style")) {
                style = this.getValue(childNode).toLowerCase();
            } else if (nodeName.equals("size")) {
                size = this.getValueAsInt(childNode);
            }
            ++n2;
        }
        if (name != null && style != null && size > 0) {
            boolean isItalic = style.contains("italic");
            boolean isBold = style.contains("bold");
            int fstyle = 0;
            if (isItalic && isBold) {
                fstyle = 3;
            } else if (isItalic) {
                fstyle = 2;
            } else if (isBold) {
                fstyle = 1;
            }
            return new Font(name, fstyle, size);
        }
        throw new IllegalArgumentException("Incomplete font specification");
    }

    private void resolveColors(Node parentNode) {
        Node[] childNodes;
        String[] copy = new String[COLOR_NAMES.length];
        System.arraycopy(COLOR_NAMES, 0, copy, 0, COLOR_NAMES.length);
        this.validateTagsOnlyOnce(parentNode, copy);
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String colorName = childNode.getNodeName();
            this.rrdGraphDef.setColor(colorName, this.getValueAsColor(childNode));
            ++n2;
        }
    }

    private void resolveValueGrid(Node parentNode) {
        Node[] childNodes;
        int NOT_SET;
        this.validateTagsOnlyOnce(parentNode, new String[]{"show_grid", "grid_step", "label_factor"});
        boolean showGrid = true;
        double gridStep = Double.NaN;
        int labelFactor = NOT_SET = Integer.MIN_VALUE;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("show_grid")) {
                showGrid = this.getValueAsBoolean(childNode);
            } else if (nodeName.equals("grid_step")) {
                gridStep = this.getValueAsDouble(childNode);
            } else if (nodeName.equals("label_factor")) {
                labelFactor = this.getValueAsInt(childNode);
            }
            ++n2;
        }
        this.rrdGraphDef.setDrawYGrid(showGrid);
        if (!Double.isNaN(gridStep) && labelFactor != NOT_SET) {
            this.rrdGraphDef.setValueAxis(gridStep, labelFactor);
        } else if (!Double.isNaN(gridStep) || labelFactor != NOT_SET) {
            throw new IllegalArgumentException("Incomplete value axis settings");
        }
    }

    private void resolveTimeGrid(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"show_grid", "minor_grid_unit", "minor_grid_unit_count", "major_grid_unit", "major_grid_unit_count", "label_unit", "label_unit_count", "label_span", "label_format"});
        boolean showGrid = true;
        int NOT_SET = Integer.MIN_VALUE;
        int minorGridUnit = Integer.MIN_VALUE;
        int minorGridUnitCount = Integer.MIN_VALUE;
        int majorGridUnit = Integer.MIN_VALUE;
        int majorGridUnitCount = Integer.MIN_VALUE;
        int labelUnit = Integer.MIN_VALUE;
        int labelUnitCount = Integer.MIN_VALUE;
        int labelSpan = Integer.MIN_VALUE;
        String labelFormat = null;
        Node[] nodeArray = childNodes = RrdGraphDefTemplate.getChildNodes(parentNode);
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node childNode = nodeArray[n2];
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("show_grid")) {
                showGrid = this.getValueAsBoolean(childNode);
            } else if (nodeName.equals("minor_grid_unit")) {
                minorGridUnit = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(childNode));
            } else if (nodeName.equals("minor_grid_unit_count")) {
                minorGridUnitCount = this.getValueAsInt(childNode);
            } else if (nodeName.equals("major_grid_unit")) {
                majorGridUnit = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(childNode));
            } else if (nodeName.equals("major_grid_unit_count")) {
                majorGridUnitCount = this.getValueAsInt(childNode);
            } else if (nodeName.equals("label_unit")) {
                labelUnit = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(childNode));
            } else if (nodeName.equals("label_unit_count")) {
                labelUnitCount = this.getValueAsInt(childNode);
            } else if (nodeName.equals("label_span")) {
                labelSpan = this.getValueAsInt(childNode);
            } else if (nodeName.equals("label_format")) {
                labelFormat = this.getValue(childNode);
            }
            ++n2;
        }
        this.rrdGraphDef.setDrawXGrid(showGrid);
        if (minorGridUnit != Integer.MIN_VALUE && minorGridUnitCount != Integer.MIN_VALUE && majorGridUnit != Integer.MIN_VALUE && majorGridUnitCount != Integer.MIN_VALUE && labelUnit != Integer.MIN_VALUE && labelUnitCount != Integer.MIN_VALUE && labelSpan != Integer.MIN_VALUE && labelFormat != null) {
            this.rrdGraphDef.setTimeAxis(minorGridUnit, minorGridUnitCount, majorGridUnit, majorGridUnitCount, labelUnit, labelUnitCount, labelSpan, labelFormat);
        } else if (minorGridUnit != Integer.MIN_VALUE || minorGridUnitCount != Integer.MIN_VALUE || majorGridUnit != Integer.MIN_VALUE || majorGridUnitCount != Integer.MIN_VALUE || labelUnit != Integer.MIN_VALUE || labelUnitCount != Integer.MIN_VALUE || labelSpan != Integer.MIN_VALUE || labelFormat != null) {
            throw new IllegalArgumentException("Incomplete time axis settings");
        }
    }

    private static int resolveTimeUnit(String unit) {
        if (unit.equalsIgnoreCase("second")) {
            return 13;
        }
        if (unit.equalsIgnoreCase("minute")) {
            return 12;
        }
        if (unit.equalsIgnoreCase("hour")) {
            return 11;
        }
        if (unit.equalsIgnoreCase("day")) {
            return 5;
        }
        if (unit.equalsIgnoreCase("week")) {
            return 3;
        }
        if (unit.equalsIgnoreCase("month")) {
            return 2;
        }
        if (unit.equalsIgnoreCase("year")) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown time unit specified: " + unit);
    }
}

