/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.rrd4j.cmd.RrdCreateCmd;
import org.rrd4j.cmd.RrdDumpCmd;
import org.rrd4j.cmd.RrdFetchCmd;
import org.rrd4j.cmd.RrdGraphCmd;
import org.rrd4j.cmd.RrdInfoCmd;
import org.rrd4j.cmd.RrdLastCmd;
import org.rrd4j.cmd.RrdRestoreCmd;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.cmd.RrdTuneCmd;
import org.rrd4j.cmd.RrdUpdateCmd;
import org.rrd4j.cmd.RrdXportCmd;

public class RrdCommander {
    private static final RrdToolCmd[] rrdCommands = new RrdToolCmd[]{new RrdCreateCmd(), new RrdUpdateCmd(), new RrdLastCmd(), new RrdFetchCmd(), new RrdDumpCmd(), new RrdRestoreCmd(), new RrdXportCmd(), new RrdGraphCmd(), new RrdTuneCmd(), new RrdInfoCmd()};

    public static synchronized boolean isStandardOutUsed() {
        return RrdToolCmd.isStandardOutUsed();
    }

    public static synchronized void setStandardOutUsed(boolean standardOutUsed) {
        RrdToolCmd.setStandardOutUsed(standardOutUsed);
    }

    public static synchronized boolean isRrdDbPoolUsed() {
        return RrdToolCmd.isRrdDbPoolUsed();
    }

    public static synchronized void setRrdDbPoolUsed(boolean rrdDbPoolUsed) {
        RrdToolCmd.setRrdDbPoolUsed(rrdDbPoolUsed);
    }

    public static synchronized Object execute(String command) throws IOException {
        String rrdtool;
        String cmd = command.trim();
        if (cmd.startsWith(rrdtool = "rrdtool ")) {
            cmd = cmd.substring(rrdtool.length());
        }
        RrdToolCmd[] rrdToolCmdArray = rrdCommands;
        int n = rrdCommands.length;
        int n2 = 0;
        while (n2 < n) {
            RrdToolCmd rrdCommand = rrdToolCmdArray[n2];
            if (cmd.startsWith(String.valueOf(rrdCommand.getCmdType()) + " ")) {
                return rrdCommand.executeCommand(cmd);
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown RRDTool command: " + command);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("== Rrd4j's RRDTool commander ==");
        System.out.println("Type a RRDTool command after the dollar sign and press Enter.");
        System.out.println("Start your RRDTool command with 'create', 'update', 'fetch' etc.");
        System.out.println("Start line with 'create', 'update', 'fetch' etc.");
        System.out.println("Enter dot ('.') to bail out");
        System.out.println("Current directory is: " + new File(".").getCanonicalPath());
        System.out.println("================================");
        RrdToolCmd.setRrdDbPoolUsed(false);
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("$ ");
                    String s = r.readLine().trim();
                    if (s.length() <= 0) continue;
                    if (s.startsWith(".")) break block2;
                    RrdCommander.execute(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

