/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.MyAuthenticator;
import edu.sc.seis.seisFile.mseed.DataRecordIterator;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class FDSNDataSelectQuerier
extends AbstractFDSNQuerier {
    String username;
    String password;
    List<ChannelTimeWindow> request;
    FDSNDataSelectQueryParams queryParams;

    public FDSNDataSelectQuerier(FDSNDataSelectQueryParams queryParams) {
        this(queryParams, null);
    }

    public FDSNDataSelectQuerier(FDSNDataSelectQueryParams queryParams, List<ChannelTimeWindow> request) {
        this.queryParams = queryParams;
        this.request = request;
    }

    public void enableRestrictedData(String username, String password) {
        this.username = username;
        this.password = password;
        Authenticator.setDefault(new MyAuthenticator(username, password));
        this.queryParams.setFdsnQueryStyle("queryauth");
    }

    public DataRecordIterator getDataRecordIterator() throws SeisFileException {
        URI uri = null;
        try {
            if (this.request == null) {
                uri = this.queryParams.formURI();
                this.connect(uri);
            } else {
                this.connectForPost();
                uri = this.connectionUri;
            }
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    BufferedInputStream bif = new BufferedInputStream(this.getInputStream());
                    DataInputStream in = new DataInputStream(bif);
                    return new DataRecordIterator(in);
                }
                return new DataRecordIterator(new DataInputStream(new ByteArrayInputStream(new byte[0])));
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage(), uri);
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (MalformedURLException e) {
            throw new FDSNWSException("Error forming URL", e, uri);
        }
        catch (IOException e) {
            throw new FDSNWSException("Error with Connection", e, uri);
        }
    }

    void connectForPost() throws URISyntaxException, MalformedURLException, IOException {
        String postQuery = this.queryParams.formPostString(this.request);
        this.connectionUri = new URI(this.queryParams.getScheme(), this.queryParams.getUserInfo(), this.queryParams.getHost(), this.queryParams.getPort(), this.queryParams.getPath(), "", this.queryParams.getFragment());
        HttpURLConnection conn = (HttpURLConnection)this.connectionUri.toURL().openConnection();
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(this.getConnectTimeout());
        conn.setReadTimeout(this.getReadTimeout());
        conn.setRequestProperty("User-Agent", this.getUserAgent());
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        byte[] queryBytes = postQuery.getBytes();
        conn.setRequestProperty("Content-Length", "" + Integer.toString(queryBytes.length));
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.connect();
        OutputStream outputStream = conn.getOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outputStream));
        out.write(postQuery);
        out.close();
        this.processConnection(conn);
    }

    public void outputRaw(OutputStream out) throws MalformedURLException, IOException, FDSNWSException, URISyntaxException {
        if (this.request == null) {
            this.connect(this.queryParams.formURI());
        } else {
            this.connectForPost();
        }
        this.outputRaw(this.getInputStream(), out);
    }
}

