/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.TimeFormatter;
import java.util.StringTokenizer;

public class ChannelIdUtil {
    public static boolean areEqual(ChannelId a, ChannelId b) {
        return a.station_code.equals(b.station_code) && a.site_code.equals(b.site_code) && a.channel_code.equals(b.channel_code) && NetworkIdUtil.areEqual(a.network_id, b.network_id) && NetworkIdUtil.areEqual(a.begin_time, b.begin_time);
    }

    public static boolean areEqualExceptForBeginTime(ChannelId a, ChannelId b) {
        return a.station_code.equals(b.station_code) && a.site_code.equals(b.site_code) && a.channel_code.equals(b.channel_code) && NetworkIdUtil.areEqual(a.network_id, b.network_id);
    }

    public static String toStringNoDates(ChannelId id) {
        return NetworkIdUtil.toStringNoDates(id.network_id) + "." + id.station_code + "." + id.site_code + "." + id.channel_code;
    }

    public static String toStringNoDates(Channel chan) {
        return ChannelIdUtil.toStringNoDates(chan.get_id());
    }

    public static String toString(ChannelId id) {
        return NetworkIdUtil.toString(id.network_id) + "." + id.station_code + "." + id.site_code + "." + id.channel_code + "." + new MicroSecondDate((Time)id.begin_time).getFissuresTime().date_time;
    }

    public static ChannelId fromString(String s) {
        NetworkId netId = NetworkIdUtil.fromString(s);
        StringTokenizer st = NetworkIdUtil.getTokenizerAfterNetworkId(s);
        return new ChannelId(netId, st.nextToken(), st.nextToken(), st.nextToken(), new ISOTime(st.nextToken()).getDate().getFissuresTime());
    }

    public static String toStringFormatDates(ChannelId id) {
        return NetworkIdUtil.toStringFormatDates(id.network_id) + "." + id.station_code + "." + id.site_code + "." + id.channel_code + "." + TimeFormatter.format(id.begin_time);
    }

    public static int hashCode(ChannelId id) {
        return 12 + ChannelIdUtil.toString(id).hashCode();
    }
}

