/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.VDXSource;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import gov.usgs.winston.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RSAMSource
extends VDXSource {
    @Override
    public String getType() {
        return "rsam";
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action.equals("channels")) {
            List<Channel> chs = this.channels.getChannels();
            ArrayList<String> result = new ArrayList<String>();
            for (Channel ch : chs) {
                result.add(ch.toVDXString());
            }
            return new TextResult(result);
        }
        if (action.equals("ratdata")) {
            String cids = params.get("ch");
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            RSAMData data = null;
            try {
                data = this.getRatSAMData(cids, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return this.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else if (action.equals("data") || action == null) {
            int cid = Integer.parseInt(params.get("ch"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            String code = this.channels.getChannelCode(cid);
            RSAMData data = null;
            try {
                data = this.getData(code, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return this.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        }
        return null;
    }

    @Override
    protected RSAMData getData(String code, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        return this.data.getRSAMData(code, st, et, maxrows, ds, dsInt);
    }

    protected RSAMData getRatSAMData(String code, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        RSAMData result1 = null;
        RSAMData result2 = null;
        String[] codes = code.split(",");
        String code1 = this.channels.getChannelCode(Integer.valueOf(codes[0]));
        String code2 = this.channels.getChannelCode(Integer.valueOf(codes[1]));
        result1 = this.getData(code1, st, et, maxrows, ds, dsInt);
        result2 = this.getData(code2, st, et, maxrows, ds, dsInt);
        return result1.getRatSAM(result2);
    }
}

