package pickewanalysis;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import pickewanalysis.wavesources.TankFile;
import pickewanalysis.wavesources.WaveServer;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.miniSEEDFile;

public class AddSourceDialog extends javax.swing.JDialog {

    public AddSourceDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        sourcesTabbedPane = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        wsIPField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        wsPortField = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        tankFileField = new javax.swing.JTextField();
        tankFileBrowseButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        mseedFileField = new javax.swing.JTextField();
        mseedFileBrowseButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Add New Wave Source");

        jLabel3.setText("WaveServer IP");

        wsIPField.setText(" ");
        wsIPField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                wsIPFieldKeyReleased(evt);
            }
        });

        jLabel4.setText("WaveServer Port");

        wsPortField.setText(" ");
        wsPortField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                wsPortFieldKeyReleased(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addComponent(jLabel4))
                .addGap(29, 29, 29)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(wsPortField)
                    .addComponent(wsIPField, javax.swing.GroupLayout.DEFAULT_SIZE, 125, Short.MAX_VALUE))
                .addContainerGap(148, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(wsIPField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(wsPortField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(155, Short.MAX_VALUE))
        );

        sourcesTabbedPane.addTab("WaveServer", jPanel1);

        jLabel1.setText("Tank File");

        tankFileField.setText(" ");

        tankFileBrowseButton.setText("Browse");
        tankFileBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tankFileBrowseButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(tankFileField, javax.swing.GroupLayout.DEFAULT_SIZE, 246, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(tankFileBrowseButton)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(tankFileField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tankFileBrowseButton))
                .addContainerGap(178, Short.MAX_VALUE))
        );

        sourcesTabbedPane.addTab("Tank File", jPanel2);

        jLabel2.setText("miniSEED File");

        mseedFileField.setText(" ");

        mseedFileBrowseButton.setText("Browse");
        mseedFileBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mseedFileBrowseButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mseedFileField, javax.swing.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mseedFileBrowseButton)
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(mseedFileField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(mseedFileBrowseButton))
                .addContainerGap(178, Short.MAX_VALUE))
        );

        sourcesTabbedPane.addTab("miniSEED File", jPanel3);

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(sourcesTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(224, Short.MAX_VALUE)
                .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(sourcesTabbedPane, javax.swing.GroupLayout.PREFERRED_SIZE, 240, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        source = null;
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void tankFileBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tankFileBrowseButtonActionPerformed
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == JFileChooser.APPROVE_OPTION) {
            File selectedfile = filechooser.getSelectedFile();
            if (selectedfile != null) {
                try {
                    TankFile newsource = new TankFile();
                    newsource.setName(selectedfile.getAbsolutePath());
                    tankFileField.setText(selectedfile.getAbsolutePath());
                    tankSource = newsource;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }//GEN-LAST:event_tankFileBrowseButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        int selectedSource = sourcesTabbedPane.getSelectedIndex();
        WaveSource tempSource = null;
        switch (selectedSource) {
            case 0: //Waveserver
                tempSource = waveServerSource;
                break;
            case 1: //Tankfile
                tempSource = this.tankSource;
                break;
            case 2: //miniseedfile
                tempSource = this.mseedSource;
                break;
        }
        try {
            tempSource.update();
            source = tempSource;
        } catch (Exception e) {
            e.printStackTrace();
            new ErrorDialog("Unable to contact source: " + e.getMessage(), "Error", null, true).setVisible(true);
        }
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    private void mseedFileBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mseedFileBrowseButtonActionPerformed
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == JFileChooser.APPROVE_OPTION) {
            File selectedfile = filechooser.getSelectedFile();
            if (selectedfile != null) {
                try {
                    miniSEEDFile newsource = new miniSEEDFile();
                    newsource.setName(selectedfile.getAbsolutePath());
                    mseedFileField.setText(selectedfile.getAbsolutePath());
                    mseedSource = newsource;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }//GEN-LAST:event_mseedFileBrowseButtonActionPerformed

    private void wsPortFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_wsPortFieldKeyReleased
        setWaveServer(evt.getComponent());
    }//GEN-LAST:event_wsPortFieldKeyReleased

    private void wsIPFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_wsIPFieldKeyReleased
        setWaveServer(evt.getComponent());
    }//GEN-LAST:event_wsIPFieldKeyReleased

    public WaveSource getSource() {
        return source;
    }

    private void setWaveServer(Component c) {
        if (checkValidServerAddress(wsIPField.getText().trim(), wsPortField.getText().trim())) {
            waveServerSource = new WaveServer();
            String name = wsIPField.getText().trim() + ":"
                    + wsPortField.getText().trim();
            //System.out.println(name);
            waveServerSource.setName(name);
            wsIPField.setForeground(Color.BLACK);
            wsPortField.setForeground(Color.BLACK);
        } else {
            c.setForeground(Color.RED);
        }
    }

    private boolean checkValidServerAddress(String ip, String port) {
        int a;
        //Check ip
        if (ip.isEmpty()) {
            return false;
        }
        //Check ip address
        String[] parts = ip.split("[.]+");
        if (parts.length != 4) {
            return false;
        }
        //Check components of ip address
        for (int i = 0; i < 4; i++) {
            try {
                a = Integer.valueOf(parts[i].trim());
            } catch (Exception e) {
                //Found invalid address
                return false;
            }
        }
        //Check port
        if (port.isEmpty()) {
            return false;
        }
        //Check valid port number
        try {
            a = Integer.valueOf(port.trim());
        } catch (Exception e) {
            //Found invalid port
            return false;
        }
        return true;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JButton mseedFileBrowseButton;
    private javax.swing.JTextField mseedFileField;
    private javax.swing.JButton okButton;
    private javax.swing.JTabbedPane sourcesTabbedPane;
    private javax.swing.JButton tankFileBrowseButton;
    private javax.swing.JTextField tankFileField;
    private javax.swing.JTextField wsIPField;
    private javax.swing.JTextField wsPortField;
    // End of variables declaration//GEN-END:variables
    //Custom variables
    private WaveSource source;
    private TankFile tankSource;
    private miniSEEDFile mseedSource;
    private WaveServer waveServerSource;
}
