/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.sc.seis.seisFile.gcf.AbstractGCFBlock;
import edu.sc.seis.seisFile.gcf.GCFBlock;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import edu.sc.seis.seisFile.gcf.SerialCheckSumOutputStream;
import edu.sc.seis.seisFile.gcf.SerialTransportHeader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SerialTransportLayer {
    SerialTransportHeader header;
    int checksum;
    AbstractGCFBlock payload;
    int streamIdLSB;

    public SerialTransportLayer(int seqNum, AbstractGCFBlock payload, boolean isSerial) throws GCFFormatException {
        this(new SerialTransportHeader(seqNum, payload.getSize()), payload);
        GCFBlock b;
        if (isSerial && payload instanceof GCFBlock && (b = (GCFBlock)payload).getHeader().getCompression() == 1 && !b.isSerial) {
            throw new GCFFormatException("Can't write non-serial GCF block to serial");
        }
    }

    public SerialTransportLayer(SerialTransportHeader header, AbstractGCFBlock payload) {
        this(header, payload, 0, 0);
    }

    public SerialTransportLayer(SerialTransportHeader header, AbstractGCFBlock payload, int checksum, int streamIdLSB) {
        this.header = header;
        this.payload = payload;
        this.checksum = checksum;
        this.streamIdLSB = streamIdLSB;
    }

    public void write(DataOutputStream out) throws IOException {
        SerialCheckSumOutputStream csout = new SerialCheckSumOutputStream(out);
        this.header.write(out);
        this.payload.write(out);
        this.checksum = csout.writeCheckSum();
    }

    public SerialTransportHeader getHeader() {
        return this.header;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public AbstractGCFBlock getPayload() {
        return this.payload;
    }

    public int getStreamIdLSB() {
        return this.streamIdLSB;
    }

    public static SerialTransportLayer read(DataInput in) throws GCFFormatException, IOException {
        byte[] headerBytes = new byte[4];
        in.readFully(headerBytes);
        SerialTransportHeader header = SerialTransportHeader.fromBytes(headerBytes, 0);
        byte[] transportData = new byte[header.getBlockSize()];
        in.readFully(transportData);
        int checkSum = (in.readByte() << 8) + in.readByte();
        try {
            DataInputStream gcfIn = new DataInputStream(new ByteArrayInputStream(transportData));
            AbstractGCFBlock gcf = AbstractGCFBlock.read(gcfIn, true);
            byte streamIdLSB = transportData[11];
            return new SerialTransportLayer(header, gcf, checkSum, streamIdLSB);
        }
        catch (GCFFormatException e) {
            throw new GCFFormatException("byte array size: " + transportData.length + "  serialHeader:" + header, e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.checksum;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerialTransportLayer other = (SerialTransportLayer)obj;
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }
}

