/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.FileType;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.winston.in.StaticImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportSeed
extends StaticImporter {
    public static final String JSAP_PROGRAM_NAME = "java gov.usgs.winston.in.ImportSeed";
    public static final String JSAP_EXPLANATION = "Import miniSEED\n\nThis program imports data from miniSEED volumes into a winston database\n";
    private static final Parameter[] JSAP_PARAMETERS = new Parameter[]{new FlaggedOption("station", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 's', "station", "Override station identifier code\n"), new FlaggedOption("channel", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "channel", "Override channel identifier\n"), new FlaggedOption("network", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'n', "network", "Override network identifier\n"), new FlaggedOption("location", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'l', "location", "Override location identifier\n"), new FlaggedOption("rsamDelta", (StringParser)JSAP.INTEGER_PARSER, "10", false, 'r', "rsamDelta", "Override location identifier\n"), new FlaggedOption("rsamDuration", (StringParser)JSAP.INTEGER_PARSER, "60", false, 'd', "rsamDuration", "Override location identifier\n"), new UnflaggedOption("file", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, true, "files to import.")};
    private String network;
    private String station;
    private String channel;
    private String location;

    public ImportSeed() {
    }

    public ImportSeed(JSAPResult config) {
        this();
        this.network = config.getString("network");
        this.station = config.getString("station");
        this.channel = config.getString("channel");
        this.location = config.getString("location");
        this.rsamDelta = config.getInt("rsamDelta");
        this.rsamDuration = config.getInt("rsamDuration");
    }

    @Override
    public Map<String, List<Wave>> readFile(String fn) throws IOException {
        HashMap<String, List<Wave>> map = new HashMap<String, List<Wave>>();
        SeismicDataFile file = SeismicDataFile.getFile(fn, FileType.SEED);
        file.setNetwork(this.network);
        file.setStation(this.station);
        file.setChannel(this.channel);
        file.setLocation(this.location);
        file.read();
        for (String ch : file.getChannels()) {
            ArrayList<Wave> list = new ArrayList<Wave>();
            list.add(file.getWave(ch));
            map.put(ch, list);
        }
        return map;
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, JSAP_EXPLANATION, JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted() || config.getStringArray("file").length == 0) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    public static void main(String[] args) {
        JSAPResult config = ImportSeed.getArguments(args);
        System.out.printf("RSAM parameters: delta=%d, duration=%d.\n", config.getInt("rsamDelta"), config.getInt("rsamDuration"));
        ImportSeed is = new ImportSeed(config);
        ArrayList<String> files = new ArrayList<String>();
        for (String file : config.getStringArray("file")) {
            files.add(file);
        }
        ImportSeed.process(files, is);
    }
}

