/*
 * Decompiled with CFR 0.152.
 */
package nl.knmi.orfeus;

import edu.iris.Fissures.seed.container.Waveform;
import java.net.InetAddress;
import java.net.UnknownHostException;
import nl.knmi.orfeus.seedlink.SLLog;
import nl.knmi.orfeus.seedlink.SLPacket;
import nl.knmi.orfeus.seedlink.SeedLinkException;
import nl.knmi.orfeus.seedlink.client.SeedLinkConnection;

public class SLClient {
    public static final String PACKAGE = "nl.knmi.orfeus";
    public static final String CLASS_NAME = "SLClient";
    public static final String VERSION = "1.2.1X00";
    public static final String VERSION_YEAR = "2013";
    public static final String VERSION_DATE = "29Jan2013";
    public static final String COPYRIGHT_YEAR = "2013";
    public static final String PROGRAM_NAME = "SLClient v1.2.1X00";
    public static final String VERSION_INFO = "SLClient v1.2.1X00 (29Jan2013)";
    public static final String[] BANNER = new String[]{"SLClient v1.2.1X00 (29Jan2013)", "Copyright \u00a9 2013 Anthony Lomax (www.alomax.net)", "SLClient comes with ABSOLUTELY NO WARRANTY"};
    public SeedLinkConnection slconn = null;
    public int verbose = 0;
    public boolean ppackets = false;
    public String streamfile = null;
    public String selectors = null;
    public String multiselect = null;
    public String statefile = null;
    protected String begin_time = null;
    protected String end_time = null;
    public String infolevel = null;
    public SLLog sllog = null;

    public SLClient() {
        this(null);
    }

    public SLClient(SLLog sLLog) {
        for (int i = 0; i < BANNER.length; ++i) {
            System.out.println(BANNER[i]);
        }
        this.sllog = sLLog;
        this.slconn = new SeedLinkConnection(sLLog);
    }

    public int parseCmdLineArgs(String[] stringArray) {
        if (stringArray.length < 1) {
            this.printUsage(false);
            return 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-V")) {
                System.err.println(VERSION_INFO);
                return 1;
            }
            if (stringArray[i].equals("-h")) {
                this.printUsage(false);
                return 1;
            }
            if (stringArray[i].startsWith("-v")) {
                this.verbose += stringArray[i].length() - 1;
                continue;
            }
            if (stringArray[i].equals("-p")) {
                this.ppackets = true;
                continue;
            }
            if (stringArray[i].equals("-nt")) {
                this.slconn.setNetTimout(Integer.parseInt(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("-nd")) {
                this.slconn.setNetDelay(Integer.parseInt(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("-k")) {
                this.slconn.setKeepAlive(Integer.parseInt(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("-l")) {
                this.streamfile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-s")) {
                this.selectors = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-S")) {
                this.multiselect = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-x")) {
                this.statefile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-t")) {
                this.begin_time = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-e")) {
                this.end_time = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-i")) {
                this.infolevel = stringArray[++i];
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("Unknown option: " + stringArray[i]);
                return -1;
            }
            if (this.slconn.getSLAddress() == null) {
                this.slconn.setSLAddress(stringArray[i]);
                continue;
            }
            System.err.println("Unknown option: " + stringArray[i]);
            return -1;
        }
        return 0;
    }

    public void init() throws UnknownHostException, SeedLinkException {
        if (this.slconn.getSLAddress() == null) {
            String string = "no SeedLink server specified";
            throw new SeedLinkException(string);
        }
        if (this.sllog == null) {
            this.sllog = new SLLog(this.verbose, null, null, null, null);
        }
        this.slconn.setLog(this.sllog);
        if (this.verbose >= 2) {
            this.ppackets = true;
        }
        if (this.slconn.getSLAddress().startsWith(":")) {
            this.slconn.setSLAddress(InetAddress.getLocalHost().toString() + this.slconn.getSLAddress());
        }
        if (this.streamfile != null) {
            this.slconn.readStreamList(this.streamfile, this.selectors);
        }
        if (this.multiselect != null) {
            this.slconn.parseStreamlist(this.multiselect, this.selectors);
        } else if (this.streamfile == null) {
            this.slconn.setUniParams(this.selectors, -1, null);
        }
        if (this.statefile != null) {
            this.slconn.setStateFile(this.statefile);
        } else {
            if (this.begin_time != null) {
                this.slconn.setBeginTime(this.begin_time);
            }
            if (this.end_time != null) {
                this.slconn.setEndTime(this.end_time);
            }
        }
    }

    public void run() throws Exception {
        if (this.infolevel != null) {
            this.slconn.requestInfo(this.infolevel);
        }
        SLPacket sLPacket = null;
        int n = 1;
        while ((sLPacket = this.slconn.collect()) != null && sLPacket != SLPacket.SLTERMINATE) {
            try {
                boolean bl = this.packetHandler(n, sLPacket);
                if (bl) {
                    break;
                }
            }
            catch (SeedLinkException seedLinkException) {
                System.out.print("SLClient: " + seedLinkException);
            }
            if (n >= Integer.MAX_VALUE) {
                n = 1;
                System.out.println("DEBUG INFO: SLClient: Packet count reset to 1");
                continue;
            }
            ++n;
        }
        this.slconn.close();
    }

    public boolean packetHandler(int n, SLPacket sLPacket) throws Exception {
        String string;
        if (sLPacket == null || sLPacket == SLPacket.SLNOPACKET || sLPacket == SLPacket.SLERROR) {
            return false;
        }
        int n2 = sLPacket.getSequenceNumber();
        int n3 = sLPacket.getType();
        if (n3 == -102) {
            return false;
        }
        if (n3 == -101) {
            System.out.println("Complete INFO:\n" + this.slconn.getInfoString());
            return this.infolevel != null;
        }
        if (n % 100 == 0) {
            string = "ID";
            this.slconn.requestInfo(string);
        }
        System.out.println("SLClient: packet seqnum: " + n2 + ": packet type: " + n3);
        if (!this.ppackets) {
            return false;
        }
        string = sLPacket.getBlockette();
        System.out.println("SLClient: blockette type: " + string.getType() + ": blockette: " + string);
        Waveform waveform = string.getWaveform();
        if (waveform != null) {
            System.out.println("SLClient: blockette contains a waveform of length: " + waveform.getNumSamples());
        } else {
            System.out.println("SLClient: blockette contains no waveform");
        }
        return false;
    }

    public void printUsage(boolean bl) {
        System.err.println("\nUsage: java [-cp classpath] nl.knmi.orfeus.SLClient [options] <[host]:port>\n");
        if (bl) {
            System.err.println("Use '-h' for detailed help");
            return;
        }
        System.err.println(" ## General program options ##\n -V             report program version\n -h             show this usage message\n -v             be more verbose, multiple flags can be used\n -p             print details of data packets\n\n -nd delay      network re-connect delay (seconds), default 30\n -nt timeout    network timeout (seconds), re-establish connection if no\n                  data/keepalives are received in this time, default 600\n -k interval    send keepalive (heartbeat) packets this often (seconds)\n -x statefile   save/restore stream state information to this file\n -t begintime   sets a beginning time for the initiation of data transmission (year,month,day,hour,minute,second)\n -e endtime     sets an end time for windowed data transmission  (year,month,day,hour,minute,second)\n -i infolevel   request this INFO level, write response to std out, and exit \n                  infolevel is one of: ID, STATIONS, STREAMS, GAPS, CONNECTIONS, ALL \n\n ## Data stream selection ##\n -l listfile    read a stream list from this file for multi-station mode\n -s selectors   selectors for uni-station or default for multi-station\n -S streams     select streams for multi-station (requires SeedLink >= 2.5)\n   'streams' = 'stream1[:selectors1],stream2[:selectors2],...'\n        'stream' is in NET_STA format, for example:\n        -S \"IU_KONO:BHE BHN,GE_WLF,MN_AQU:HH?.D\"\n\n <[host]:port>  Address of the SeedLink server in host:port format\n                  if host is omitted (i.e. ':18000'), localhost is assumed\n\n");
    }

    public static void main(String[] stringArray) {
        SLClient sLClient = null;
        try {
            sLClient = new SLClient();
            int n = sLClient.parseCmdLineArgs(stringArray);
            if (n != 0) {
                System.exit(n);
            }
            sLClient.init();
            sLClient.run();
        }
        catch (SeedLinkException seedLinkException) {
            if (sLClient != null) {
                sLClient.sllog.log(true, 0, seedLinkException.getMessage());
            } else {
                System.err.println("ERROR: " + seedLinkException.getMessage());
                seedLinkException.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

