/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Equipment {
    String resourceId;
    protected String type;
    protected String description;
    protected String manufacturer;
    protected String vendor;
    protected String model;
    protected String serialNumber;
    protected String installationDate;
    protected String removalDate;
    protected List<String> calibrationDate;

    public Equipment(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        this(reader, "Equipment");
    }

    public Equipment(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        this.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (this.parseSubElement(elName, reader)) continue;
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    void parseAttributes(StartElement startE) throws StationXMLException {
        this.resourceId = StaxUtil.pullAttributeIfExists(startE, "resourceId");
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("Type")) {
            this.type = StaxUtil.pullText(reader, "Type");
            return true;
        }
        if (elName.equals("Description")) {
            this.description = StaxUtil.pullText(reader, "Description");
            return true;
        }
        if (elName.equals("Manufacturer")) {
            this.manufacturer = StaxUtil.pullText(reader, "Manufacturer");
            return true;
        }
        if (elName.equals("Vendor")) {
            this.vendor = StaxUtil.pullText(reader, "Vendor");
            return true;
        }
        if (elName.equals("Model")) {
            this.model = StaxUtil.pullText(reader, "Model");
            return true;
        }
        if (elName.equals("SerialNumber")) {
            this.serialNumber = StaxUtil.pullText(reader, "SerialNumber");
            return true;
        }
        if (elName.equals("InstallationDate")) {
            this.installationDate = StaxUtil.pullText(reader, "InstallationDate");
            return true;
        }
        if (elName.equals("RemovalDate")) {
            this.removalDate = StaxUtil.pullText(reader, "RemovalDate");
            return true;
        }
        if (elName.equals("CalibrationDate")) {
            this.calibrationDate.add(StaxUtil.pullText(reader, "CalibrationDate"));
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getInstallationDate() {
        return this.installationDate;
    }

    public String getRemovalDate() {
        return this.removalDate;
    }

    public List<String> getCalibrationDate() {
        return this.calibrationDate;
    }
}

