/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.DataBlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;

public class DataRecord
extends SeedRecord
implements Serializable {
    protected byte[] data;
    byte ZERO_BYTE = 0;

    public DataRecord(DataHeader header) {
        super(header);
    }

    public DataRecord(DataRecord record) {
        super(new DataHeader(record.getHeader().getSequenceNum(), record.getHeader().getTypeCode(), record.getHeader().isContinuation()));
        this.RECORD_SIZE = record.RECORD_SIZE;
        this.getHeader().setActivityFlags(record.getHeader().getActivityFlags());
        this.getHeader().setChannelIdentifier(record.getHeader().getChannelIdentifier());
        this.getHeader().setDataBlocketteOffset((short)record.getHeader().getDataBlocketteOffset());
        this.getHeader().setDataOffset((short)record.getHeader().getDataOffset());
        this.getHeader().setDataQualityFlags(record.getHeader().getDataQualityFlags());
        this.getHeader().setIOClockFlags(record.getHeader().getIOClockFlags());
        this.getHeader().setLocationIdentifier(record.getHeader().getLocationIdentifier());
        this.getHeader().setNetworkCode(record.getHeader().getNetworkCode());
        this.getHeader().setNumSamples((short)record.getHeader().getNumSamples());
        this.getHeader().setSampleRateFactor((short)record.getHeader().getSampleRateFactor());
        this.getHeader().setSampleRateMultiplier((short)record.getHeader().getSampleRateMultiplier());
        this.getHeader().setStartBtime(record.getHeader().getStartBtime());
        this.getHeader().setStationIdentifier(record.getHeader().getStationIdentifier());
        this.getHeader().setTimeCorrection(record.getHeader().getTimeCorrection());
        try {
            this.setData(record.getData());
            for (int j = 0; j < record.getBlockettes().length; ++j) {
                this.blockettes.add(record.getBlockettes()[j]);
            }
        }
        catch (SeedFormatException e) {
            throw new RuntimeException("Shouldn't happen as record was valid and we are copying it");
        }
    }

    @Override
    public void addBlockette(Blockette b) throws SeedFormatException {
        if (b == null) {
            throw new IllegalArgumentException("Blockette cannot be null");
        }
        if (b instanceof BlocketteUnknown) {
            b = new DataBlocketteUnknown(((BlocketteUnknown)b).info, b.getType(), ((BlocketteUnknown)b).getSwapBytes());
        }
        if (!(b instanceof DataBlockette)) {
            throw new SeedFormatException("Cannot add non-data blockettes to a DataRecord " + b.getType());
        }
        super.addBlockette(b);
        this.getHeader().setNumBlockettes((byte)(this.getHeader().getNumBlockettes() + 1));
        if (b instanceof Blockette1000) {
            this.RECORD_SIZE = ((Blockette1000)b).getLogicalRecordLength();
        }
        this.recheckDataOffset();
    }

    protected void recheckDataOffset() throws SeedFormatException {
        int size = this.getHeader().getSize();
        Blockette[] blocks = this.getBlockettes();
        for (int i = 0; i < blocks.length; ++i) {
            size += blocks[i].getSize();
        }
        if (this.data != null) {
            size += this.data.length;
        }
        if (size > this.RECORD_SIZE) {
            int headerSize = size;
            if (this.data != null) {
                headerSize = size - this.data.length;
            }
            throw new SeedFormatException("Can't fit blockettes and data in record " + headerSize + " + " + (this.data == null ? 0 : this.data.length) + " > " + this.RECORD_SIZE);
        }
        if (this.data != null) {
            this.getHeader().setDataOffset((short)(this.RECORD_SIZE - this.data.length));
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public DecompressedData decompress() throws SeedFormatException, UnsupportedCompressionType, CodecException {
        if (this.getHeader().getNumSamples() == 0) {
            return new DecompressedData(new int[0]);
        }
        Blockette1000 b1000 = (Blockette1000)this.getUniqueBlockette(1000);
        if (b1000 == null) {
            throw new MissingBlockette1000(this.getHeader());
        }
        Codec codec = new Codec();
        return codec.decompress((int)b1000.getEncodingFormat(), this.getData(), this.getHeader().getNumSamples(), b1000.isLittleEndian());
    }

    public void setData(byte[] data) throws SeedFormatException {
        this.data = data;
        this.recheckDataOffset();
    }

    public int getDataSize() {
        return this.data.length;
    }

    public DataHeader getHeader() {
        return (DataHeader)this.header;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteStream);
            this.write(dos);
            dos.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException, should not happen.", e);
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        int i;
        Blockette[] blocks = this.getBlockettes();
        this.getHeader().setNumBlockettes((byte)blocks.length);
        if (blocks.length != 0) {
            this.getHeader().setDataBlocketteOffset((short)48);
        }
        this.getHeader().write(dos);
        short blockettesSize = this.getHeader().getSize();
        for (i = 0; i < blocks.length; ++i) {
            DataBlockette dataB = (DataBlockette)blocks[i];
            blockettesSize = (short)(blockettesSize + (short)dataB.getSize());
            if (i != blocks.length - 1) {
                dos.write(dataB.toBytes(blockettesSize));
                continue;
            }
            dos.write(dataB.toBytes((short)0));
        }
        for (i = (int)blockettesSize; i < this.getHeader().getDataOffset(); ++i) {
            dos.write(this.ZERO_BYTE);
        }
        dos.write(this.data);
        int remainBytes = this.RECORD_SIZE - this.getHeader().getDataOffset() - this.data.length;
        for (int i2 = 0; i2 < remainBytes; ++i2) {
            dos.write(this.ZERO_BYTE);
        }
    }

    public void writeData(PrintWriter out) {
        byte[] d = this.getData();
        DecimalFormat byteFormat = new DecimalFormat("000");
        for (int i = 0; i < d.length; ++i) {
            out.write(byteFormat.format(0xFF & d[i]) + " ");
            if (i % 4 == 3) {
                out.write("  ");
            }
            if (i % 16 != 15 || i == 0) continue;
            out.write("\n");
        }
    }

    public static SeedRecord readDataRecord(DataInput inStream, DataHeader header, int defaultRecordSize) throws IOException, SeedFormatException {
        try {
            byte[] timeseries;
            byte[] garbage;
            byte[] garbage2;
            boolean swapBytes = header.flagByteSwap();
            DataRecord dataRec = new DataRecord(header);
            if (header.getDataBlocketteOffset() != 0 && (garbage2 = new byte[header.getDataBlocketteOffset() - header.getSize()]).length != 0) {
                inStream.readFully(garbage2);
            }
            int currOffset = header.getDataBlocketteOffset();
            if (header.getDataBlocketteOffset() == 0) {
                currOffset = header.getSize();
            }
            for (int i = 0; i < header.getNumBlockettes(); ++i) {
                byte hibyteType = inStream.readByte();
                byte lowbyteType = inStream.readByte();
                int type = Utility.uBytesToInt(hibyteType, lowbyteType, swapBytes);
                byte hibyteOffset = inStream.readByte();
                byte lowbyteOffset = inStream.readByte();
                int nextOffset = Utility.uBytesToInt(hibyteOffset, lowbyteOffset, swapBytes);
                byte[] blocketteBytes = nextOffset != 0 ? new byte[nextOffset - currOffset] : (header.getDataOffset() > currOffset ? new byte[header.getDataOffset() - (currOffset += 4)] : new byte[]{});
                inStream.readFully(blocketteBytes);
                currOffset = nextOffset != 0 ? nextOffset : (currOffset += blocketteBytes.length);
                byte[] fullBlocketteBytes = new byte[blocketteBytes.length + 4];
                System.arraycopy(blocketteBytes, 0, fullBlocketteBytes, 4, blocketteBytes.length);
                fullBlocketteBytes[0] = hibyteType;
                fullBlocketteBytes[1] = lowbyteType;
                fullBlocketteBytes[2] = hibyteOffset;
                fullBlocketteBytes[3] = lowbyteOffset;
                Blockette b = SeedRecord.getBlocketteFactory().parseBlockette(type, fullBlocketteBytes, swapBytes);
                dataRec.blockettes.add(b);
                if (nextOffset == 0) break;
            }
            int recordSize = defaultRecordSize;
            try {
                recordSize = ((Blockette1000)dataRec.getUniqueBlockette(1000)).getDataRecordLength();
            }
            catch (MissingBlockette1000 e) {
                if (defaultRecordSize == 0) {
                    throw e;
                }
                recordSize = defaultRecordSize;
            }
            dataRec.RECORD_SIZE = recordSize;
            if (header.getDataOffset() != 0 && (garbage = new byte[header.getDataOffset() - currOffset]).length != 0) {
                inStream.readFully(garbage);
            }
            if (header.getDataOffset() == 0) {
                timeseries = new byte[recordSize - currOffset];
            } else {
                if (recordSize < header.getDataOffset()) {
                    throw new SeedFormatException("recordSize < header.getDataOffset(): " + recordSize + " < " + header.getDataOffset());
                }
                timeseries = new byte[recordSize - header.getDataOffset()];
            }
            inStream.readFully(timeseries);
            dataRec.setData(timeseries);
            return dataRec;
        }
        catch (SeedFormatException e) {
            e.setHeader(header);
            throw e;
        }
    }

    public void setRecordSize(int recordSize) throws SeedFormatException {
        int tmp = this.RECORD_SIZE;
        this.RECORD_SIZE = recordSize;
        try {
            this.recheckDataOffset();
        }
        catch (SeedFormatException e) {
            this.RECORD_SIZE = tmp;
            throw e;
        }
    }

    @Override
    public String toString() {
        String s = "Data " + super.toString();
        s = s + "\n" + this.data.length + " bytes of data read.";
        return s;
    }
}

