/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ConfidenceEllipsoid {
    public static final String ELEMENT_NAME = "confidenceEllipsoid";
    Float semiMajorAxisLength;
    Float semiMinorAxisLength;
    Float semiIntermediateAxisLength;
    Float majorAxisPlunge;
    Float majorAxisAzimuth;
    Float majorAxisRotation;

    public ConfidenceEllipsoid(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("semiMajorAxisLength")) {
                    this.semiMajorAxisLength = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "semiMajorAxisLength")));
                    continue;
                }
                if (elName.equals("semiMinorAxisLength")) {
                    this.semiMinorAxisLength = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "semiMinorAxisLength")));
                    continue;
                }
                if (elName.equals("semiIntermediateAxisLength")) {
                    this.semiIntermediateAxisLength = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "semiIntermediateAxisLength")));
                    continue;
                }
                if (elName.equals("majorAxisPlunge")) {
                    this.majorAxisPlunge = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "majorAxisPlunge")));
                    continue;
                }
                if (elName.equals("majorAxisAzimuth")) {
                    this.majorAxisAzimuth = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "majorAxisAzimuth")));
                    continue;
                }
                if (elName.equals("majorAxisRotation")) {
                    this.majorAxisRotation = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "majorAxisRotation")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Float getSemiMajorAxisLength() {
        return this.semiMajorAxisLength;
    }

    public Float getSemiMinorAxisLength() {
        return this.semiMinorAxisLength;
    }

    public Float getSemiIntermediateAxisLength() {
        return this.semiIntermediateAxisLength;
    }

    public Float getMajorAxisPlunge() {
        return this.majorAxisPlunge;
    }

    public Float getMajorAxisAzimuth() {
        return this.majorAxisAzimuth;
    }

    public Float getMajorAxisRotation() {
        return this.majorAxisRotation;
    }
}

