/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.tensorstrain;

import gov.usgs.math.DownsamplingType;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.tensorstrain.TensorstrainData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SQLTensorstrainDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "tensorstrain";
    public static final boolean channels = true;
    public static final boolean translations = true;
    public static final boolean channelTypes = false;
    public static final boolean ranks = true;
    public static final boolean columns = true;
    public static final boolean menuColumns = true;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "CH0", "CH0", "nanostrain", false, true, false), new Column(2, "CH1", "CH1", "nanostrain", false, true, false), new Column(3, "CH2", "CH2", "nanostrain", false, true, false), new Column(4, "CH3", "CH3", "nanostrain", false, true, false), new Column(5, "eEEpeNN", "eEE+eNN", "nanostrain", false, true, false), new Column(6, "eEEmeNN", "eEE-eNN", "nanostrain", false, true, false), new Column(7, "e2EN", "e2EN)", "nanostrain", false, true, false), new Column(8, "baro", "barometer", "hPa", false, true, false), new Column(9, "rain", "rainfall", "mm", false, true, false), new Column(10, "pore", "pore pressure", "hPa", false, true, false)};
    public static final Column[] MENU_COLUMNS = new Column[]{new Column(1, "CH0", "CH0", "nanostrain", false, true, false), new Column(2, "CH1", "CH1", "nanostrain", false, true, false), new Column(3, "CH2", "CH2", "nanostrain", false, true, false), new Column(4, "CH3", "CH3", "nanostrain", false, true, false), new Column(5, "eEEpeNN", "eEE+eNN", "nanostrain", false, true, false), new Column(6, "eEEmeNN", "eEE-eNN", "nanostrain", false, true, false), new Column(7, "e2EN", "e2EN", "nanostrain", false, true, false), new Column(8, "eXXmeYY", "eXX-eYY", "nanostrain", false, true, false), new Column(9, "e2XY", "e2XY", "nanostrain", false, true, false), new Column(10, "baro", "barometer", "hPa", false, true, false), new Column(11, "rain", "rainfall", "mm", false, true, false), new Column(12, "pore", "pore pressure", "hPa", false, true, false)};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return true;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return true;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            int i;
            this.defaultCreateDatabase(true, true, false, true, true, true);
            for (i = 0; i < DATA_COLUMNS.length; ++i) {
                this.defaultInsertColumn(DATA_COLUMNS[i]);
            }
            for (i = 0; i < MENU_COLUMNS.length; ++i) {
                this.defaultInsertMenuColumn(MENU_COLUMNS[i]);
            }
            this.defaultCreateTranslation();
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.st.execute("ALTER TABLE channels ADD natural_azimuth DOUBLE DEFAULT 0");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTensorstrainDataSource.createDatabase() failed.", e);
            return false;
        }
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int active, int tid, double natural_azimuth) {
        Channel channel = new Channel(0, channelCode, channelName, lon, lat, height, active, natural_azimuth);
        return this.defaultCreateTiltChannel(channel, tid, natural_azimuth, true, true, true, true);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals("columns")) {
            return new TextResult(this.defaultGetMenuColumns(true));
        }
        if (action.equals("azimuths")) {
            return new TextResult(this.getAzimuths());
        }
        if (action.equals("data")) {
            int cid = Integer.parseInt(params.get("ch"));
            int rid = Integer.parseInt(params.get("rk"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            return this.getTensorstrainData(cid, rid, st, et, this.getMaxRows(), ds, dsInt);
        }
        if (action.equals("supptypes")) {
            return this.getSuppTypes(true);
        }
        if (action.equals("suppdata")) {
            return this.getSuppData(params, false);
        }
        if (action.equals("metadata")) {
            return this.getMetaData(params, false);
        }
        return null;
    }

    public RequestResult getTensorstrainData(int cid, int rid, double st, double et, int maxrows, DownsamplingType ds, int dsInt) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        BinaryResult result = null;
        int columnsReturned = 0;
        try {
            int i;
            double[] dataRow;
            this.database.useDatabase(this.dbName);
            Channel channel = this.defaultGetChannel(cid, false);
            columnsReturned = 12;
            int tempmaxrows = rid != 0 ? maxrows : maxrows * this.defaultGetNumberOfRanks();
            this.sql = "SELECT j2ksec, c.rid, ";
            this.sql = this.sql + "       CH0 * cCH0 + dCH0, ";
            this.sql = this.sql + "       CH1 * cCH1 + dCH1, ";
            this.sql = this.sql + "       CH2 * cCH2 + dCH2, ";
            this.sql = this.sql + "       CH3 * cCH3 + dCH3, ";
            this.sql = this.sql + "       eEEpeNN * ceEEpeNN + deEEpeNN, ";
            this.sql = this.sql + "       eEEmeNN  * ceEEmeNN  + deEEmeNN,  ";
            this.sql = this.sql + "       e2EN * ce2EN + de2EN, ";
            this.sql = this.sql + "       baro * cbaro + dbaro,  ";
            this.sql = this.sql + "       rain * crain + drain,  ";
            this.sql = this.sql + "       pore * cpore + dpore  ";
            this.sql = this.sql + "FROM " + channel.getCode() + " a ";
            this.sql = this.sql + "       INNER JOIN translations  b ON a.tid = b.tid ";
            this.sql = this.sql + "       INNER JOIN ranks         c ON a.rid = c.rid ";
            this.sql = this.sql + "WHERE  j2ksec >= ? ";
            this.sql = this.sql + "AND    j2ksec <= ? ";
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 FROM " + channel.getCode() + " a INNER JOIN ranks c ON a.rid = c.rid ";
            this.sqlCount = this.sqlCount + "WHERE j2ksec >= ? AND j2ksec <= ? ";
            if (rid != 0) {
                this.sql = this.sql + "AND   c.rid = ? ";
                this.sqlCount = this.sqlCount + "AND c.rid = ? ";
            }
            this.sql = this.sql + "ORDER BY j2ksec ASC";
            this.sqlCount = this.sqlCount + "ORDER BY j2ksec ASC";
            if (rid == 0) {
                this.sql = this.sql + ", c.rank DESC";
                this.sqlCount = this.sqlCount + ", c.rank DESC";
            }
            if (rid != 0) {
                try {
                    this.sql = SQLTensorstrainDataSource.getDownsamplingSQL(this.sql, "j2ksec", ds, dsInt);
                }
                catch (UtilException e) {
                    return SQLTensorstrainDataSource.getErrorResult("Can't downsample dataset: " + e.getMessage());
                }
            }
            if (maxrows != 0) {
                this.sql = this.sql + " LIMIT " + (tempmaxrows + 1);
                if (ds.equals((Object)DownsamplingType.NONE)) {
                    this.ps = this.database.getPreparedStatement(this.sqlCount + " LIMIT " + (maxrows + 1) + ") as T");
                    this.ps.setDouble(1, st);
                    this.ps.setDouble(2, et);
                    if (rid != 0) {
                        this.ps.setInt(3, rid);
                    }
                    this.rs = this.ps.executeQuery();
                    if (this.rs.next() && this.rs.getInt(1) > tempmaxrows) {
                        return SQLTensorstrainDataSource.getErrorResult("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded. Please use downsampling.");
                    }
                }
            }
            this.ps = this.database.getPreparedStatement(this.sql);
            if (ds.equals((Object)DownsamplingType.MEAN)) {
                this.ps.setDouble(1, st);
                this.ps.setInt(2, dsInt);
                this.ps.setDouble(3, st);
                this.ps.setDouble(4, et);
                if (rid != 0) {
                    this.ps.setInt(5, rid);
                }
            } else {
                this.ps.setDouble(1, st);
                this.ps.setDouble(2, et);
                if (rid != 0) {
                    this.ps.setInt(3, rid);
                }
            }
            this.rs = this.ps.executeQuery();
            if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && SQLTensorstrainDataSource.getResultSetSize(this.rs) > tempmaxrows) {
                return SQLTensorstrainDataSource.getErrorResult("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded. Please use downsampling.");
            }
            double tempJ2ksec = Double.MAX_VALUE;
            while (this.rs.next()) {
                if (Double.compare(tempJ2ksec, this.rs.getDouble(1)) != 0) {
                    dataRow = new double[columnsReturned];
                    for (i = 0; i < columnsReturned; ++i) {
                        dataRow[i] = this.getDoubleNullCheck(this.rs, i + 1);
                    }
                    pts.add(dataRow);
                }
                tempJ2ksec = this.rs.getDouble(1);
            }
            this.rs.close();
            if (pts.size() == 0) {
                dataRow = new double[columnsReturned];
                for (i = 0; i < columnsReturned; ++i) {
                    dataRow[i] = Double.NaN;
                }
                pts.add(dataRow);
            }
            result = new BinaryResult(new TensorstrainData(pts));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTensorstrainDataSource.getTensorstrainData()", e);
            return null;
        }
        return result;
    }

    public List<String> getAzimuths() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT cid, natural_azimuth FROM channels ORDER BY cid").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%f", this.rs.getInt(1), this.rs.getDouble(2)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLTensorstrainDataSource.getAzimuths() failed.", e);
        }
        return result;
    }
}

