/*
 * Decompiled with CFR 0.152.
 */
package com.isti.dhi;

import com.isti.dhi.CorbaAccess;
import com.isti.dhi.DhiChannel;
import com.isti.dhi.FissuresUtils;
import com.isti.dhi.IChannelInfo;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;

public class DhiDataServer {
    public static final String FILE_EXIST_ERROR = "error";
    public static final String FILE_EXIST_IGNORE = "ignore";
    public static final String FILE_EXIST_OVERWRITE = "overwrite";
    public static final String[] FILE_EXIST_VALUES = new String[]{"error", "ignore", "overwrite"};
    private final File fissuresPropsFile;
    private CorbaAccess _corbaAccess = null;

    public DhiDataServer(File fissuresPropsFile) {
        this.fissuresPropsFile = fissuresPropsFile;
    }

    public CorbaAccess getCorbaAccess() {
        if (this._corbaAccess == null) {
            this._corbaAccess = new CorbaAccess(this.fissuresPropsFile);
        }
        return this._corbaAccess;
    }

    public static final String getFileExistValue(String text) {
        if (text != null) {
            for (int i = 0; i < FILE_EXIST_VALUES.length; ++i) {
                if (!text.equalsIgnoreCase(FILE_EXIST_VALUES[i])) continue;
                return FILE_EXIST_VALUES[i];
            }
        }
        return null;
    }

    public File[] getSEEDFiles(IChannelInfo channelInfo, Date startTime, Date endTime, File outputFile, String fileExistValue) throws Exception {
        CorbaAccess corbaAccess = this.getCorbaAccess();
        if (corbaAccess == null) {
            System.err.println("Could not get SEED files, no Corba access");
            return null;
        }
        LocalSeismogram[] localSeismograms = corbaAccess.getData(channelInfo, startTime, endTime);
        if (localSeismograms == null || localSeismograms.length <= 0) {
            return null;
        }
        File[] seedFiles = new File[localSeismograms.length];
        for (int i = 0; i < localSeismograms.length; ++i) {
            LocalSeismogram localSeismogram = localSeismograms[i];
            File currentOutputFile = FissuresUtils.getMSeedFile(new DhiChannel(localSeismogram), FissuresUtils.getDate(localSeismogram.begin_time), outputFile, fileExistValue.equals(FILE_EXIST_ERROR));
            if (!currentOutputFile.exists() || fileExistValue.equals(FILE_EXIST_OVERWRITE)) {
                System.out.println("writing seed file [" + i + "]: " + currentOutputFile.getPath());
                seedFiles[i] = FissuresUtils.writeMSeed(localSeismogram, currentOutputFile);
                continue;
            }
            System.out.println("seed file already exists [" + i + "]: " + currentOutputFile.getPath());
            seedFiles[i] = currentOutputFile;
        }
        return seedFiles;
    }

    public static final void printFileExistValues(PrintStream ps) {
        ps.println("Possible exist values are:");
        for (int i = 0; i < FILE_EXIST_VALUES.length; ++i) {
            ps.println(FILE_EXIST_VALUES[i]);
        }
    }
}

