/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

public class RealFFTUtils_2D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private final int columns;
    private final int rows;

    public RealFFTUtils_2D(int n, int n2) {
        this.columns = n2;
        this.rows = n;
    }

    public int getIndex(int n, int n2) {
        int n3 = n2 & 1;
        int n4 = n << 1;
        if (n != 0) {
            if (n2 <= 1) {
                if (n4 == this.rows) {
                    if (n3 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return this.rows * this.columns >> 1;
                }
                if (n4 < this.rows) {
                    return this.columns * n + n3;
                }
                if (n3 == 0) {
                    return this.columns * (this.rows - n);
                }
                return -(this.columns * (this.rows - n) + 1);
            }
            if (n2 == this.columns || n2 == this.columns + 1) {
                if (n4 == this.rows) {
                    if (n3 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return (this.rows * this.columns >> 1) + 1;
                }
                if (n4 < this.rows) {
                    if (n3 == 0) {
                        return this.columns * (this.rows - n) + 1;
                    }
                    return -(this.columns * (this.rows - n));
                }
                return this.columns * n + 1 - n3;
            }
            if (n2 < this.columns) {
                return this.columns * n + n2;
            }
            if (n3 == 0) {
                return this.columns * (this.rows + 2 - n) - n2;
            }
            return -(this.columns * (this.rows + 2 - n) - n2 + 2);
        }
        if (n2 == 1 || n2 == this.columns + 1) {
            return Integer.MIN_VALUE;
        }
        if (n2 == this.columns) {
            return 1;
        }
        if (n2 < this.columns) {
            return n2;
        }
        if (n3 == 0) {
            return (this.columns << 1) - n2;
        }
        return -((this.columns << 1) - n2 + 2);
    }

    public void pack(double d, int n, int n2, double[] dArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            dArray[n3 + n4] = d;
        } else if (n4 > Integer.MIN_VALUE) {
            dArray[n3 - n4] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public void pack(double d, int n, int n2, double[][] dArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            dArray[n3 / this.columns][n3 % this.columns] = d;
        } else if (n3 > Integer.MIN_VALUE) {
            dArray[-n3 / this.columns][-n3 % this.columns] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public void pack(float f, int n, int n2, float[] fArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            fArray[n3 + n4] = f;
        } else if (n4 > Integer.MIN_VALUE) {
            fArray[n3 - n4] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public void pack(float f, int n, int n2, float[][] fArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            fArray[n3 / this.columns][n3 % this.columns] = f;
        } else if (n3 > Integer.MIN_VALUE) {
            fArray[-n3 / this.columns][-n3 % this.columns] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public double unpack(int n, int n2, double[] dArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            return dArray[n3 + n4];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -dArray[n3 - n4];
        }
        return 0.0;
    }

    public double unpack(int n, int n2, double[][] dArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            return dArray[n3 / this.columns][n3 % this.columns];
        }
        if (n3 > Integer.MIN_VALUE) {
            return -dArray[-n3 / this.columns][-n3 % this.columns];
        }
        return 0.0;
    }

    public float unpack(int n, int n2, float[] fArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            return fArray[n3 + n4];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -fArray[n3 - n4];
        }
        return 0.0f;
    }

    public float unpack(int n, int n2, float[][] fArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            return fArray[n3 / this.columns][n3 % this.columns];
        }
        if (n3 > Integer.MIN_VALUE) {
            return -fArray[-n3 / this.columns][-n3 % this.columns];
        }
        return 0.0f;
    }
}

