/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.Downcall;
import com.ooc.OB.DowncallEmitter;
import com.ooc.OB.GIOPClient;
import com.ooc.OB.GIOPIncomingMessage;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Util;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContextListHolder;

abstract class GIOPClientWorker
implements DowncallEmitter {
    protected ORBInstance orbInstance_;
    protected GIOPClient client_;
    protected Transport transport_;
    protected Buffer buf_;
    protected GIOPIncomingMessage incoming_;
    protected boolean messageSent_;
    protected byte minor_;
    protected boolean closeLogged_;
    protected int shutdownTimeout_;
    protected int acmTimeout_;
    protected long timestamp_;
    protected Vector unsent_ = new Vector();
    protected Vector pending_ = new Vector();
    public static final int StateActive = 0;
    public static final int StateClosing = 1;
    public static final int StateError = 2;
    public static final int StateClosed = 4;
    protected int state_;
    protected SystemException exception_;

    protected void logCloseConnection() {
        if (!this.closeLogged_) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                TransportInfo transportInfo = this.transport_.get_info();
                String string = "closing connection\n";
                string = String.valueOf(string) + transportInfo.describe();
                this.orbInstance_.getLogger().trace("outgoing", string);
            }
            this.closeLogged_ = true;
        }
    }

    protected void addCloseConnection() {
        if (this.minor_ < 2) {
            return;
        }
        Buffer buffer = new Buffer(12);
        OutputStream outputStream = new OutputStream(buffer);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
        this.addUnsent(buffer);
    }

    protected void addMessageError() {
        Buffer buffer = new Buffer(12);
        OutputStream outputStream = new OutputStream(buffer);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = 1;
        profileInfo.minor = this.minor_;
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
        this.addUnsent(buffer);
    }

    protected void addMessageHeader(Downcall downcall) {
        OutputStream outputStream = downcall.output();
        int n = outputStream._OB_pos();
        outputStream._OB_pos(0);
        ProfileInfo profileInfo = downcall.profileInfo();
        GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
        gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.Request, false, n - 12);
        outputStream._OB_pos(n);
    }

    protected void addUnsent(Buffer buffer) {
        this.updateTimestamp();
        if (this.state_ == 2 || this.state_ == 4) {
            return;
        }
        this.unsent_.addElement(new UnsentMessage(buffer));
    }

    protected void addUnsent(Downcall downcall) {
        this.updateTimestamp();
        if (this.exception_ != null) {
            downcall.setFailureException(this.exception_);
            return;
        }
        Assert.assert(this.state_ != 1 && this.state_ != 2 && this.state_ != 4);
        try {
            OutputStream outputStream = downcall.output();
            int n = outputStream._OB_pos();
            outputStream._OB_pos(0);
            ProfileInfo profileInfo = downcall.profileInfo();
            GIOPOutgoingMessage gIOPOutgoingMessage = new GIOPOutgoingMessage(this.orbInstance_, outputStream, profileInfo);
            gIOPOutgoingMessage.writeMessageHeader(MsgType_1_1.Request, false, n - 12);
            outputStream._OB_pos(n);
        }
        catch (SystemException systemException) {
            Assert.assert(systemException.completed == CompletionStatus.COMPLETED_NO);
            downcall.setFailureException(systemException);
            return;
        }
        byte by = downcall.profileInfo().minor;
        if (by > this.minor_) {
            this.minor_ = by;
        }
        this.unsent_.addElement(new UnsentMessage(downcall));
    }

    protected void moveFirstUnsentToPending() {
        if (this.unsent_.isEmpty()) {
            Assert.assert(this.exception_ != null);
            return;
        }
        UnsentMessage unsentMessage = (UnsentMessage)this.unsent_.firstElement();
        Downcall downcall = unsentMessage.down;
        this.unsent_.removeElementAt(0);
        this.messageSent_ = true;
        if (downcall != null) {
            if (downcall.responseExpected()) {
                downcall.setPending();
                this.pending_.addElement(downcall);
                return;
            }
            downcall.setNoException(null);
        }
    }

    protected Downcall findAndRemovePending(int n) {
        int n2 = 0;
        while (n2 < this.pending_.size()) {
            Downcall downcall = (Downcall)this.pending_.elementAt(n2);
            if (downcall.requestId() == n) {
                this.pending_.removeElementAt(n2);
                return downcall;
            }
            ++n2;
        }
        return null;
    }

    protected boolean exception(int n, SystemException systemException, boolean bl) {
        if (this.state_ == n) {
            return false;
        }
        if (n < this.state_) {
            return false;
        }
        if (this.exception_ == null) {
            Object object;
            this.exception_ = Util.copySystemException(systemException);
            this.exception_.completed = CompletionStatus.COMPLETED_NO;
            while (!this.unsent_.isEmpty()) {
                object = (UnsentMessage)this.unsent_.firstElement();
                if (((UnsentMessage)object).down != null) {
                    ((UnsentMessage)object).down.setFailureException(this.exception_);
                }
                this.unsent_.removeElementAt(0);
            }
            object = Util.copySystemException(this.exception_);
            if (!bl) {
                ((SystemException)object).completed = CompletionStatus.COMPLETED_MAYBE;
            }
            while (!this.pending_.isEmpty()) {
                Downcall downcall = (Downcall)this.pending_.firstElement();
                downcall.setFailureException((SystemException)object);
                this.pending_.removeElementAt(0);
            }
        }
        switch (n) {
            case 1: {
                this.addCloseConnection();
                this.client_.removeWorker(this);
                break;
            }
            case 2: {
                this.addMessageError();
                this.client_.removeWorker(this);
                break;
            }
            case 4: {
                this.logCloseConnection();
                this.transport_.close();
                this.client_.removeWorker(this);
                break;
            }
        }
        this.state_ = n;
        return true;
    }

    protected final void exception(int n, SystemException systemException) {
        this.exception(n, systemException, false);
    }

    protected void execute() {
        boolean bl;
        Assert.assert(this.state_ == 0 || this.state_ == 1);
        this.updateTimestamp();
        try {
            Buffer buffer = this.buf_;
            this.buf_ = null;
            bl = this.incoming_.consumeBuffer(buffer);
        }
        catch (SystemException systemException) {
            this.exception(2, systemException);
            return;
        }
        byte by = this.incoming_.version().minor;
        if (by > this.minor_) {
            this.minor_ = by;
        }
        if (!bl) {
            return;
        }
        switch (this.incoming_.type().value()) {
            case 1: {
                int n = 0;
                ReplyStatusType_1_2Holder replyStatusType_1_2Holder = new ReplyStatusType_1_2Holder();
                ServiceContextListHolder serviceContextListHolder = new ServiceContextListHolder();
                try {
                    n = this.incoming_.readReplyHeader(replyStatusType_1_2Holder, serviceContextListHolder);
                }
                catch (SystemException systemException) {
                    this.exception(2, systemException);
                    return;
                }
                Downcall downcall = this.findAndRemovePending(n);
                if (downcall == null) {
                    this.exception(2, new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577432)) + ": " + n, 1330577432, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                downcall.setReplySCL(serviceContextListHolder.value);
                InputStream inputStream = this.incoming_.input();
                switch (replyStatusType_1_2Holder.value.value()) {
                    case 0: {
                        downcall.setNoException(inputStream);
                        return;
                    }
                    case 1: {
                        downcall.setUserException(inputStream);
                        return;
                    }
                    case 2: {
                        SystemException systemException = Util.unmarshalSystemException(inputStream);
                        downcall.setSystemException(systemException);
                        return;
                    }
                    case 3: {
                        IOR iOR = IORHelper.read(inputStream);
                        downcall.setLocationForward(iOR, false);
                        return;
                    }
                    case 4: {
                        IOR iOR = IORHelper.read(inputStream);
                        downcall.setLocationForward(iOR, true);
                        return;
                    }
                    case 5: {
                        Assert.assert(false);
                        return;
                    }
                }
                Assert.assert(false);
                return;
            }
            case 0: 
            case 2: 
            case 3: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                return;
            }
            case 4: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                return;
            }
            case 5: {
                this.exception(4, new TRANSIENT(MinorCodes.describeTransient(1330577410), 1330577410, CompletionStatus.COMPLETED_MAYBE), true);
                return;
            }
            case 6: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577429), 1330577429, CompletionStatus.COMPLETED_MAYBE));
                return;
            }
            case 7: {
                Assert.assert(false);
                return;
            }
        }
    }

    protected void updateTimestamp() {
        if (this.acmTimeout_ > 0) {
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }
    }

    protected void finalize() throws Throwable {
        Assert.assert(this.state_ == 4);
        super.finalize();
    }

    GIOPClientWorker(ORBInstance oRBInstance, GIOPClient gIOPClient, Transport transport, int n) {
        this.orbInstance_ = oRBInstance;
        this.client_ = gIOPClient;
        this.transport_ = transport;
        this.incoming_ = new GIOPIncomingMessage(this.orbInstance_);
        this.messageSent_ = false;
        this.minor_ = 0;
        this.closeLogged_ = false;
        this.acmTimeout_ = n;
        this.state_ = 0;
        Properties properties = this.orbInstance_.getProperties();
        String string = properties.getProperty("ooc.orb.client_shutdown_timeout");
        this.shutdownTimeout_ = string != null ? Integer.parseInt(string) : 2;
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo transportInfo = this.transport_.get_info();
            String string2 = "new connection\n";
            string2 = String.valueOf(string2) + transportInfo.describe();
            this.orbInstance_.getLogger().trace("outgoing", string2);
        }
        this.updateTimestamp();
    }

    abstract void destroy();

    final Transport transport() {
        return this.transport_;
    }

    final boolean messageSent() {
        return this.messageSent_;
    }

    public abstract boolean send(Downcall var1, boolean var2);

    public abstract boolean receive(Downcall var1, boolean var2);

    public abstract boolean sendReceive(Downcall var1);

    protected class UnsentMessage {
        Buffer buf;
        Downcall down;

        UnsentMessage(Buffer buffer) {
            GIOPClientWorker.this = GIOPClientWorker.this;
            this.buf = buffer;
            this.buf.pos(0);
        }

        UnsentMessage(Downcall downcall) {
            GIOPClientWorker.this = GIOPClientWorker.this;
            this.down = downcall;
            this.buf = downcall.output()._OB_buffer();
            this.buf.pos(0);
        }
    }
}

