/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.CharMapInfo;
import com.ooc.OB.CodeConverterBase;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.CodeSetInfo;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;

public final class CodeConverter
extends CodeConverterBase {
    private CharMapInfo fromMap_;
    private CharMapInfo toMap_;
    private int conversionType_;

    CodeConverter(CodeSetInfo codeSetInfo, CodeSetInfo codeSetInfo2) {
        super(codeSetInfo, codeSetInfo2);
        CodeSetDatabase codeSetDatabase = CodeSetDatabase.instance();
        if (codeSetInfo != null) {
            if (codeSetInfo.max_bytes == 1) {
                if (codeSetInfo.rgy_value != 65537) {
                    this.fromMap_ = codeSetDatabase.getCharMapInfo(codeSetInfo);
                }
            } else if (codeSetInfo.rgy_value != 65801) {
                this.fromMap_ = codeSetDatabase.getCharMapInfo(codeSetInfo);
            }
        }
        if (codeSetInfo2 != null) {
            if (codeSetInfo2.max_bytes == 1) {
                if (codeSetInfo2.rgy_value != 65537) {
                    this.toMap_ = codeSetDatabase.getCharMapInfo(codeSetInfo2);
                }
            } else if (codeSetInfo2.rgy_value != 65801) {
                this.toMap_ = codeSetDatabase.getCharMapInfo(codeSetInfo2);
            }
        }
        if (this.fromMap_ != null && this.toMap_ != null) {
            this.conversionType_ = 3;
            return;
        }
        if (this.fromMap_ != null) {
            this.conversionType_ = 1;
            return;
        }
        if (this.toMap_ != null) {
            this.conversionType_ = 2;
            return;
        }
        this.conversionType_ = 0;
    }

    public int getConversionType() {
        return this.conversionType_;
    }

    public char convertCharFrom(char c) {
        char c2 = c;
        if (c2 >= (char)this.fromMap_.lower_bound && c2 <= (char)this.fromMap_.upper_bound) {
            c2 = (char)this.fromMap_.map_values[c2 - this.fromMap_.lower_bound];
        }
        return c2;
    }

    public char convertCharTo(char c) {
        char c2 = c;
        int n = 0;
        while (n <= this.toMap_.upper_bound - this.toMap_.lower_bound) {
            if (this.toMap_.map_values[n] == c2) {
                c2 = (char)(this.toMap_.lower_bound + n);
                break;
            }
            ++n;
        }
        return c2;
    }

    public char convertCharBoth(char c) {
        char c2 = c;
        if (c2 >= (char)this.fromMap_.lower_bound && c2 <= (char)this.fromMap_.upper_bound) {
            c2 = (char)this.fromMap_.map_values[c2 - this.fromMap_.lower_bound];
        }
        int n = 0;
        while (n <= this.toMap_.upper_bound - this.toMap_.lower_bound) {
            if (this.toMap_.map_values[n] == c2) {
                c2 = (char)(this.toMap_.lower_bound + n);
                break;
            }
            ++n;
        }
        return c2;
    }

    public void write_wchar(OutputStream outputStream, char c) throws DATA_CONVERSION {
        if (this.toSet_.rgy_value == 0x5010001) {
            CodeSetUtil.unicodeToUtf8(outputStream, c);
            return;
        }
        int n = this.count_wchar(c);
        char c2 = c;
        while (n != 0) {
            outputStream.buf_.data_[outputStream.buf_.pos_ + --n] = (byte)c2;
            c2 = (char)(c2 >> 8);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int count_wchar(InputStream inputStream) {
        if (this.toSet_.rgy_value != 0x5010001) return this.toSet_.max_bytes;
        byte by = inputStream.buf_.data_[inputStream.buf_.pos_];
        if ((by & 0x80) == 0) {
            return 1;
        }
        if ((by & 0xE0) == 192) {
            return 2;
        }
        if ((by & 0xF0) == 224) {
            return 3;
        }
        if ((by & 0xF8) == 240) {
            return 4;
        }
        if ((by & 0xFC) == 248) {
            return 5;
        }
        if ((by & 0xFE) != 252) throw new MARSHAL(MinorCodes.describeMarshal(1330577427), 1330577427, CompletionStatus.COMPLETED_NO);
        return 6;
    }

    public int count_wchar(char c) {
        int n = this.toSet_.rgy_value == 0x5010001 ? (c < '\u0080' ? 1 : (c < '\u07ff' ? 2 : 3)) : this.toSet_.max_bytes;
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public char read_wchar(InputStream var1_1, int var2_2) throws DATA_CONVERSION {
        if (this.toSet_.rgy_value != 0x5010001) ** GOTO lbl5
        return CodeSetUtil.utf8ToUnicode(var1_1);
lbl-1000:
        // 1 sources

        {
            ++var1_1.buf_.pos_;
            --var2_2;
lbl5:
            // 2 sources

            ** while (var2_2 > 1 && var1_1.buf_.data_[var1_1.buf_.pos_] == 0)
        }
lbl6:
        // 1 sources

        if (var2_2 == 0 || var2_2 > 2 || var2_2 > this.fromSet_.max_bytes) {
            throw new DATA_CONVERSION();
        }
        block0 : switch (var2_2) {
            case 1: {
                var3_3 = (char)(var1_1.buf_.data_[var1_1.buf_.pos_++] & 255);
                break;
            }
            case 2: {
                switch (this.toSet_.max_bytes) {
                    case 2: 
                    case 4: {
                        var3_3 = (char)(var1_1.buf_.data_[var1_1.buf_.pos_++] << 8);
                        var3_3 = (char)(var3_3 | (char)var1_1.buf_.data_[var1_1.buf_.pos_++] & 255);
                        break block0;
                    }
                }
                throw new DATA_CONVERSION();
            }
            default: {
                throw new DATA_CONVERSION();
            }
        }
        return var3_3;
    }

    public char convert_wchar_to(char c) throws DATA_CONVERSION {
        char c2 = c;
        if (c2 != '\u0000') {
            if (this.fromMap_ != null && c2 >= (char)this.fromMap_.lower_bound && c2 <= (char)this.fromMap_.upper_bound) {
                c2 = (char)this.fromMap_.map_values[c2 - this.fromMap_.lower_bound];
            }
            if (this.toMap_ != null) {
                int n = 0;
                while (n <= this.toMap_.upper_bound - this.toMap_.lower_bound) {
                    if (this.toMap_.map_values[n] == c2) {
                        c2 = (char)(this.toMap_.lower_bound + n);
                        break;
                    }
                    ++n;
                }
            }
        }
        return c2;
    }

    public char convert_wchar_from(char c) throws DATA_CONVERSION {
        char c2 = c;
        if (c2 != '\u0000') {
            if (this.toMap_ != null && c2 >= (char)this.toMap_.lower_bound && c2 <= (char)this.toMap_.upper_bound) {
                c2 = (char)this.toMap_.map_values[c2 - this.toMap_.lower_bound];
            }
            if (this.fromMap_ != null) {
                int n = 0;
                while (n <= this.fromMap_.upper_bound - this.fromMap_.lower_bound) {
                    if (this.fromMap_.map_values[n] == c2) {
                        c2 = (char)(this.fromMap_.lower_bound + n);
                        break;
                    }
                    ++n;
                }
            }
        }
        return c2;
    }
}

