/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

public class SQLRSAMDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "rsam";
    public static final boolean channels = true;
    public static final boolean translations = false;
    public static final boolean channelTypes = false;
    public static final boolean ranks = false;
    public static final boolean columns = true;
    public static final boolean menuColumns = false;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "rsam", "RSAM", "RSAM", false, true, false)};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return false;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        this.defaultCreateDatabase(true, false, false, false, true, false);
        for (int i = 0; i < DATA_COLUMNS.length; ++i) {
            this.defaultInsertColumn(DATA_COLUMNS[i]);
        }
        return true;
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int active) {
        return this.defaultCreateChannel(channelCode, channelName, lon, lat, height, active, 0, true, false, false, true);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("data")) {
            int cid = Integer.parseInt(params.get("ch"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            RSAMData data = null;
            try {
                data = this.getRSAMData(cid, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return SQLRSAMDataSource.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else if (action.equals("ratdata")) {
            String cids = params.get("ch");
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            RSAMData data = null;
            try {
                data = this.getRatSAMData(cids, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return SQLRSAMDataSource.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else {
            if (action.equals("supptypes")) {
                return this.getSuppTypes(true);
            }
            if (action.equals("suppdata")) {
                return this.getSuppData(params, false);
            }
            if (action.equals("metadata")) {
                return this.getMetaData(params, false);
            }
        }
        return null;
    }

    public RSAMData getRSAMData(int cid, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        RSAMData result = null;
        try {
            double[] dataRow;
            this.database.useDatabase(this.dbName);
            Channel ch = this.defaultGetChannel(cid, false);
            this.sql = "SELECT j2ksec, rsam ";
            this.sql = this.sql + "FROM   " + ch.getCode() + " ";
            this.sql = this.sql + "WHERE  j2ksec >= ? ";
            this.sql = this.sql + "AND    j2ksec <= ? ";
            this.sql = this.sql + "ORDER BY j2ksec";
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 ";
            this.sqlCount = this.sqlCount + this.sql.substring(this.sql.indexOf("FROM"));
            try {
                this.sql = SQLRSAMDataSource.getDownsamplingSQL(this.sql, "j2ksec", ds, dsInt);
            }
            catch (UtilException e) {
                throw new UtilException("Can't downsample dataset: " + e.getMessage());
            }
            if (maxrows != 0) {
                this.sql = this.sql + " LIMIT " + (maxrows + 1);
                if (ds.equals((Object)DownsamplingType.NONE)) {
                    this.ps = this.database.getPreparedStatement(this.sqlCount + " LIMIT " + (maxrows + 1) + ") as T");
                    this.ps.setDouble(1, st);
                    this.ps.setDouble(2, et);
                    this.rs = this.ps.executeQuery();
                    if (this.rs.next() && this.rs.getInt(1) > maxrows) {
                        throw new UtilException("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded. Please use downsampling.");
                    }
                }
            }
            this.ps = this.database.getPreparedStatement(this.sql);
            if (ds.equals((Object)DownsamplingType.MEAN)) {
                this.ps.setDouble(1, st);
                this.ps.setInt(2, dsInt);
                this.ps.setDouble(3, st);
                this.ps.setDouble(4, et);
            } else {
                this.ps.setDouble(1, st);
                this.ps.setDouble(2, et);
            }
            this.rs = this.ps.executeQuery();
            if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && SQLRSAMDataSource.getResultSetSize(this.rs) > maxrows) {
                throw new UtilException("Max rows (" + maxrows + " rows) for source '" + this.vdxName + "' exceeded. Please downsample further.");
            }
            while (this.rs.next()) {
                dataRow = new double[]{this.getDoubleNullCheck(this.rs, 1), this.getDoubleNullCheck(this.rs, 2)};
                pts.add(dataRow);
            }
            this.rs.close();
            if (pts.size() == 0) {
                dataRow = new double[]{Double.NaN, Double.NaN};
                pts.add(dataRow);
            }
            result = new RSAMData(pts);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLRSAMDataSource.getRSAMData()", e);
        }
        return result;
    }

    public RSAMData getRatSAMData(String ch, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        RSAMData result1 = null;
        RSAMData result2 = null;
        String[] channels = ch.split(",");
        int ch1 = Integer.valueOf(channels[0]);
        int ch2 = Integer.valueOf(channels[1]);
        result1 = this.getRSAMData(ch1, st, et, maxrows, ds, dsInt);
        result2 = this.getRSAMData(ch2, st, et, maxrows, ds, dsInt);
        return result1.getRatSAM(result2);
    }
}

