/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.gps;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;

public class Estimator {
    public DoubleMatrix2D WG;
    public DoubleMatrix2D Wd;
    public DoubleMatrix2D m;
    public DoubleMatrix2D dhat;
    public DoubleMatrix2D mcov;
    public DoubleMatrix2D r;
    public double chi2;

    public Estimator(DoubleMatrix2D G, DoubleMatrix2D d, DoubleMatrix2D dcov) {
        this.WG = G.copy();
        this.Wd = DoubleFactory2D.dense.make(this.WG.rows(), 1);
        for (int i = 0; i < this.WG.rows() / 3; ++i) {
            double sxx = dcov.getQuick(i, 0);
            double syy = dcov.getQuick(i, 1);
            double szz = dcov.getQuick(i, 2);
            double sxy = dcov.getQuick(i, 3);
            double sxz = dcov.getQuick(i, 4);
            double syz = dcov.getQuick(i, 5);
            double t1 = sxy * sxy - sxx * syy;
            double t2 = Math.sqrt((sxz * sxz * syy - 2.0 * sxy * sxz * syz + sxx * syz * syz) / (sxy * sxy - sxx * syy) + szz);
            double w1 = 1.0 / Math.sqrt(sxx);
            double w2 = -sxy / sxx / Math.sqrt(syy - sxy * sxy / sxx);
            double w3 = (sxz * syy - sxy * syz) / t1 / t2;
            double w4 = 1.0 / Math.sqrt(syy - sxy * sxy / sxx);
            double w5 = (sxx * syz - sxy * sxz) / t1 / t2;
            double w6 = 1.0 / t2;
            this.Wd.setQuick(i * 3, 0, d.getQuick(i, 0) * w1);
            this.Wd.setQuick(i * 3 + 1, 0, d.getQuick(i, 0) * w2 + d.getQuick(i, 1) * w4);
            this.Wd.setQuick(i * 3 + 2, 0, d.getQuick(i, 0) * w3 + d.getQuick(i, 1) * w5 + d.getQuick(i, 2) * w6);
            for (int j = 0; j < this.WG.columns() / 3; ++j) {
                double M = G.getQuick(i * 3, j * 3);
                this.WG.setQuick(i * 3, j * 3, M * w1);
                this.WG.setQuick(i * 3 + 1, j * 3, M * w2);
                this.WG.setQuick(i * 3 + 2, j * 3, M * w3);
                this.WG.setQuick(i * 3 + 1, j * 3 + 1, M * w4);
                this.WG.setQuick(i * 3 + 2, j * 3 + 1, M * w5);
                this.WG.setQuick(i * 3 + 2, j * 3 + 2, M * w6);
            }
        }
    }

    public void solve() {
        this.mcov = Algebra.DEFAULT.inverse(Algebra.DEFAULT.mult(Algebra.DEFAULT.transpose(this.WG), this.WG));
        this.m = Algebra.DEFAULT.mult(Algebra.DEFAULT.mult(this.mcov, Algebra.DEFAULT.transpose(this.WG)), this.Wd);
        this.dhat = Algebra.DEFAULT.mult(this.WG, this.m);
        this.r = this.dhat.copy();
        for (int i = 0; i < this.Wd.rows(); ++i) {
            this.r.setQuick(i, 0, this.Wd.getQuick(i, 0) - this.dhat.getQuick(i, 0));
        }
        this.chi2 = Algebra.DEFAULT.mult(this.r.viewDice(), this.r).getQuick(0, 0) / (double)(this.Wd.rows() - 6);
    }

    public DoubleMatrix2D getModel() {
        return this.m;
    }

    public DoubleMatrix2D getModelCovariance() {
        return this.mcov;
    }

    public DoubleMatrix2D getPrediction() {
        return this.dhat;
    }

    public DoubleMatrix2D getResidual() {
        return this.r;
    }

    public double getChi2() {
        return this.chi2;
    }
}

