/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.util.ConfigFile;
import gov.usgs.vdx.data.DataSource;

public class DataSourceDescriptor {
    private String name;
    private String className;
    private String description;
    private ConfigFile params;
    private DataSource dataSource;

    public DataSourceDescriptor(String n, String c, String d, ConfigFile p) {
        this.name = n;
        this.className = c;
        this.description = d;
        this.params = p;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigFile getParams() {
        return this.params;
    }

    private void instantiateDataSource() {
        try {
            this.dataSource = (DataSource)Class.forName(this.className).newInstance();
            Class.forName(this.className).getMethod("initialize", ConfigFile.class).invoke((Object)this.dataSource, this.params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void uninstantiateDataSource() {
        try {
            Class.forName(this.className).getMethod("disconnect", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DataSource getDataSource() {
        if (this.dataSource == null && this.className != null) {
            this.instantiateDataSource();
        }
        return this.dataSource;
    }

    public void putDataSource() {
        if (this.dataSource != null && this.className != null) {
            this.uninstantiateDataSource();
        }
    }
}

