/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

public class StationInfo {
    private final String station;
    private final String network;
    private final double latitude;
    private final double longitude;
    private final String siteName;

    public static double parseDouble(String s) {
        if (s != null && s.length() != 0) {
            try {
                return Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public StationInfo(String station, String network, double latitude, double longitude) {
        this(station, network, latitude, longitude, null);
    }

    public StationInfo(String station, String network, double latitude, double longitude, String siteName) {
        this.station = station;
        this.network = network;
        this.latitude = latitude;
        this.longitude = longitude;
        this.siteName = siteName != null ? siteName : station;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getStation() {
        return this.station;
    }

    public String toString() {
        return this.station + " " + this.network + " " + this.latitude + " " + this.longitude + " " + this.siteName;
    }
}

