/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.MomentTensor;
import edu.sc.seis.seisFile.fdsnws.quakeml.NodalPlane;
import edu.sc.seis.seisFile.fdsnws.quakeml.PrincipalAxes;
import edu.sc.seis.seisFile.fdsnws.quakeml.WaveformStreamID;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FocalMechanism {
    public static final String ELEMENT_NAME = "focalMechanism";
    String publicId;
    MomentTensor momentTensor;
    NodalPlane[] nodalPlane = new NodalPlane[2];
    PrincipalAxes principalAxes;
    String evaluationMode;
    String evaluationStatus;
    String methodID;
    WaveformStreamID waveformID;
    String triggeringOriginID;
    List<Comment> commentList = new ArrayList<Comment>();
    CreationInfo creationInfo;

    public FocalMechanism(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("momentTensor")) {
                    this.momentTensor = new MomentTensor(reader);
                    continue;
                }
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                if (elName.equals("nodalPlanes")) {
                    StaxUtil.expectStartElement("nodalPlanes", reader);
                    XMLEvent nodePlaneEl = reader.peek();
                    while (!nodePlaneEl.isStartElement()) {
                        reader.next();
                        nodePlaneEl = reader.peek();
                    }
                    if (nodePlaneEl.isStartElement() && nodePlaneEl.asStartElement().getName().getLocalPart().equals("nodalPlane1")) {
                        this.nodalPlane[0] = new NodalPlane(reader, "nodalPlane1");
                        XMLEvent secNodePlaneEl = reader.peek();
                        while (!secNodePlaneEl.isStartElement()) {
                            reader.next();
                            secNodePlaneEl = reader.peek();
                        }
                        if (secNodePlaneEl.isStartElement() && secNodePlaneEl.asStartElement().getName().getLocalPart().equals("nodalPlane2")) {
                            this.nodalPlane[1] = new NodalPlane(reader, "nodalPlane2");
                        } else {
                            StaxUtil.skipToMatchingEnd(reader);
                        }
                        StaxUtil.skipToStartElement(reader);
                        continue;
                    }
                    StaxUtil.skipToMatchingEnd(reader);
                    continue;
                }
                if (elName.equals("principalAxes")) {
                    this.principalAxes = new PrincipalAxes(reader);
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("waveformID")) {
                    this.waveformID = new WaveformStreamID(reader, "waveformID");
                    continue;
                }
                if (elName.equals("triggeringOriginID")) {
                    this.triggeringOriginID = StaxUtil.pullText(reader, "triggeringOriginID");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public MomentTensor getMomentTensor() {
        return this.momentTensor;
    }

    public NodalPlane[] getNodalPlane() {
        return this.nodalPlane;
    }

    public PrincipalAxes getPrincipalAxes() {
        return this.principalAxes;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public WaveformStreamID getWaveformID() {
        return this.waveformID;
    }

    public String getTriggeringOriginID() {
        return this.triggeringOriginID;
    }
}

