/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/

package ewquakealert;

import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

/**
 * The main class of the application.
 */
public class EWQuakeAlertApp extends SingleFrameApplication {

    /**
     * At startup create and show the main frame of the application.
     */
    @Override protected void startup() {
        show(new EWQuakeAlertView(this));
    }

    /**
     * This method is to initialize the specified window by injecting resources.
     * Windows shown in our application come fully initialized from the GUI
     * builder, so this additional configuration is not needed.
     */
    @Override protected void configureWindow(java.awt.Window root) {
    }

    /**
     * A convenient static getter for the application instance.
     * @return the instance of EWQuakeAlertApp
     */
    public static EWQuakeAlertApp getApplication() {
        return Application.getInstance(EWQuakeAlertApp.class);
    }

    /**
     * Main method launching the application.
     */
    public static void main(String[] args) {


        System.setProperty("user.timezone","Etc/Universal");
        Configuration config = new Configuration();
        config.loadConfig(config);

        try{
            Thread.sleep(1000);

        }
        catch (Exception e){
            
        }

        ImportClient importClient = new ImportClient();
        importClient.start();

        launch(EWQuakeAlertApp.class, args);
        
        

    }
}
