/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.GainSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class InstrumentSensitivity
extends GainSensitivity {
    Unit inputUnits;
    Unit outputUnits;
    float frequencyStart;
    float frequencyEnd;
    float frequencyDbVariation;

    public InstrumentSensitivity(float value, float frequency) {
        super(value, frequency);
    }

    public InstrumentSensitivity(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("InstrumentSensitivity", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("InputUnits")) {
                    this.inputUnits = new Unit(reader, "InputUnits");
                    continue;
                }
                if (elName.equals("OutputUnits")) {
                    this.outputUnits = new Unit(reader, "OutputUnits");
                    continue;
                }
                if (elName.equals("FrequencyStart")) {
                    this.frequencyStart = StaxUtil.pullFloat(reader, "FrequencyStart");
                    continue;
                }
                if (elName.equals("FrequencyEnd")) {
                    this.frequencyEnd = StaxUtil.pullFloat(reader, "FrequencyEnd");
                    continue;
                }
                if (elName.equals("FrequencyDBVariation")) {
                    this.frequencyDbVariation = StaxUtil.pullFloat(reader, "FrequencyDBVariation");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Unit getInputUnits() {
        return this.inputUnits;
    }

    public Unit getOutputUnits() {
        return this.outputUnits;
    }

    public float getFrequencyStart() {
        return this.frequencyStart;
    }

    public float getFrequencyEnd() {
        return this.frequencyEnd;
    }

    public float getFrequencyDbVariation() {
        return this.frequencyDbVariation;
    }
}

