/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.in.ColumnValue;
import gov.usgs.vdx.in.Import;
import gov.usgs.vdx.in.Importer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ImportFile
extends Import
implements Importer {
    public ResourceReader rr;

    @Override
    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.processConfigFile(configFile);
    }

    @Override
    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    @Override
    public void processConfigFile(String configFile) {
        int i;
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, configFile + " was not successfully read");
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), "VDX.config");
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.dateIn = new SimpleDateFormat(Util.stringToString(this.params.getString("timestamp"), "yyyy-MM-dd HH:mm:ss"));
        this.dateIn.setTimeZone(TimeZone.getTimeZone(Util.stringToString(this.params.getString("timezone"), "GMT")));
        this.filemask = Util.stringToString(this.params.getString("filemask"), "");
        this.headerlines = Util.stringToInt(this.params.getString("headerlines"), 0);
        this.delimiter = Util.stringToString(this.params.getString("delimiter"), ",");
        this.logger.log(Level.INFO, "filemask:" + this.filemask + "/headerlines:" + this.headerlines + "/delimiter:" + this.delimiter);
        this.fields = Util.stringToString(this.params.getString("fields"), "");
        if (this.fields.length() == 0) {
            this.logger.log(Level.SEVERE, "fields parameter missing from config file");
            System.exit(-1);
        }
        this.fieldArray = this.fields.split(",");
        this.defaultFieldMap = new HashMap();
        for (i = 0; i < this.fieldArray.length; ++i) {
            this.defaultFieldMap.put(i, this.fieldArray[i].trim());
        }
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "Raw Data");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
        this.logger.log(Level.INFO, "[Rank] " + this.rankName);
        this.logger.log(Level.INFO, "");
        this.channelMap = new HashMap();
        this.channelFieldMap = new HashMap();
        this.stringList = this.params.getList("channel");
        if (this.stringList != null) {
            for (i = 0; i < this.stringList.size(); ++i) {
                this.channelCode = (String)this.stringList.get(i);
                this.channelParams = this.params.getSubConfig(this.channelCode);
                this.channelName = Util.stringToString(this.channelParams.getString("name"), this.channelCode);
                this.channelLon = Util.stringToDouble(this.channelParams.getString("longitude"), Double.NaN);
                this.channelLat = Util.stringToDouble(this.channelParams.getString("latitude"), Double.NaN);
                this.channelHeight = Util.stringToDouble(this.channelParams.getString("height"), Double.NaN);
                this.channelActive = Util.stringToInt(this.channelParams.getString("active"), 1);
                this.channel = new Channel(0, this.channelCode, this.channelName, this.channelLon, this.channelLat, this.channelHeight, this.channelActive);
                this.channelMap.put(this.channelCode, this.channel);
                this.channelFieldMap.put(this.channelCode, Util.stringToString(this.channelParams.getString("fields"), this.fields));
            }
        }
        this.dataSourceList = this.params.getList("dataSource");
        if (this.dataSourceList == null) {
            this.logger.log(Level.SEVERE, "dataSource parameter(s) missing from config file");
            System.exit(-1);
        }
        this.sqlDataSourceHandler = new SQLDataSourceHandler(this.driver, this.url, this.prefix);
        this.sqlDataSourceMap = new HashMap();
        this.dataSourceChannelMap = new HashMap();
        this.dataSourceColumnMap = new HashMap();
        this.dataSourceRIDMap = new HashMap();
        for (i = 0; i < this.dataSourceList.size(); ++i) {
            this.dataSource = (String)this.dataSourceList.get(i);
            this.logger.log(Level.INFO, "[DataSource] " + this.dataSource);
            this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(this.dataSource);
            if (this.sqlDataSourceDescriptor == null) {
                this.logger.log(Level.SEVERE, this.dataSource + " not in vdxSources.config - Skipping");
                continue;
            }
            this.sqlDataSource = this.sqlDataSourceDescriptor.getSQLDataSource();
            this.sqlDataSourceMap.put(this.dataSource, this.sqlDataSource);
            this.dataSourceParams = this.params.getSubConfig(this.dataSource);
            if (this.sqlDataSource.getRanksFlag()) {
                Rank tempRank = this.sqlDataSource.defaultGetRank(this.rank);
                if (tempRank == null) {
                    tempRank = this.sqlDataSource.defaultInsertRank(this.rank);
                }
                if (tempRank == null) {
                    this.logger.log(Level.SEVERE, this.dataSource + " " + this.rank.getName() + " rank creation failed");
                    System.exit(-1);
                }
                this.dataSourceRIDMap.put(this.dataSource, tempRank.getId());
            }
            if (this.sqlDataSource.getColumnsFlag()) {
                this.stringList = this.dataSourceParams.getList("column");
                if (this.stringList != null) {
                    for (int j = 0; j < this.stringList.size(); ++j) {
                        this.columnName = (String)this.stringList.get(j);
                        this.columnParams = this.dataSourceParams.getSubConfig(this.columnName);
                        this.columnIdx = Util.stringToInt(this.columnParams.getString("idx"), i);
                        this.columnDescription = Util.stringToString(this.columnParams.getString("description"), this.columnName);
                        this.columnUnit = Util.stringToString(this.columnParams.getString("unit"), this.columnName);
                        this.columnChecked = Util.stringToBoolean(this.columnParams.getString("checked"), false);
                        this.columnActive = Util.stringToBoolean(this.columnParams.getString("active"), true);
                        this.columnBypass = Util.stringToBoolean(this.columnParams.getString("bypass"), false);
                        this.columnAccumulate = Util.stringToBoolean(this.columnParams.getString("accumulate"), false);
                        this.column = new Column(this.columnIdx, this.columnName, this.columnDescription, this.columnUnit, this.columnChecked, this.columnActive, this.columnBypass, this.columnAccumulate);
                        if (this.sqlDataSource.defaultGetColumn(this.columnName) != null) continue;
                        this.sqlDataSource.defaultInsertColumn(this.column);
                    }
                }
                this.columns = "";
                this.columnList = this.sqlDataSource.defaultGetColumns(true, false);
                for (int j = 0; j < this.columnList.size(); ++j) {
                    this.columns = this.columns + ((Column)this.columnList.get((int)j)).name + ",";
                }
                this.columns = this.columns.substring(0, this.columns.length() - 1);
                this.columns = Util.stringToString(this.dataSourceParams.getString("columns"), this.columns);
                this.dataSourceColumnMap.put(this.dataSource, this.columns);
                this.logger.log(Level.INFO, "[Columns] " + this.columns);
            }
            if (this.sqlDataSource.getTranslationsFlag()) {
                this.sqlDataSource.defaultCreateTranslation();
            }
            this.channels = Util.stringToString(this.dataSourceParams.getString("channels"), "");
            this.dataSourceChannelMap.put(this.dataSource, this.channels);
            this.logger.log(Level.INFO, "[Channels]" + this.channels);
            if (!this.sqlDataSource.getChannelsFlag() || this.channels.length() <= 0) continue;
            this.channelArray = this.channels.split(",");
            for (int j = 0; j < this.channelArray.length; ++j) {
                this.channelCode = this.channelArray[j];
                this.channel = (Channel)this.channelMap.get(this.channelCode);
                this.channelParams = this.params.getSubConfig(this.channelCode);
                if (this.channel == null) continue;
                if (this.sqlDataSource.defaultGetChannel(this.channel.getCode(), this.sqlDataSource.getChannelTypesFlag()) == null) {
                    if (this.sqlDataSource.getType().equals("tilt")) {
                        this.azimuthNom = Util.stringToDouble(this.channelParams.getString("azimuth"), 0.0);
                        this.sqlDataSource.defaultCreateTiltChannel(this.channel, 1, this.azimuthNom, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    } else {
                        this.sqlDataSource.defaultCreateChannel(this.channel, 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    }
                    this.channel = this.sqlDataSource.defaultGetChannel(this.channel.getCode(), this.sqlDataSource.getChannelTypesFlag());
                    this.channelMap.put(this.channelCode, this.channel);
                }
                if (!this.sqlDataSource.getTranslationsFlag()) continue;
                int tid = 1;
                int extraColumn = 0;
                this.translationParams = this.channelParams.getSubConfig("translation");
                if (this.sqlDataSource.getType().equals("tilt")) {
                    extraColumn = 1;
                }
                DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, this.columnList.size() * 2 + extraColumn);
                String[] columnNames = new String[this.columnList.size() * 2 + extraColumn];
                if (this.sqlDataSource.getType().equals("tilt")) {
                    this.azimuthInst = Util.stringToDouble(this.translationParams.getString("azimuth"), 0.0);
                    dm.setQuick(0, this.columnList.size() * 2, this.azimuthInst);
                    columnNames[this.columnList.size() * 2] = "azimuth";
                }
                for (int k = 0; k < this.columnList.size(); ++k) {
                    this.column = (Column)this.columnList.get(k);
                    this.columnName = this.column.name;
                    double multiplier = Util.stringToDouble(this.translationParams.getString("c" + this.columnName), 1.0);
                    double offset = Util.stringToDouble(this.translationParams.getString("d" + this.columnName), 0.0);
                    dm.setQuick(0, k * 2, multiplier);
                    dm.setQuick(0, k * 2 + 1, offset);
                    columnNames[k * 2] = "c" + this.columnName;
                    columnNames[k * 2 + 1] = "d" + this.columnName;
                }
                GenericDataMatrix gdm = new GenericDataMatrix(dm);
                gdm.setColumnNames(columnNames);
                tid = this.sqlDataSource.defaultGetTranslation(this.channel.getCode(), gdm);
                if (tid == 1) {
                    tid = this.sqlDataSource.defaultInsertTranslation(this.channel.getCode(), gdm);
                }
                if (tid == this.sqlDataSource.defaultGetChannelTranslationID(this.channel.getCode())) continue;
                this.sqlDataSource.defaultUpdateChannelTranslationID(this.channel.getCode(), tid);
            }
        }
    }

    @Override
    public void process(String filename) {
        try {
            int i;
            HashMap<Integer, ColumnValue> columnValueMap = new HashMap<Integer, ColumnValue>();
            boolean channelCodeFromFilename = false;
            ResourceReader rr = ResourceReader.getResourceReader(filename);
            if (rr == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is invalid)");
                return;
            }
            String shortFilename = filename.substring(filename.lastIndexOf("/") + 1);
            String line = rr.nextLine();
            int lineNumber = 0;
            if (line == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is empty)");
                return;
            }
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "importing: " + filename);
            this.channelCode = "";
            this.fieldMap = this.defaultFieldMap;
            if (this.filemask.length() > 0) {
                if (this.filemask.length() > shortFilename.length()) {
                    this.logger.log(Level.SEVERE, "skipping: " + filename + " (bad filename mask)");
                    return;
                }
                for (i = 0; i < this.filemask.length(); ++i) {
                    if (!String.valueOf(this.filemask.charAt(i)).equals("C")) continue;
                    this.channelCode = this.channelCode + String.valueOf(shortFilename.charAt(i));
                }
                if (this.channelCode.length() == 0) {
                    this.logger.log(Level.SEVERE, "skipping: " + filename + " (filename does not contain channel code)");
                    return;
                }
                channelCodeFromFilename = true;
                this.channelFields = (String)this.channelFieldMap.get(this.channelCode);
                if (this.channelFields != null) {
                    this.fieldArray = this.channelFields.split(",");
                    this.fieldMap = new HashMap();
                    for (i = 0; i < this.fieldArray.length; ++i) {
                        this.fieldMap.put(i, this.fieldArray[i].trim());
                    }
                }
            }
            if (this.headerlines > 0) {
                this.logger.log(Level.INFO, "skipping " + this.headerlines + " header lines");
                for (i = 0; i < this.headerlines; ++i) {
                    line = rr.nextLine();
                    ++lineNumber;
                }
            }
            while (line != null) {
                ColumnValue columnValue;
                double value;
                String name;
                int i2;
                ++lineNumber;
                Pattern p = Pattern.compile(this.delimiter);
                String[] valueArray = p.split(line, -1);
                HashMap<Integer, String> valueMap = new HashMap<Integer, String>();
                for (i2 = 0; i2 < valueArray.length; ++i2) {
                    valueMap.put(i2, valueArray[i2].replaceAll("['\"]", "").trim());
                }
                if (this.fieldMap.size() > valueMap.size()) {
                    this.logger.log(Level.SEVERE, "line " + lineNumber + " has too few values");
                    line = rr.nextLine();
                    continue;
                }
                if (!channelCodeFromFilename) {
                    this.channelCode = "";
                    for (i2 = 0; i2 < this.fieldMap.size(); ++i2) {
                        name = (String)this.fieldMap.get(i2);
                        if (!name.equals("CHANNEL")) continue;
                        this.channelCode = (String)valueMap.get(i2);
                        break;
                    }
                    if (this.channelCode.length() == 0) {
                        this.logger.log(Level.SEVERE, "line " + lineNumber + " does not contain a channel code");
                        line = rr.nextLine();
                        continue;
                    }
                    this.channelFields = (String)this.channelFieldMap.get(this.channelCode);
                    if (this.channelFields != null) {
                        this.fieldArray = this.channelFields.split(",");
                        this.fieldMap = new HashMap();
                        for (i2 = 0; i2 < this.fieldArray.length; ++i2) {
                            this.fieldMap.put(i2, this.fieldArray[i2].trim());
                        }
                    } else {
                        this.fieldMap = this.defaultFieldMap;
                    }
                }
                int count = 0;
                String tsValue = "";
                try {
                    for (i2 = 0; i2 < this.fieldMap.size(); ++i2) {
                        name = (String)this.fieldMap.get(i2);
                        if (name.equals("IGNORE")) continue;
                        if (name.equals("CHANNEL")) {
                            this.channelCode = (String)valueMap.get(i2);
                            continue;
                        }
                        if (name.equals("TIMESTAMP")) {
                            tsValue = tsValue + (String)valueMap.get(i2) + " ";
                            continue;
                        }
                        value = ((String)valueMap.get(i2)).length() == 0 || ((String)valueMap.get(i2)).toUpperCase() == "NAN" ? Double.NaN : Double.parseDouble((String)valueMap.get(i2));
                        columnValue = new ColumnValue(name, value);
                        columnValueMap.put(count, columnValue);
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "line " + lineNumber + " parse error");
                    this.logger.log(Level.SEVERE, e.getMessage());
                    line = rr.nextLine();
                    continue;
                }
                if (this.channelCode.length() == 0) {
                    this.logger.log(Level.SEVERE, "line " + lineNumber + " channel code not found");
                    line = rr.nextLine();
                    continue;
                }
                this.channelCode = this.channelCode.replace('\\', '$').replace('/', '$').replace('.', '$').replace(' ', '$');
                if (tsValue.length() == 0) {
                    this.logger.log(Level.SEVERE, "line " + lineNumber + " timestamp not found");
                    line = rr.nextLine();
                    continue;
                }
                try {
                    String timestamp = tsValue.trim();
                    this.date = this.dateIn.parse(timestamp);
                    this.j2ksec = Util.dateToJ2K(this.date);
                }
                catch (ParseException e) {
                    this.logger.log(Level.SEVERE, "line " + lineNumber + " timestamp parse error");
                    line = rr.nextLine();
                    continue;
                }
                ColumnValue tsColumn = new ColumnValue("j2ksec", this.j2ksec);
                for (int i3 = 0; i3 < this.dataSourceList.size(); ++i3) {
                    this.dataSource = (String)this.dataSourceList.get(i3);
                    this.channels = (String)this.dataSourceChannelMap.get(this.dataSource);
                    boolean channelMemberOfDataSource = false;
                    if (this.channels.length() > 0) {
                        this.dsChannelArray = this.channels.split(",");
                        for (int j = 0; j < this.dsChannelArray.length; ++j) {
                            if (!this.dsChannelArray[j].equals(this.channelCode)) continue;
                            channelMemberOfDataSource = true;
                        }
                        if (!channelMemberOfDataSource) continue;
                    }
                    this.sqlDataSource = (SQLDataSource)this.sqlDataSourceMap.get(this.dataSource);
                    if (this.sqlDataSource == null) {
                        this.logger.log(Level.SEVERE, "line " + lineNumber + " data source " + this.dataSource + " not initialized");
                        continue;
                    }
                    if (this.sqlDataSource.getChannelsFlag() && this.sqlDataSource.defaultGetChannel(this.channelCode, this.sqlDataSource.getChannelTypesFlag()) == null) {
                        this.sqlDataSource.defaultCreateChannel(new Channel(0, this.channelCode, this.channelCode, Double.NaN, Double.NaN, Double.NaN, 1), 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    }
                    this.columns = (String)this.dataSourceColumnMap.get(this.dataSource);
                    this.columnArray = this.columns.split(",");
                    HashMap<Integer, String> dsColumnMap = new HashMap<Integer, String>();
                    for (int j = 0; j < this.columnArray.length; ++j) {
                        dsColumnMap.put(j, this.columnArray[j]);
                    }
                    this.rid = this.sqlDataSource.getRanksFlag() ? (Integer)this.dataSourceRIDMap.get(this.dataSource) : 1;
                    HashMap<Integer, ColumnValue> dataSourceEntryMap = new HashMap<Integer, ColumnValue>();
                    count = 0;
                    dataSourceEntryMap.put(count, tsColumn);
                    ++count;
                    for (int j = 0; j < columnValueMap.size(); ++j) {
                        columnValue = (ColumnValue)columnValueMap.get(j);
                        name = columnValue.columnName;
                        value = columnValue.columnValue;
                        for (int k = 0; k < dsColumnMap.size(); ++k) {
                            if (!name.equals(dsColumnMap.get(k))) continue;
                            dataSourceEntryMap.put(count, columnValue);
                            ++count;
                        }
                    }
                    DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, dataSourceEntryMap.size());
                    String[] columnNames = new String[dataSourceEntryMap.size()];
                    for (int j = 0; j < dataSourceEntryMap.size(); ++j) {
                        columnValue = (ColumnValue)dataSourceEntryMap.get(j);
                        name = columnValue.columnName;
                        value = columnValue.columnValue;
                        columnNames[j] = name;
                        dm.setQuick(0, j, value);
                    }
                    GenericDataMatrix gdm = new GenericDataMatrix(dm);
                    gdm.setColumnNames(columnNames);
                    this.sqlDataSource.defaultInsertData(this.channelCode, gdm, this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.rid);
                }
                line = rr.nextLine();
            }
            rr.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "ImportFile.process(" + filename + ") failed.", e);
        }
    }

    @Override
    public void outputInstructions(String importerClass, String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile filelist");
    }

    public static void main(String[] as) {
        ImportFile importer = new ImportFile();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        List<String> files = args.unused();
        for (String file : files) {
            importer.process(file);
        }
        importer.deinitialize();
    }
}

