/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.vdx.ExportConfig;
import gov.usgs.vdx.data.DataSourceDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class DataSourceHandler {
    private static final String CONFIG_FILE = "vdxSources.config";
    protected Logger logger;
    protected Map<String, DataSourceDescriptor> dataSources;
    private ConfigFile config;
    private String driver;
    private String url;
    private String prefix;
    protected TreeMap<String, ExportConfig> exportConfigs;

    public DataSourceHandler(String d, String u, String p) {
        this.driver = d;
        this.url = u;
        this.prefix = p;
        this.logger = Log.getLogger("gov.usgs.vdx");
        this.dataSources = new HashMap<String, DataSourceDescriptor>();
        this.exportConfigs = new TreeMap();
        this.processConfigFile();
    }

    public void processConfigFile() {
        this.config = new ConfigFile(CONFIG_FILE);
        List<String> sources = this.config.getList("source");
        for (String source : sources) {
            ConfigFile sub = this.config.getSubConfig(source);
            String className = sub.getString("class");
            String description = sub.getString("description");
            sub.put("vdx.driver", this.driver);
            sub.put("vdx.url", this.url);
            sub.put("vdx.prefix", this.prefix);
            this.exportConfigs.put(source, new ExportConfig(source, sub));
            DataSourceDescriptor dsd = new DataSourceDescriptor(source, className, description, sub);
            this.dataSources.put(source, dsd);
            this.logger.fine("read data source: " + source);
        }
    }

    public ConfigFile getConfig() {
        return this.config;
    }

    public DataSourceDescriptor getDataSourceDescriptor(String key) {
        return this.dataSources.get(key);
    }

    public List<DataSourceDescriptor> getDataSources() {
        ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
        result.addAll(this.dataSources.values());
        return result;
    }

    public ExportConfig getExportConfig(String source) {
        return this.exportConfigs.get(source);
    }

    public void putExportConfig(String source, ExportConfig ec) {
        this.exportConfigs.put(source, ec);
    }
}

