/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm.message;

import gov.usgs.earthworm.message.Message;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TraceBuf
extends Message {
    protected static final long TO_USEC = 1000000L;
    protected static final double FROM_USEC = 1.0E-6;
    protected static final short NULL_SHORT = 32639;
    protected static final byte NULL_BYTE = 127;
    protected int pin;
    protected int numSamples;
    protected long firstSampleTime;
    protected long samplingPeriod;
    protected String station;
    protected String network;
    protected String channel;
    protected String location;
    protected String dataType;
    protected String quality;
    protected String pad;
    protected int[] data;
    protected long registrationOffset;
    protected boolean isTraceBuf2 = false;

    public TraceBuf() {
    }

    public TraceBuf(byte[] b) throws IOException {
        this.processBytes(new DataInputStream(new ByteArrayInputStream(b)), false);
    }

    protected TraceBuf(byte[] b, int i, int seq) throws IOException {
        super(b, i, seq);
    }

    public TraceBuf(String code, Wave sw) {
        this.data = sw.buffer;
        this.samplingPeriod = Math.round(1000000.0 / sw.getSamplingRate());
        this.firstSampleTime = Math.round(Util.j2KToEW(sw.getStartTime()) * 1000000.0);
        this.pin = -1;
        this.numSamples = this.data.length;
        this.dataType = "s4";
        this.quality = "";
        this.pad = "";
        String[] cc = code.split("\\$");
        this.station = cc[0];
        this.channel = cc[1];
        this.network = cc[2];
        this.location = null;
        if (cc.length >= 4) {
            this.isTraceBuf2 = true;
            this.location = cc[3];
        }
    }

    public static Message createFromBytes(byte[] b, int i, int seq) throws IOException {
        TraceBuf tb = new TraceBuf(b, i, seq);
        tb.processBytes(new DataInputStream(new ByteArrayInputStream(tb.bytes)), false);
        return tb;
    }

    public static Message createFromBytesAsTraceBuf2(byte[] b, int i, int seq) throws IOException {
        TraceBuf tb = new TraceBuf(b, i, seq);
        tb.processBytes(new DataInputStream(new ByteArrayInputStream(tb.bytes)), true);
        return tb;
    }

    public void createBytes() {
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeInt(this.pin);
            out.writeInt(this.numSamples);
            out.writeDouble(this.firstSampleTime());
            out.writeDouble(this.lastSampleTime());
            out.writeDouble(this.samplingRate());
            int p = 7 - this.station.length();
            out.writeBytes(this.station);
            for (i = 0; i < p; ++i) {
                out.write(0);
            }
            p = 9 - this.network.length();
            out.writeBytes(this.network);
            for (i = 0; i < p; ++i) {
                out.write(0);
            }
            if (this.isTraceBuf2 && this.location != null) {
                p = 4 - this.channel.length();
                out.writeBytes(this.channel);
                for (i = 0; i < p; ++i) {
                    out.write(0);
                }
                p = 5 - this.location.length();
                out.writeBytes(this.location);
                for (i = 0; i < p; ++i) {
                    out.write(0);
                }
            } else {
                p = 9 - this.channel.length();
                out.writeBytes(this.channel);
                for (i = 0; i < p; ++i) {
                    out.write(0);
                }
            }
            out.writeBytes("s4");
            for (i = 0; i < 5; ++i) {
                out.write(0);
            }
            for (i = 0; i < this.data.length; ++i) {
                out.writeInt(this.data[i]);
            }
            out.write(0);
            this.bytes = baos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int[] readData(DataInputStream in) throws IOException {
        boolean isShort;
        int[] data = new int[this.numSamples];
        boolean swap = this.dataType.charAt(0) == 'i';
        boolean bl = isShort = this.dataType.charAt(1) == '2';
        if (isShort && swap) {
            for (int i = 0; i < this.numSamples; ++i) {
                data[i] = Util.swap(in.readShort());
            }
        } else if (isShort) {
            for (int i = 0; i < this.numSamples; ++i) {
                data[i] = in.readShort();
            }
        } else if (swap) {
            for (int i = 0; i < this.numSamples; ++i) {
                data[i] = Util.swap(in.readInt());
            }
        } else {
            for (int i = 0; i < this.numSamples; ++i) {
                data[i] = in.readInt();
            }
        }
        return data;
    }

    public void processBytes(DataInputStream in, boolean isTraceBuf2) throws IOException {
        this.isTraceBuf2 = isTraceBuf2;
        this.pin = in.readInt();
        this.numSamples = in.readInt();
        double startTime = in.readDouble();
        in.readDouble();
        double samplingRate = in.readDouble();
        byte[] buf = new byte[32];
        in.read(buf, 0, 32);
        this.station = Util.bytesToString(buf, 0, 7).trim();
        this.network = Util.bytesToString(buf, 7, 9).trim();
        if (!isTraceBuf2) {
            this.channel = Util.bytesToString(buf, 16, 9).trim();
            this.location = null;
        } else {
            this.channel = Util.bytesToString(buf, 16, 4).trim();
            this.location = Util.bytesToString(buf, 20, 3).trim();
            if (this.location.equals("--")) {
                this.location = null;
            }
        }
        this.dataType = Util.bytesToString(buf, 25, 3).trim();
        this.quality = Util.bytesToString(buf, 28, 2).trim();
        if (this.dataType.charAt(0) == 'i') {
            this.pin = Util.swap(this.pin);
            this.numSamples = Util.swap(this.numSamples);
            startTime = Util.swap(startTime);
            samplingRate = Util.swap(samplingRate);
        }
        this.firstSampleTime = Math.round(startTime * 1000000.0);
        this.samplingPeriod = Math.round(1000000.0 / samplingRate);
        this.data = this.readData(in);
    }

    public void register() {
        long dif = this.firstSampleTime % this.samplingPeriod;
        this.registrationOffset = dif >= this.samplingPeriod / 2L ? this.samplingPeriod - dif : -dif;
        this.firstSampleTime += this.registrationOffset;
    }

    public static Wave traceBufToWave(List<TraceBuf> traceBufs) {
        if (traceBufs == null || traceBufs.size() <= 0) {
            return null;
        }
        TraceBuf.normalize(traceBufs);
        TraceBuf firstTraceBuf = traceBufs.get(0);
        TraceBuf lastTraceBuf = traceBufs.get(traceBufs.size() - 1);
        long samplingPeriod = firstTraceBuf.samplingPeriod;
        long lastSampleTime = lastTraceBuf.firstSampleTime + (long)(lastTraceBuf.numSamples - 1) * samplingPeriod;
        int numSamples = (int)((lastSampleTime - firstTraceBuf.firstSampleTime) / samplingPeriod + 1L);
        int[] buffer = new int[numSamples];
        Arrays.fill(buffer, Wave.NO_DATA);
        int sampleIndex = 0;
        long lastSampleTimeSeen = firstTraceBuf.firstSampleTime - samplingPeriod;
        long lastStart = 0L;
        int lastCount = 0;
        for (TraceBuf tb : traceBufs) {
            while (lastSampleTimeSeen + samplingPeriod < tb.firstSampleTime) {
                ++sampleIndex;
                lastSampleTimeSeen += tb.samplingPeriod;
            }
            if (tb.firstSampleTime <= lastSampleTimeSeen) {
                int overlap = (int)((lastSampleTimeSeen - tb.firstSampleTime) / samplingPeriod + 1L);
                System.err.println("Overlapping tracebuf found in " + tb.toWinstonString() + ". Overlap count=" + overlap);
                System.err.println(lastStart + " + (" + lastCount + " - 1) * " + samplingPeriod + " - " + tb.firstSampleTime + " = " + (lastStart + (long)(lastCount - 1) * samplingPeriod - tb.firstSampleTime));
                System.err.println("count " + tb.numSamples + " : rate " + tb.samplingRate() + " : duration " + tb.samplingPeriod * (long)tb.numSamples);
                sampleIndex -= overlap;
            }
            if (sampleIndex + tb.numSamples > buffer.length) {
                System.err.println("Too many samples in " + tb.toWinstonString() + ". Variable sampling rate no supported.");
                continue;
            }
            for (int j = 0; j < tb.numSamples; ++j) {
                buffer[sampleIndex++] = tb.data[j];
            }
            lastSampleTimeSeen = tb.firstSampleTime + (long)(tb.numSamples - 1) * samplingPeriod;
            lastStart = tb.firstSampleTime;
            lastCount = tb.numSamples;
        }
        Wave wave = new Wave(buffer, (double)firstTraceBuf.firstSampleTime * 1.0E-6, firstTraceBuf.samplingRate());
        wave.setRegistrationOffset(firstTraceBuf.registrationOffset);
        return wave;
    }

    private static void normalize(List<TraceBuf> traceBufs) {
        TraceBuf firstTraceBuf = traceBufs.get(0);
        Iterator<TraceBuf> i = traceBufs.iterator();
        while (i.hasNext()) {
            TraceBuf tb = i.next();
            tb.register();
            if (tb.samplingPeriod == firstTraceBuf.samplingPeriod) continue;
            i.remove();
        }
    }

    public double getStartTime() {
        return this.firstSampleTime();
    }

    public double getStartTimeJ2K() {
        return Util.ewToJ2K(this.getStartTime());
    }

    public double getEndTime() {
        return this.lastSampleTime() + this.samplingPeriod();
    }

    public double getEndTimeJ2K() {
        return Util.ewToJ2K(this.getEndTime());
    }

    public double firstSampleTime() {
        return (double)this.firstSampleTime * 1.0E-6;
    }

    public double lastSampleTime() {
        return (double)(this.firstSampleTime + (long)(this.numSamples - 1) * this.samplingPeriod) * 1.0E-6;
    }

    public double samplingRate() {
        return 1.0 / ((double)this.samplingPeriod * 1.0E-6);
    }

    public double samplingPeriod() {
        return (double)this.samplingPeriod * 1.0E-6;
    }

    public double numSamples() {
        return this.numSamples;
    }

    public String station() {
        return this.station;
    }

    public String channel() {
        return this.channel;
    }

    public String network() {
        return this.network;
    }

    public String location() {
        return this.location;
    }

    public String quality() {
        return this.quality;
    }

    public String pad() {
        return this.pad;
    }

    public String dataType() {
        return this.dataType;
    }

    public int[] samples() {
        return this.data;
    }

    @Override
    public String toString() {
        return String.format("TRACEBUF%s: %s %s %s %s, %d, %s, %.4f -> %.4f", this.isTraceBuf2 ? "2" : "", this.station, this.channel, this.network, this.isTraceBuf2 && this.location != null ? this.location : "--", this.numSamples, this.dataType, this.firstSampleTime(), this.lastSampleTime());
    }

    public String toWinstonString() {
        String code = this.station + "$" + this.channel + "$" + this.network;
        if (this.isTraceBuf2 && this.location != null && !this.location.equals("--")) {
            code = code + "$" + this.location;
        }
        return code;
    }

    public ByteBuffer toByteBuffer() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(64 + 4 * this.data.length);
        bb.putInt(this.pin);
        bb.putInt(this.numSamples);
        bb.putDouble(this.firstSampleTime());
        bb.putDouble(this.lastSampleTime());
        bb.putDouble(this.samplingRate());
        bb.put(this.station.getBytes());
        for (i = this.station.length(); i < 7; ++i) {
            bb.put((byte)0);
        }
        bb.put(this.network.getBytes());
        for (i = this.network.length(); i < 9; ++i) {
            bb.put((byte)0);
        }
        bb.put(this.channel.getBytes());
        for (i = this.channel.length(); i < 9; ++i) {
            bb.put((byte)0);
        }
        bb.put(this.dataType.getBytes());
        for (i = this.dataType.length(); i < 3; ++i) {
            bb.put((byte)0);
        }
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        for (i = 0; i < this.data.length; ++i) {
            bb.putInt(this.data[i]);
        }
        bb.flip();
        return bb;
    }
}

