/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class EarthwormEscapeOutputStream
extends FilterOutputStream {
    DecimalFormat numberFormat = new DecimalFormat("000");

    public EarthwormEscapeOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 2 || b == 27 || b == 3) {
            super.write(27);
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        for (int i = offset; i < len && i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    public void startTransmit() throws IOException {
        super.write(2);
    }

    public void endTransmit() throws IOException {
        super.write(3);
    }

    public void writeThreeChars(int val) throws IOException {
        String s = this.numberFormat.format(val);
        this.write(s.charAt(0));
        this.write(s.charAt(1));
        this.write(s.charAt(2));
    }
}

