/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.chooser;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.chooser.DataSourcePanel;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class WWSPanel
extends DataSourcePanel {
    private JTextField wwsHost;
    private JTextField wwsPort;
    private JTextField wwsTimeout;
    private JCheckBox wwsCompress;

    public WWSPanel() {
        super("wws", "Winston Wave Server");
    }

    private void createFields() {
        this.wwsHost = new JTextField();
        this.wwsPort = new JTextField();
        this.wwsTimeout = new JTextField();
        this.wwsCompress = new JCheckBox();
        String h = "";
        String p = "16022";
        String t = "15.0";
        boolean wscomp = true;
        if (this.source != null && this.source.indexOf(";wws:") != -1) {
            String[] ss = this.source.substring(this.source.indexOf(";wws:") + 5).split(":");
            h = ss[0];
            p = ss[1];
            t = String.format("%.1f", (double)Integer.parseInt(ss[2]) / 1000.0);
            wscomp = ss[3].equals("1");
        }
        this.wwsHost.setText(h);
        this.wwsPort.setText(p);
        this.wwsTimeout.setText(t);
        this.wwsCompress.setSelected(wscomp);
    }

    @Override
    protected void createPanel() {
        this.createFields();
        FormLayout layout = new FormLayout("right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 126dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Use this data source to connect to a Winston Wave Server (WWS)."), 5);
        builder.nextLine();
        builder.appendSeparator();
        builder.append("IP Address or Host Name:");
        builder.append((Component)this.wwsHost, 3);
        builder.nextLine();
        builder.append("Port:");
        builder.append((Component)this.wwsPort);
        builder.append(" Winston default: 16022");
        builder.nextLine();
        builder.append("Timeout:");
        builder.append((Component)this.wwsTimeout);
        builder.append(" seconds");
        builder.nextLine();
        builder.append("Use Compression:");
        builder.append((Component)this.wwsCompress);
        builder.nextLine();
        this.panel = builder.getPanel();
    }

    @Override
    public boolean allowOK(boolean edit) {
        String host = this.wwsHost.getText();
        String message = null;
        if (host == null || host.length() == 0 || host.indexOf(59) != -1 || host.indexOf(58) != -1) {
            message = "There is an error with the WWS IP address or host name.";
        }
        int ip = -1;
        try {
            ip = Integer.parseInt(this.wwsPort.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ip < 0 || ip > 65535) {
            message = "There is an error with the WWS port.";
        }
        double to = -1.0;
        try {
            to = Double.parseDouble(this.wwsTimeout.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (to <= 0.0) {
            message = "There is an error with the WWS time out (must be > 0).";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(applicationFrame, message, "Error", 0);
            return false;
        }
        return true;
    }

    @Override
    public String wasOK() {
        int timeout = (int)(Double.parseDouble(this.wwsTimeout.getText()) * 1000.0);
        String result = String.format("wws:%s:%s:%d:%s", this.wwsHost.getText(), this.wwsPort.getText(), timeout, this.wwsCompress.isSelected() ? "1" : "0");
        return result;
    }
}

