/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigFile
implements Cloneable {
    private Map<String, List<String>> config;
    private String name;
    private boolean successfullyRead = false;

    public ConfigFile() {
        this.config = new HashMap<String, List<String>>();
    }

    public ConfigFile(Map<String, List<String>> map) {
        this.config = map;
    }

    public ConfigFile(String fn) {
        this.setName(fn);
        this.config = new HashMap<String, List<String>>();
        this.readConfigFile(fn);
    }

    public boolean wasSuccessfullyRead() {
        return this.successfullyRead;
    }

    public void readConfigFile(String fn) {
        this.readConfigFile(fn, true);
    }

    public void readConfigFile(String fn, boolean l) {
        this.readConfigFile(new File(fn), l);
    }

    public void readConfigFile(File f) {
        this.readConfigFile(f, true);
    }

    public void readConfigFile(File f, boolean l) {
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(f));
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() != 0 && !s.startsWith("#") && !s.startsWith("@")) {
                    String key = s.substring(0, s.indexOf(61)).trim();
                    String val = s.substring(s.indexOf(61) + 1).trim();
                    if (val.toLowerCase().equals("@begin-multiline")) {
                        StringBuffer sb = new StringBuffer(2048);
                        boolean done = false;
                        while (!done) {
                            String is = in.readLine();
                            if (is.toLowerCase().equals("@end-multiline")) {
                                done = true;
                                continue;
                            }
                            sb.append(is);
                            sb.append('\n');
                        }
                        val = sb.toString();
                    }
                    if (!l) {
                        this.remove(key);
                    }
                    List<String> ss = this.getOrCreateList(key);
                    ss.add(val);
                }
                if (!s.toLowerCase().startsWith("@include ")) continue;
                String ifn = s.substring(s.indexOf(" ") + 1);
                ifn = f.getAbsoluteFile().getParent() + File.separator + ifn;
                this.readConfigFile(ifn);
            }
            in.close();
            this.successfullyRead = true;
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getList(String key) {
        return this.config.get(key);
    }

    private List<String> getOrCreateList(String key) {
        List<String> ss = this.config.get(key);
        if (ss == null) {
            ss = new ArrayList<String>();
            this.config.put(key, ss);
        }
        return ss;
    }

    public void putList(String key, List<String> list) {
        this.config.put(key, list);
    }

    public void put(String key, String val) {
        this.getOrCreateList(key).add(val);
    }

    public void put(String key, String val, boolean l) {
        if (!l) {
            this.remove(key);
        }
        this.put(key, val);
    }

    public void putConfig(ConfigFile cf, boolean preserve) {
        Map<String, List<String>> configIn = cf.getConfig();
        for (String key : configIn.keySet()) {
            if (!preserve) {
                this.remove(key);
            }
            this.putList(key, configIn.get(key));
        }
    }

    public void remove(String key) {
        this.config.remove(key);
    }

    public void remove(String key, String val) {
        List<String> ss = this.config.get(key);
        if (ss == null) {
            return;
        }
        ss.remove(val);
        if (ss.size() == 0) {
            this.config.remove(key);
        }
    }

    public String getString(String key) {
        List<String> ss = this.config.get(key);
        if (ss == null || ss.size() == 0) {
            return null;
        }
        return ss.get(0);
    }

    public String getString(String key, String defaultValue) {
        String s = this.getString(key);
        if (s == null) {
            this.put(key, defaultValue);
            s = defaultValue;
        }
        return s;
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value == null) {
            throw new RuntimeException("Illegal " + key + ":null");
        }
        if (!value.toLowerCase().equals("true") && value.toLowerCase().equals("t") && !value.toLowerCase().equals("false") && value.toLowerCase().equals("f") && !value.equals("1") && !value.equals("0")) {
            throw new RuntimeException("Illegal " + key + ":" + value);
        }
        boolean pv = Util.stringToBoolean(value);
        return pv;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean b;
        try {
            b = this.getBoolean(key);
        }
        catch (RuntimeException e) {
            this.put(key, String.valueOf(defaultValue));
            b = defaultValue;
        }
        return b;
    }

    public double getDouble(String key) {
        String value = this.getString(key);
        if (value == null) {
            throw new RuntimeException("Illegal " + key + ":null");
        }
        double d = Double.parseDouble(value);
        return d;
    }

    public double getDouble(String key, double defaultValue) {
        double d;
        try {
            d = this.getDouble(key);
        }
        catch (Exception e) {
            this.put(key, String.valueOf(defaultValue));
            d = defaultValue;
        }
        return d;
    }

    public int getInt(String key) {
        String value = this.getString(key);
        if (value == null) {
            throw new RuntimeException("Illegal " + key + ":null");
        }
        int i = Integer.parseInt(value);
        return i;
    }

    public int getInt(String key, int defaultValue) {
        int i;
        try {
            i = this.getInt(key);
        }
        catch (Exception e) {
            this.put(key, String.valueOf(defaultValue));
            i = defaultValue;
        }
        return i;
    }

    public ConfigFile getSubConfig(String prefix) {
        return this.getSubConfig(prefix, false);
    }

    public ConfigFile getSubConfig(String prefix, boolean inherit) {
        ConfigFile result = inherit ? this.clone() : new ConfigFile();
        result.successfullyRead = true;
        result.name = prefix;
        for (String key : this.config.keySet()) {
            if (!key.startsWith(prefix) || key.length() <= prefix.length()) continue;
            String newKey = key.substring(prefix.length() + 1);
            result.getConfig().put(newKey, this.config.get(key));
        }
        return result;
    }

    public Map<String, List<String>> getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n.endsWith(".config") ? n.substring(0, n.indexOf(".config")) : n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.config.keySet()) {
            List<String> list = this.config.get(key);
            if (list.size() == 1) {
                sb.append(key + "=" + list.get(0) + "\n");
                continue;
            }
            sb.append(key + "=[list]\n");
            for (String s : list) {
                sb.append("\t" + s + "\n");
            }
        }
        return sb.toString();
    }

    public void writeToFile(String fn) {
        this.setName(fn);
        Set<String> keySet = this.config.keySet();
        Iterator<String> it = keySet.iterator();
        ArrayList<String> v = new ArrayList<String>();
        while (it.hasNext()) {
            v.add(it.next());
        }
        Object[] keys = new String[v.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)v.get(i);
        }
        Arrays.sort(keys);
        try {
            File f = new File(fn);
            File bak = new File(fn + ".bak");
            if (bak.exists()) {
                bak.delete();
            }
            if (f.exists()) {
                f.renameTo(bak);
            }
            PrintWriter out = new PrintWriter(new FileWriter(fn));
            for (int i = 0; i < keys.length; ++i) {
                Object k = keys[i];
                List<String> o = this.config.get(k);
                if (o instanceof String) {
                    out.println((String)k + "=" + o);
                } else if (o instanceof List) {
                    List<String> vals = o;
                    Iterator<String> it2 = vals.iterator();
                    while (it2.hasNext()) {
                        out.println((String)k + "=" + it2.next());
                    }
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String findConfig(List<String> fileNames) {
        String fileName = null;
        Iterator<String> nameIter = fileNames.iterator();
        while (fileName == null && nameIter.hasNext()) {
            String name = nameIter.next();
            if (!new File(name).canRead()) continue;
            fileName = name;
        }
        return fileName;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            ConfigFile cf = new ConfigFile(args[i]);
            System.out.println(cf);
        }
    }

    public ConfigFile clone() {
        ConfigFile cf = new ConfigFile();
        for (String key : this.config.keySet()) {
            cf.putList(key, this.config.get(key));
        }
        return cf;
    }
}

