/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.heli;

import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.heli.HelicorderViewPanel;
import gov.usgs.util.ConfigFile;

public class HelicorderViewerSettings {
    public String channel;
    public int timeChunk;
    public int span;
    public int waveZoomOffset;
    private double bottomTime;
    public int refreshInterval;
    public int scrollSize;
    public boolean forceCenter;
    public int clipBars;
    private long lastBottomTimeSet;
    public boolean autoScale;
    public boolean showClip;
    public boolean alertClip;
    public int alertClipTimeout;
    public int clipValue;
    public int barRange;
    public double barMult;
    public HelicorderViewPanel view;
    private static SwarmConfig swarmConfig;

    public HelicorderViewerSettings(String ch) {
        swarmConfig = SwarmConfig.getInstance();
        this.channel = ch;
        this.timeChunk = HelicorderViewerSettings.swarmConfig.timeChunk * 60;
        this.span = HelicorderViewerSettings.swarmConfig.span * 60;
        this.waveZoomOffset = 30;
        this.bottomTime = Double.NaN;
        this.refreshInterval = 15;
        this.scrollSize = 24;
        this.forceCenter = false;
        this.clipBars = 21;
        this.clipValue = 2999;
        this.showClip = HelicorderViewerSettings.swarmConfig.showClip;
        this.alertClip = HelicorderViewerSettings.swarmConfig.alertClip;
        this.alertClipTimeout = HelicorderViewerSettings.swarmConfig.alertClipTimeout * 60;
        this.barRange = 1500;
        this.barMult = 3.0;
        this.autoScale = true;
    }

    public long getLastBottomTimeSet() {
        return System.currentTimeMillis() - this.lastBottomTimeSet;
    }

    public void setBottomTime(double bt) {
        this.lastBottomTimeSet = System.currentTimeMillis();
        this.bottomTime = bt;
    }

    public double getBottomTime() {
        return this.bottomTime;
    }

    public void set(ConfigFile cf) {
        this.timeChunk = Integer.parseInt(cf.getString("timeChunk"));
        this.span = Integer.parseInt(cf.getString("span"));
        this.waveZoomOffset = Integer.parseInt(cf.getString("waveZoomOffset"));
        this.refreshInterval = Integer.parseInt(cf.getString("refreshInterval"));
        this.scrollSize = Integer.parseInt(cf.getString("scrollSize"));
        this.clipValue = Integer.parseInt(cf.getString("clipValue"));
        this.clipBars = Integer.parseInt(cf.getString("clipBars"));
        this.barRange = Integer.parseInt(cf.getString("barRange"));
        this.alertClipTimeout = Integer.parseInt(cf.getString("alertClipTimeout"));
        this.setBottomTime(Double.parseDouble(cf.getString("bottomTime")));
        this.barMult = Double.parseDouble(cf.getString("barMult"));
        this.forceCenter = Boolean.parseBoolean(cf.getString("forceCenter"));
        this.autoScale = Boolean.parseBoolean(cf.getString("autoScale"));
        this.showClip = Boolean.parseBoolean(cf.getString("showClip"));
        this.alertClip = Boolean.parseBoolean(cf.getString("alertClip"));
    }

    public void save(ConfigFile cf, String prefix) {
        cf.put(prefix + ".channel", this.channel);
        cf.put(prefix + ".timeChunk", Integer.toString(this.timeChunk));
        cf.put(prefix + ".span", Integer.toString(this.span));
        cf.put(prefix + ".waveZoomOffset", Integer.toString(this.waveZoomOffset));
        cf.put(prefix + ".refreshInterval", Integer.toString(this.refreshInterval));
        cf.put(prefix + ".scrollSize", Integer.toString(this.scrollSize));
        cf.put(prefix + ".clipValue", Integer.toString(this.clipValue));
        cf.put(prefix + ".clipBars", Integer.toString(this.clipBars));
        cf.put(prefix + ".barRange", Integer.toString(this.barRange));
        cf.put(prefix + ".alertClipTimeout", Integer.toString(this.alertClipTimeout));
        cf.put(prefix + ".bottomTime", Double.toString(this.bottomTime));
        cf.put(prefix + ".barMult", Double.toString(this.barMult));
        cf.put(prefix + ".forceCenter", Boolean.toString(this.forceCenter));
        cf.put(prefix + ".autoScale", Boolean.toString(this.autoScale));
        cf.put(prefix + ".showClip", Boolean.toString(this.showClip));
        cf.put(prefix + ".alertClip", Boolean.toString(this.alertClip));
    }

    public void parseSettingsString(String o) {
        String[] opts = o.split(",");
        for (int i = 0; i < opts.length; ++i) {
            try {
                String key = opts[i].substring(0, opts[i].indexOf(61));
                String value = opts[i].substring(opts[i].indexOf(61) + 1);
                if (key.equals("x")) {
                    this.timeChunk = Integer.parseInt(value) * 60;
                    continue;
                }
                if (!key.equals("y")) continue;
                this.span = Integer.parseInt(value) * 60;
                continue;
            }
            catch (Exception e) {
                System.err.println("Could not parse setting: " + opts[i]);
            }
        }
    }

    public void notifyView() {
        if (this.view != null) {
            this.view.settingsChanged();
        }
    }
}

