/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.vdx.data.Exportable;

public class ExportData
implements Comparable {
    protected int nextRowGenIndex = 0;
    protected int rowGenID = -1;
    protected Double[] currRawRowData = null;
    protected Double[] dummy = null;
    protected Exportable src;

    public ExportData(int id, Exportable src) {
        this.rowGenID = id;
        this.src = src;
        this.nextExportDatum();
        this.dummy = new Double[this.currRawRowData.length];
    }

    public Double[] nextExportDatum() {
        this.currRawRowData = this.src.getNextExportRow();
        return this.currRawRowData;
    }

    public Double[] currExportDatum() {
        return this.currRawRowData;
    }

    public int exportDataID() {
        return this.rowGenID;
    }

    public Double[] dummyExportDatum() {
        return this.dummy;
    }

    public int compareTo(Object obj) {
        ExportData eo = (ExportData)obj;
        if (this.currRawRowData == null) {
            if (eo == null) {
                return 0;
            }
            return 1;
        }
        if (eo == null) {
            return -1;
        }
        Double[] eo_ced = eo.currExportDatum();
        if (this.currRawRowData[0] == null) {
            if (eo_ced[0] == null) {
                return 0;
            }
            return 0;
        }
        if (eo_ced == null) {
            return -1;
        }
        int cmp = this.currRawRowData[0].compareTo(eo_ced[0]);
        if (cmp != 0) {
            return cmp;
        }
        return this.rowGenID - eo.exportDataID();
    }

    public int count() {
        return this.src.length();
    }
}

