/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.client;

import gov.usgs.net.InternetClient;
import gov.usgs.plot.data.BinaryDataSet;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VDXClient
extends InternetClient {
    private static final int MAX_RETRIES = 3;
    protected static Map<String, String> dataTypeMap = new HashMap<String, String>();

    public VDXClient(String h, int p) {
        super(h, p);
        this.setTimeout(30000);
    }

    public static void addDataType(String t, String c) {
        dataTypeMap.put(t, c);
    }

    protected String submitCommand(Map<String, String> params) throws IOException {
        if (!this.connected()) {
            this.connect();
        }
        String cmd = "getdata: " + Util.mapToString(params) + "\n";
        this.writeString(cmd);
        String rs = this.readString();
        if (rs == null || rs.length() <= 0 || rs.indexOf(58) == -1) {
            return null;
        }
        return rs;
    }

    public BinaryDataSet getBinaryData(final Map<String, String> params) throws UtilException {
        Retriable<BinaryDataSet> rt = new Retriable<BinaryDataSet>("VDXClient.getBinaryData()", 3){

            @Override
            public void attemptFix() {
                VDXClient.this.close();
                VDXClient.this.connect();
            }

            @Override
            public boolean attempt() throws UtilException {
                String rs = null;
                try {
                    rs = VDXClient.this.submitCommand(params);
                }
                catch (Exception e) {
                    logger.warning("VDXClient.submitCommand() exception: " + e.getMessage());
                    return false;
                }
                String rc = rs.substring(0, rs.indexOf(58));
                String r = rs.substring(rs.indexOf(58) + 1);
                this.result = null;
                if (rc.equals("ok")) {
                    logger.info("rc is ok: " + r);
                    Map<String, String> map = Util.stringToMap(r);
                    if (map.get("bytes") != null) {
                        try {
                            int bytes = Integer.parseInt(map.get("bytes"));
                            byte[] buffer = VDXClient.this.readBinary(bytes);
                            byte[] decompBuf = Util.decompress(buffer);
                            ByteBuffer bb = ByteBuffer.wrap(decompBuf);
                            String className = dataTypeMap.get(map.get("type"));
                            BinaryDataSet ds = (BinaryDataSet)Class.forName(className).newInstance();
                            ds.fromBinary(bb);
                            this.result = ds;
                        }
                        catch (Exception e) {
                            logger.warning("VDXClient: binary dataset unpacking exception: " + e.getMessage());
                            return false;
                        }
                    } else {
                        logger.warning("error, expected binary");
                    }
                    return true;
                }
                if (rc.equals("error")) {
                    throw new UtilException(r);
                }
                return false;
            }
        };
        return (BinaryDataSet)rt.go();
    }

    public List<String> getTextData(final Map<String, String> params) throws UtilException {
        Retriable<List<String>> rt = new Retriable<List<String>>("VDXClient.getTextData()", 3){

            @Override
            public void attemptFix() {
                VDXClient.this.close();
                VDXClient.this.connect();
            }

            @Override
            public boolean attempt() throws UtilException {
                logger.info("VDXClient.getData(): params = " + params);
                String rs = null;
                try {
                    rs = VDXClient.this.submitCommand(params);
                }
                catch (Exception e) {
                    logger.warning("VDXClient.getData() exception: " + e.getMessage());
                    return false;
                }
                String rc = rs.substring(0, rs.indexOf(58));
                String r = rs.substring(rs.indexOf(58) + 1);
                this.result = null;
                logger.info("VDXClient.getData(): r = " + r);
                if (rc.equals("ok")) {
                    Map<String, String> map = Util.stringToMap(r);
                    if (map.get("lines") != null) {
                        try {
                            int lines = Integer.parseInt(map.get("lines"));
                            ArrayList<String> list = new ArrayList<String>();
                            for (int i = 0; i < lines; ++i) {
                                list.add(VDXClient.this.readString());
                            }
                            this.result = list;
                        }
                        catch (Exception e) {
                            logger.warning("VDXClient: text dataset unpacking exception: " + e.getMessage());
                            return false;
                        }
                    } else {
                        logger.warning("VDXClient.getData(): error, expected text");
                    }
                    return true;
                }
                if (rc.equals("error")) {
                    throw new UtilException(r);
                }
                return false;
            }
        };
        return (List)rt.go();
    }

    public static void main(String[] args) {
    }

    static {
        dataTypeMap.put("genericfixed", "gov.usgs.plot.data.GenericDataMatrix");
        dataTypeMap.put("genericvariable", "gov.usgs.plot.data.GenericDataMatrix");
        dataTypeMap.put("gps", "gov.usgs.vdx.data.gps.GPSData");
        dataTypeMap.put("helicorder", "gov.usgs.plot.data.HelicorderData");
        dataTypeMap.put("hypocenters", "gov.usgs.vdx.data.hypo.HypocenterList");
        dataTypeMap.put("rsam", "gov.usgs.plot.data.RSAMData");
        dataTypeMap.put("ewrsam", "gov.usgs.vdx.data.rsam.EWRSAMData");
        dataTypeMap.put("tilt", "gov.usgs.vdx.data.tilt.TiltData");
        dataTypeMap.put("tensorstrain", "gov.usgs.vdx.data.tensorstrain.TensorstrainData");
        dataTypeMap.put("wave", "gov.usgs.plot.data.Wave");
    }
}

