/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ExportConfig {
    private int exportable;
    private int numCommentLines;
    private TreeMap<Integer, String> commentLine;
    private int[] width;
    private boolean closed = false;
    protected Logger logger = Log.getLogger("gov.usgs.util.ExportConfig");
    private String source;

    public ExportConfig(String source, ConfigFile config) {
        List<String> comments;
        this.source = source;
        String str = config.getString("exportEnabled");
        this.exportable = str != null && (str.equals("true") || str.equals("false")) ? (str.equals("true") ? 1 : 0) : -1;
        this.numCommentLines = -1;
        str = config.getString("exportCommentLines");
        this.commentLine = new TreeMap();
        if (str != null) {
            try {
                int numLines = Integer.parseInt(str);
                if (numLines < 1) {
                    throw new Exception("exportCommentLines out of range: " + numLines);
                }
                this.numCommentLines = numLines;
            }
            catch (Exception e) {
                this.logger.warning("Error parsing " + source + "exportCommentLines: " + str);
            }
        }
        if ((comments = config.getList("exportCommentLine")) != null) {
            for (String commName : comments) {
                ConfigFile sub = config.getSubConfig(commName);
                String index = sub.getString("index");
                String text = sub.getString("value");
                try {
                    int i = Integer.parseInt(index);
                    if (this.numCommentLines != -1 && (i < 1 || i > this.numCommentLines)) {
                        throw new Exception("Index out of range (1.." + this.numCommentLines + "):" + index);
                    }
                    if (text == null) {
                        this.commentLine.put(i, "");
                        continue;
                    }
                    this.commentLine.put(i, text);
                }
                catch (Exception e) {
                    this.logger.warning("Error parsing index: " + e);
                }
            }
        }
        this.width = null;
        str = config.getString("exportDataWidth");
        if (str != null) {
            try {
                int i;
                String[] width_str = str.split("[.]");
                if (width_str.length != 2) {
                    throw new Exception("requires 2 values (not " + width_str.length + "): '" + str + "'");
                }
                this.width = new int[2];
                String edwName = "first";
                for (i = 0; i < 2; ++i) {
                    this.width[i] = Integer.parseInt(width_str[i]);
                    if (this.width[i] >= 0 && this.width[i] <= 23) continue;
                    this.width = null;
                    throw new Exception(edwName + " export data width value (" + this.width[i] + ") > 23; ignored");
                }
                i = this.width[0] + this.width[1];
                if (i > 23) {
                    this.width = null;
                    throw new Exception(edwName + " export data width sum (" + i + ") > 23; ignored");
                }
            }
            catch (Exception e) {
                this.logger.warning("Error parsing exportDataWidth; ignoring: " + e);
            }
        }
    }

    public ExportConfig(List<String> src_text) {
        Iterator<String> it = src_text.iterator();
        this.exportable = Integer.parseInt(it.next());
        int[] fw = new int[]{Integer.parseInt(it.next()), Integer.parseInt(it.next())};
        if (fw[0] != -1 && fw[1] != -1) {
            this.width = fw;
        }
        this.numCommentLines = src_text.size() - 3;
        this.commentLine = new TreeMap();
        for (int i = 0; i < this.numCommentLines; ++i) {
            this.commentLine.put(i + 1, it.next());
        }
    }

    public void override(ExportConfig over) {
        if (this.exportable == -1) {
            this.exportable = over.exportable;
        } else if (this.exportable == 1 && over.exportable == 0) {
            this.exportable = 0;
        }
        if (over.width != null) {
            this.width = over.width;
        }
        if (over.numCommentLines != -1) {
            this.numCommentLines = over.numCommentLines;
        }
        for (int i = 1; i <= this.numCommentLines; ++i) {
            String newline = over.commentLine.get(i);
            if (newline == null) continue;
            this.commentLine.put(i, newline);
        }
    }

    public void underride(ExportConfig under) {
        if (this.exportable == -1) {
            this.exportable = under.exportable;
        } else if (this.exportable == 1 && under.exportable == 0) {
            this.exportable = 0;
        }
        if (this.width == null) {
            this.width = under.width;
        }
        if (this.numCommentLines == -1) {
            this.numCommentLines = under.numCommentLines;
        }
        for (int i = 1; i <= this.numCommentLines; ++i) {
            if (this.commentLine.get(i) != null) continue;
            this.commentLine.put(i, under.commentLine.get(i));
        }
    }

    public boolean isExportable() {
        return this.exportable != 0;
    }

    public String[] getComments() {
        if (this.numCommentLines < 1) {
            return null;
        }
        String[] comments = new String[this.numCommentLines];
        for (int i = 0; i < this.numCommentLines; ++i) {
            comments[i] = this.commentLine.get(i + 1);
            if (comments[i] != null) continue;
            comments[i] = "";
        }
        return comments;
    }

    public int[] getFixedWidth() {
        int[] fw = this.width;
        if (fw == null) {
            fw = new int[]{17, 6};
        }
        return fw;
    }

    public List<String> toStringList() {
        ArrayList<String> rep = new ArrayList<String>(this.numCommentLines + 3);
        rep.add("" + this.exportable);
        int[] fw = this.getFixedWidth();
        if (this.width != null) {
            rep.add("" + this.width[0]);
            rep.add("" + this.width[1]);
        } else {
            rep.add("-1");
            rep.add("-1");
        }
        String[] comments = this.getComments();
        if (comments != null) {
            for (String s : comments) {
                rep.add(s);
            }
        }
        return rep;
    }

    public void parameterize(Map<String, String> params) {
        params.put("exportable", "" + this.exportable);
        if (this.width == null) {
            params.put("width.0", "-1");
            params.put("width.1", "-1");
        } else {
            params.put("width.0", "" + this.width[0]);
            params.put("width.1", "" + this.width[1]);
        }
        params.put("numCommentLines", "" + this.numCommentLines);
        String[] comments = this.getComments();
        if (comments != null) {
            int i = 1;
            for (String s : comments) {
                params.put("cmt." + i, s);
                ++i;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed() {
        this.closed = true;
    }
}

