/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;

public class Spectra {
    private final int nfft;
    private final double samplingRate;
    private final double[] frequency;
    private final double[] power;
    public final int length;

    public Spectra(double[] signal, double sr, int nf) {
        this.samplingRate = sr;
        this.nfft = nf;
        double[] transform = new double[this.nfft];
        System.arraycopy(signal, 0, transform, 0, Math.min(transform.length, signal.length));
        DoubleFFT_1D FFT2 = new DoubleFFT_1D(this.nfft);
        FFT2.realForward(transform);
        boolean odd = this.nfft % 2 == 1;
        this.length = odd ? (this.nfft + 1) / 2 : this.nfft / 2 + 1;
        this.power = new double[this.length];
        this.power[0] = Math.abs(transform[0]);
        for (int i = 2; i < this.nfft - 1; i += 2) {
            this.power[i / 2] = Math.sqrt(transform[i] * transform[i] + transform[i + 1] * transform[i + 1]);
        }
        if (odd) {
            if (this.length > 1) {
                this.power[this.length - 1] = Math.sqrt(transform[1] * transform[1] + transform[this.nfft - 1] * transform[this.nfft - 1]);
            }
        } else {
            this.power[this.length - 1] = Math.abs(transform[1]);
        }
        this.frequency = new double[this.length];
        double delta = this.samplingRate / (double)this.nfft;
        for (int i = 0; i < this.length; ++i) {
            this.frequency[i] = delta * (double)i;
        }
    }

    public double getMinPower() {
        return this.getMinPower(0.0, this.samplingRate / 2.0);
    }

    public double getMinPower(double F1, double F2) {
        double MIN = Double.MAX_VALUE;
        for (int i = 0; i < this.length; ++i) {
            if (!(this.power[i] < MIN & this.frequency[i] >= F1 & this.frequency[i] <= F2)) continue;
            MIN = this.power[i];
        }
        return MIN;
    }

    public double getMaxPower() {
        return this.getMaxPower(this.samplingRate / (double)this.nfft, 1.0 / this.samplingRate / 2.0);
    }

    public double getMaxPower(double F1, double F2) {
        double MAX = Double.MIN_VALUE;
        for (int i = 0; i < this.length; ++i) {
            if (!(this.power[i] > MAX & this.frequency[i] >= F1 & this.frequency[i] <= F2)) continue;
            MAX = this.power[i];
        }
        return MAX;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public int getNfft() {
        return this.nfft;
    }

    public double[] getPower() {
        return this.power;
    }

    public double[] getFrequency() {
        return this.frequency;
    }

    public double[][] getMatrix(boolean logPower, boolean logFreq) {
        double[][] output = new double[this.length][2];
        double[] P = this.getPower();
        double[] F = this.getFrequency();
        for (int i = 0; i < this.length; ++i) {
            output[i][0] = logFreq ? Math.log10(F[i]) : F[i];
            output[i][1] = logPower ? Math.log10(P[i]) : P[i];
        }
        return output;
    }
}

