/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.MSeedQueryReader;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringMSeedQueryReader
implements MSeedQueryReader {
    private boolean verbose = false;
    private boolean timed = false;
    public int bytesRead = 0;
    public float seconds = 0.0f;
    private static final Logger logger = LoggerFactory.getLogger(StringMSeedQueryReader.class);

    @Override
    public List<DataRecord> read(String network, String station, String location, String channel, Date begin, Date end) throws IOException, SeisFileException, SeedFormatException {
        String query = this.createQuery(network, station, location, channel, begin, end);
        logger.info("Request: " + query);
        long before = System.currentTimeMillis();
        List<DataRecord> out = this.read(query);
        long after = System.currentTimeMillis();
        if (this.isTimed()) {
            for (DataRecord dr : out) {
                this.bytesRead += dr.getRecordSize();
            }
            this.seconds = (float)(after - before) / 1000.0f;
            System.out.println(this.bytesRead + " bytes in " + this.seconds + " sec (" + (float)(this.bytesRead / 1000) / this.seconds + " kb/s)");
        }
        return out;
    }

    public abstract String createQuery(String var1, String var2, String var3, String var4, Date var5, Date var6);

    public abstract List<DataRecord> read(String var1) throws IOException, SeisFileException, SeedFormatException;

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isTimed() {
        return this.timed;
    }

    @Override
    public void setTimed(boolean timed) {
        this.timed = timed;
    }
}

