/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.DataUsed;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Tensor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MomentTensor {
    public static final String ELEMENT_NAME = "momentTensor";
    String publicId;
    String derivedOriginID;
    String momentMagnitudeID;
    RealQuantity scalarMoment;
    Tensor tensor;
    float doubleCouple;
    float clvd;
    String methodID;
    private DataUsed dataUsed;
    private String category;
    List<Comment> commentList = new ArrayList<Comment>();
    CreationInfo creationInfo;

    public MomentTensor(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttributeIfExists(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("derivedOriginID")) {
                    this.derivedOriginID = StaxUtil.pullText(reader, "derivedOriginID");
                    continue;
                }
                if (elName.equals("momentMagnitudeID")) {
                    this.momentMagnitudeID = StaxUtil.pullText(reader, "momentMagnitudeID");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                if (elName.equals("scalarMoment")) {
                    this.scalarMoment = new RealQuantity(reader, "scalarMoment");
                    continue;
                }
                if (elName.equals("tensor")) {
                    this.tensor = new Tensor(reader);
                    continue;
                }
                if (elName.equals("doubleCouple")) {
                    this.doubleCouple = StaxUtil.pullFloat(reader, "doubleCouple");
                    continue;
                }
                if (elName.equals("clvd")) {
                    this.clvd = StaxUtil.pullFloat(reader, "clvd");
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("category")) {
                    this.category = StaxUtil.pullText(reader, "category");
                    continue;
                }
                if (elName.equals("dataUsed")) {
                    this.dataUsed = new DataUsed(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getDerivedOriginID() {
        return this.derivedOriginID;
    }

    public String getMomentMagnitudeID() {
        return this.momentMagnitudeID;
    }

    public RealQuantity getScalarMoment() {
        return this.scalarMoment;
    }

    public Tensor getTensor() {
        return this.tensor;
    }

    public float getDoubleCouple() {
        return this.doubleCouple;
    }

    public float getClvd() {
        return this.clvd;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public DataUsed getDataUsed() {
        return this.dataUsed;
    }

    public String getCategory() {
        return this.category;
    }
}

