/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.render.DataPointRenderer;
import gov.usgs.plot.render.PointRenderer;
import gov.usgs.plot.render.Renderer;
import gov.usgs.plot.render.ShapeRenderer;
import gov.usgs.plot.transform.IdentityTransformer;
import gov.usgs.plot.transform.Transformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class LegendRenderer
implements Renderer {
    public Transformer transformer;
    public List<LegendEntry> entries = new ArrayList<LegendEntry>();
    public double x;
    public double y;
    public boolean NO_DATA = false;
    public boolean sided_line = false;

    public LegendRenderer() {
    }

    public LegendRenderer(boolean nd) {
        this();
        this.NO_DATA = nd;
    }

    public void addLine(LegendEntry e) {
        this.entries.add(e);
    }

    public void addLine(ShapeRenderer lr, PointRenderer pr, String s) {
        LegendEntry entry = new LegendEntry();
        entry.lineRenderer = lr;
        entry.pointRenderer = pr;
        entry.legend = s;
        entry.no_data = this.NO_DATA;
        this.entries.add(entry);
    }

    @Override
    public void render(Graphics2D g) {
        if (this.transformer == null) {
            this.transformer = new IdentityTransformer();
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        double width = 1.0;
        double height = this.entries.size() * 16;
        int offset = 0;
        Ellipse2D.Double dot = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        for (LegendEntry e : this.entries) {
            if (e.no_data) {
                e.legend = e.legend + " NO DATA";
            }
            width = Math.max(width, (double)fm.stringWidth(e.legend));
            if (e.lineRenderer == null && e.pointRenderer == null) continue;
            offset = 25;
        }
        Paint origPaint = g.getPaint();
        Stroke origStroke = g.getStroke();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setRect(this.x, this.y, width + (double)offset + 13.0, height + 6.0);
        g.setPaint(new Color(255, 255, 255, 192));
        g.fill(rect);
        g.setPaint(Color.black);
        g.draw(rect);
        Line2D.Double line = new Line2D.Double();
        for (int i = 0; i < this.entries.size(); ++i) {
            LegendEntry e = this.entries.get(i);
            if (e.lineRenderer != null) {
                if (this.sided_line) {
                    line.setLine(this.x + 2.0, this.y + (double)(16 * (i + 1)) - 5.0, this.x + 11.0, this.y + (double)(16 * (i + 1)) - 5.0);
                } else {
                    line.setLine(this.x + 3.0, this.y + (double)(16 * (i + 1)) - 5.0, this.x + 28.0, this.y + (double)(16 * (i + 1)) - 5.0);
                }
                if (e.lineRenderer.stroke != null) {
                    g.setStroke(e.lineRenderer.stroke);
                }
                if (e.lineRenderer.color != null) {
                    g.setPaint(e.lineRenderer.color);
                }
                g.draw(line);
            }
            if (e.pointRenderer != null && e.pointRenderer instanceof DataPointRenderer) {
                DataPointRenderer odpr = (DataPointRenderer)e.pointRenderer;
                DataPointRenderer ndpr = new DataPointRenderer();
                ndpr.shape = odpr.shape;
                ndpr.color = odpr.color;
                ndpr.stroke = odpr.stroke;
                ndpr.filled = odpr.filled;
                ndpr.fillColor = odpr.fillColor;
                ndpr.x = this.x + 18.0;
                ndpr.y = this.y + (double)(16 * (i + 1)) - 5.0;
                if (odpr.shape.equals(dot)) {
                    ndpr.stroke = new BasicStroke(5.0f);
                }
                ndpr.render(g);
            }
            g.setPaint(origPaint);
            g.setStroke(origStroke);
            g.drawString(e.legend, (float)this.x + 8.0f + (float)offset, (float)this.y + (float)(16 * (i + 1)));
        }
        g.setStroke(origStroke);
        g.setPaint(origPaint);
    }

    public class LegendEntry {
        public ShapeRenderer lineRenderer;
        public PointRenderer pointRenderer;
        String legend;
        public boolean no_data = false;

        public LegendEntry() {
        }

        public LegendEntry(String s) {
            this.legend = s;
        }
    }
}

